/*
 * Decompiled with CFR 0.152.
 */
package com.mineplex.studio.dataplane.common.guild.exception;

import com.mineplex.studio.dataplane.common.guild.exception.GuildException;
import com.mineplex.studio.dataplane.common.guild.model.GuildPermission;
import com.mineplex.studio.dataplane.common.guild.model.MinimalGuild;
import com.mineplex.studio.dataplane.common.profile.model.PlayerIdentity;
import lombok.Generated;
import lombok.NonNull;

public class GuildPermissionTargetException
extends GuildException {
    private static final long serialVersionUID = 9153386476129150482L;
    @NonNull
    private final PlayerIdentity player;
    @NonNull
    private final PlayerIdentity target;
    @NonNull
    private final MinimalGuild guild;
    @NonNull
    private final GuildPermission permission;

    public GuildPermissionTargetException(@NonNull PlayerIdentity player, @NonNull PlayerIdentity target, @NonNull MinimalGuild guild, @NonNull GuildPermission permission) {
        super(String.valueOf(player.getId()) + " does not have permission " + permission.name() + " to perform this action against " + String.valueOf(target.getId()) + " in guild: " + guild.getId());
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (guild == null) {
            throw new NullPointerException("guild is marked non-null but is null");
        }
        if (permission == null) {
            throw new NullPointerException("permission is marked non-null but is null");
        }
        this.player = player;
        this.target = target;
        this.guild = guild;
        this.permission = permission;
    }

    @NonNull
    @Generated
    public PlayerIdentity getPlayer() {
        return this.player;
    }

    @NonNull
    @Generated
    public PlayerIdentity getTarget() {
        return this.target;
    }

    @NonNull
    @Generated
    public MinimalGuild getGuild() {
        return this.guild;
    }

    @NonNull
    @Generated
    public GuildPermission getPermission() {
        return this.permission;
    }
}

