/*
 * Decompiled with CFR 0.152.
 */
package com.mineplex.studio.dataplane.common.guild.exception;

import com.mineplex.studio.dataplane.common.guild.exception.GuildException;
import com.mineplex.studio.dataplane.common.guild.model.GuildRole;
import com.mineplex.studio.dataplane.common.guild.model.MinimalGuild;
import com.mineplex.studio.dataplane.common.profile.model.PlayerIdentity;
import lombok.Generated;
import lombok.NonNull;

public class GuildRoleLimitException
extends GuildException {
    private static final long serialVersionUID = 1430300589756831863L;
    @NonNull
    private final PlayerIdentity player;
    @NonNull
    private final MinimalGuild guild;
    @NonNull
    private final GuildRole role;
    private final int maxMembers;

    public GuildRoleLimitException(@NonNull PlayerIdentity player, @NonNull MinimalGuild guild, @NonNull GuildRole role, int maxMembers) {
        super("Reached the maximum number of members for role: " + role.name() + " in guild: " + guild.getId() + ". Max: " + maxMembers);
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (guild == null) {
            throw new NullPointerException("guild is marked non-null but is null");
        }
        if (role == null) {
            throw new NullPointerException("role is marked non-null but is null");
        }
        this.player = player;
        this.guild = guild;
        this.role = role;
        this.maxMembers = maxMembers;
    }

    @NonNull
    @Generated
    public PlayerIdentity getPlayer() {
        return this.player;
    }

    @NonNull
    @Generated
    public MinimalGuild getGuild() {
        return this.guild;
    }

    @NonNull
    @Generated
    public GuildRole getRole() {
        return this.role;
    }

    @Generated
    public int getMaxMembers() {
        return this.maxMembers;
    }
}

