/*
 * Decompiled with CFR 0.152.
 */
package com.mineplex.studio.dataplane.common.guild.exception;

import com.mineplex.studio.dataplane.common.guild.exception.GuildException;
import com.mineplex.studio.dataplane.common.guild.model.MinimalGuild;
import com.mineplex.studio.dataplane.common.profile.model.PlayerIdentity;
import lombok.Generated;
import lombok.NonNull;

public class NotGuildMemberException
extends GuildException {
    private static final long serialVersionUID = -4455475866005999364L;
    @NonNull
    private final PlayerIdentity player;
    @NonNull
    private final MinimalGuild guild;

    public NotGuildMemberException(@NonNull PlayerIdentity player, @NonNull MinimalGuild guild) {
        super("Player " + String.valueOf(player.getId()) + " is not a member of guild: " + guild.getId());
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (guild == null) {
            throw new NullPointerException("guild is marked non-null but is null");
        }
        this.player = player;
        this.guild = guild;
    }

    @NonNull
    @Generated
    public PlayerIdentity getPlayer() {
        return this.player;
    }

    @NonNull
    @Generated
    public MinimalGuild getGuild() {
        return this.guild;
    }
}

