/*
 * Decompiled with CFR 0.152.
 */
package com.mineplex.studio.dataplane.common.guild.exception;

import com.mineplex.studio.dataplane.common.guild.exception.GuildException;
import com.mineplex.studio.dataplane.common.profile.model.PlayerIdentity;
import java.util.Locale;
import lombok.Generated;
import lombok.NonNull;

public class PlayerGuildLimitException
extends GuildException {
    private static final long serialVersionUID = 5476995147412635411L;
    @NonNull
    private final PlayerIdentity player;
    @NonNull
    private final LimitType limitType;
    private final int limit;

    public PlayerGuildLimitException(@NonNull PlayerIdentity player, @NonNull LimitType limitType, int limit) {
        super("Player " + String.valueOf(player.getId()) + " has reached the maximum number of " + limitType.name().toLowerCase(Locale.ENGLISH) + " guilds of " + limit);
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (limitType == null) {
            throw new NullPointerException("limitType is marked non-null but is null");
        }
        this.player = player;
        this.limitType = limitType;
        this.limit = limit;
    }

    @NonNull
    @Generated
    public PlayerIdentity getPlayer() {
        return this.player;
    }

    @NonNull
    @Generated
    public LimitType getLimitType() {
        return this.limitType;
    }

    @Generated
    public int getLimit() {
        return this.limit;
    }

    public static enum LimitType {
        OWNERSHIP,
        MEMBERSHIP,
        TOTAL;

    }
}

