/*
 * Decompiled with CFR 0.152.
 */
package com.mineplex.studio.dataplane.common.guild.message;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.mineplex.studio.dataplane.common.guild.message.issuer.GuildChangeIssuer;
import com.mineplex.studio.dataplane.common.guild.model.Guild;
import com.mineplex.studio.dataplane.common.guild.model.GuildRole;
import com.mineplex.studio.dataplane.common.profile.model.PlayerIdentity;
import java.util.Optional;
import javax.annotation.Nullable;
import lombok.Generated;
import lombok.NonNull;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=GuildMemberRoleUpdateMessageBuilder.class)
public final class GuildMemberRoleUpdateMessage {
    public static final String MESSAGE_CHANNEL = "guild-member-role-update";
    @NonNull
    private final Guild guild;
    @NonNull
    private final PlayerIdentity member;
    @Nullable
    private final GuildRole previousRole;
    @NonNull
    private final GuildRole newRole;
    @NonNull
    private final GuildChangeIssuer issuer;

    public Optional<GuildRole> getPreviousRole() {
        return Optional.ofNullable(this.previousRole);
    }

    @Generated
    GuildMemberRoleUpdateMessage(@NonNull Guild guild, @NonNull PlayerIdentity member, @Nullable GuildRole previousRole, @NonNull GuildRole newRole, @NonNull GuildChangeIssuer issuer) {
        if (guild == null) {
            throw new NullPointerException("guild is marked non-null but is null");
        }
        if (member == null) {
            throw new NullPointerException("member is marked non-null but is null");
        }
        if (newRole == null) {
            throw new NullPointerException("newRole is marked non-null but is null");
        }
        if (issuer == null) {
            throw new NullPointerException("issuer is marked non-null but is null");
        }
        this.guild = guild;
        this.member = member;
        this.previousRole = previousRole;
        this.newRole = newRole;
        this.issuer = issuer;
    }

    @Generated
    public static GuildMemberRoleUpdateMessageBuilder builder() {
        return new GuildMemberRoleUpdateMessageBuilder();
    }

    @NonNull
    @Generated
    public Guild getGuild() {
        return this.guild;
    }

    @NonNull
    @Generated
    public PlayerIdentity getMember() {
        return this.member;
    }

    @NonNull
    @Generated
    public GuildRole getNewRole() {
        return this.newRole;
    }

    @NonNull
    @Generated
    public GuildChangeIssuer getIssuer() {
        return this.issuer;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GuildMemberRoleUpdateMessage)) {
            return false;
        }
        GuildMemberRoleUpdateMessage other = (GuildMemberRoleUpdateMessage)o;
        Guild this$guild = this.getGuild();
        Guild other$guild = other.getGuild();
        if (this$guild == null ? other$guild != null : !((Object)this$guild).equals(other$guild)) {
            return false;
        }
        PlayerIdentity this$member = this.getMember();
        PlayerIdentity other$member = other.getMember();
        if (this$member == null ? other$member != null : !((Object)this$member).equals(other$member)) {
            return false;
        }
        Optional<GuildRole> this$previousRole = this.getPreviousRole();
        Optional<GuildRole> other$previousRole = other.getPreviousRole();
        if (this$previousRole == null ? other$previousRole != null : !((Object)this$previousRole).equals(other$previousRole)) {
            return false;
        }
        GuildRole this$newRole = this.getNewRole();
        GuildRole other$newRole = other.getNewRole();
        if (this$newRole == null ? other$newRole != null : !((Object)((Object)this$newRole)).equals((Object)other$newRole)) {
            return false;
        }
        GuildChangeIssuer this$issuer = this.getIssuer();
        GuildChangeIssuer other$issuer = other.getIssuer();
        return !(this$issuer == null ? other$issuer != null : !this$issuer.equals(other$issuer));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Guild $guild = this.getGuild();
        result = result * 59 + ($guild == null ? 43 : ((Object)$guild).hashCode());
        PlayerIdentity $member = this.getMember();
        result = result * 59 + ($member == null ? 43 : ((Object)$member).hashCode());
        Optional<GuildRole> $previousRole = this.getPreviousRole();
        result = result * 59 + ($previousRole == null ? 43 : ((Object)$previousRole).hashCode());
        GuildRole $newRole = this.getNewRole();
        result = result * 59 + ($newRole == null ? 43 : ((Object)((Object)$newRole)).hashCode());
        GuildChangeIssuer $issuer = this.getIssuer();
        result = result * 59 + ($issuer == null ? 43 : $issuer.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "GuildMemberRoleUpdateMessage(guild=" + String.valueOf(this.getGuild()) + ", member=" + String.valueOf(this.getMember()) + ", previousRole=" + String.valueOf(this.getPreviousRole()) + ", newRole=" + String.valueOf((Object)this.getNewRole()) + ", issuer=" + String.valueOf(this.getIssuer()) + ")";
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    public static class GuildMemberRoleUpdateMessageBuilder {
        @Generated
        private Guild guild;
        @Generated
        private PlayerIdentity member;
        @Generated
        private GuildRole previousRole;
        @Generated
        private GuildRole newRole;
        @Generated
        private GuildChangeIssuer issuer;

        @Generated
        GuildMemberRoleUpdateMessageBuilder() {
        }

        @Generated
        public GuildMemberRoleUpdateMessageBuilder guild(@NonNull Guild guild) {
            if (guild == null) {
                throw new NullPointerException("guild is marked non-null but is null");
            }
            this.guild = guild;
            return this;
        }

        @Generated
        public GuildMemberRoleUpdateMessageBuilder member(@NonNull PlayerIdentity member) {
            if (member == null) {
                throw new NullPointerException("member is marked non-null but is null");
            }
            this.member = member;
            return this;
        }

        @Generated
        public GuildMemberRoleUpdateMessageBuilder previousRole(@Nullable GuildRole previousRole) {
            this.previousRole = previousRole;
            return this;
        }

        @Generated
        public GuildMemberRoleUpdateMessageBuilder newRole(@NonNull GuildRole newRole) {
            if (newRole == null) {
                throw new NullPointerException("newRole is marked non-null but is null");
            }
            this.newRole = newRole;
            return this;
        }

        @Generated
        public GuildMemberRoleUpdateMessageBuilder issuer(@NonNull GuildChangeIssuer issuer) {
            if (issuer == null) {
                throw new NullPointerException("issuer is marked non-null but is null");
            }
            this.issuer = issuer;
            return this;
        }

        @Generated
        public GuildMemberRoleUpdateMessage build() {
            return new GuildMemberRoleUpdateMessage(this.guild, this.member, this.previousRole, this.newRole, this.issuer);
        }

        @Generated
        public String toString() {
            return "GuildMemberRoleUpdateMessage.GuildMemberRoleUpdateMessageBuilder(guild=" + String.valueOf(this.guild) + ", member=" + String.valueOf(this.member) + ", previousRole=" + String.valueOf((Object)this.previousRole) + ", newRole=" + String.valueOf((Object)this.newRole) + ", issuer=" + String.valueOf(this.issuer) + ")";
        }
    }
}

