/*
 * Decompiled with CFR 0.152.
 */
package com.mineplex.studio.dataplane.common.guild.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.mineplex.studio.dataplane.common.guild.GuildCommon;
import com.mineplex.studio.dataplane.common.guild.exception.AlreadyGuildMemberException;
import com.mineplex.studio.dataplane.common.guild.exception.AlreadyGuildOwnerException;
import com.mineplex.studio.dataplane.common.guild.exception.AlreadyInvitedToGuildException;
import com.mineplex.studio.dataplane.common.guild.exception.AlreadyRequestingToJoinException;
import com.mineplex.studio.dataplane.common.guild.exception.CantJoinRequestGuildException;
import com.mineplex.studio.dataplane.common.guild.exception.DirectOwnerAssignmentException;
import com.mineplex.studio.dataplane.common.guild.exception.GuildFullException;
import com.mineplex.studio.dataplane.common.guild.exception.GuildOwnerModificationException;
import com.mineplex.studio.dataplane.common.guild.exception.GuildPermissionException;
import com.mineplex.studio.dataplane.common.guild.exception.GuildPermissionTargetException;
import com.mineplex.studio.dataplane.common.guild.exception.GuildRoleLimitException;
import com.mineplex.studio.dataplane.common.guild.exception.NotGuildMemberException;
import com.mineplex.studio.dataplane.common.guild.exception.NotInvitedToGuildException;
import com.mineplex.studio.dataplane.common.guild.exception.NotRequestingToJoinGuildException;
import com.mineplex.studio.dataplane.common.guild.exception.OwnerLeaveGuildException;
import com.mineplex.studio.dataplane.common.guild.exception.PlayerGuildLimitException;
import com.mineplex.studio.dataplane.common.guild.model.GuildAccess;
import com.mineplex.studio.dataplane.common.guild.model.GuildInvitedPlayer;
import com.mineplex.studio.dataplane.common.guild.model.GuildJoinRequestedPlayer;
import com.mineplex.studio.dataplane.common.guild.model.GuildMemberProperties;
import com.mineplex.studio.dataplane.common.guild.model.GuildPermission;
import com.mineplex.studio.dataplane.common.guild.model.GuildPermissionContext;
import com.mineplex.studio.dataplane.common.guild.model.GuildPlayer;
import com.mineplex.studio.dataplane.common.guild.model.GuildRole;
import com.mineplex.studio.dataplane.common.guild.model.MinimalGuild;
import com.mineplex.studio.dataplane.common.guild.model.PlayerGuildInformation;
import com.mineplex.studio.dataplane.common.profile.model.PlayerIdentity;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nullable;
import lombok.Generated;
import lombok.NonNull;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=GuildBuilder.class)
public class Guild {
    @Generated
    private final ReadWriteLock $lock = new ReentrantReadWriteLock();
    private final transient ReadWriteLock lock = new ReentrantReadWriteLock();
    @NonNull
    private final transient Validator validator = new Validator();
    @NonNull
    private final String id;
    @NonNull
    private String name;
    @NonNull
    private GuildAccess access;
    @NonNull
    private final @NonNull Map<GuildRole, @NonNull Map<@NonNull GuildPermission, GuildPermissionContext>> rolePermissions;
    @NonNull
    private final Map<UUID, GuildPlayer> membersMap;
    @NonNull
    private final Map<UUID, GuildInvitedPlayer> invitedMap;
    @NonNull
    private final Map<UUID, GuildJoinRequestedPlayer> joinRequested;
    @NonNull
    private final GuildMemberProperties memberProperties;
    private long totalExperience;
    private int level;

    @NonNull
    public Map<GuildRole, Map<GuildPermission, GuildPermissionContext>> getRolePermissions() {
        this.lock.readLock().lock();
        try {
            Map<GuildRole, Map<GuildPermission, GuildPermissionContext>> map = Map.copyOf(this.rolePermissions);
            return map;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @JsonIgnore
    public List<GuildPlayer> getMembers() {
        this.lock.readLock().lock();
        try {
            List<GuildPlayer> list = List.copyOf(this.membersMap.values());
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @JsonIgnore
    public List<GuildInvitedPlayer> getInvitedPlayers() {
        this.lock.readLock().lock();
        try {
            List<GuildInvitedPlayer> list = List.copyOf(this.invitedMap.values());
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public List<GuildJoinRequestedPlayer> getJoinRequestedPlayers() {
        this.$lock.readLock().lock();
        try {
            List<GuildJoinRequestedPlayer> list = List.copyOf(this.joinRequested.values());
            return list;
        }
        finally {
            this.$lock.readLock().unlock();
        }
    }

    public Optional<GuildPlayer> getMember(@NonNull UUID playerId) {
        this.lock.readLock().lock();
        try {
            if (playerId == null) {
                throw new NullPointerException("playerId is marked non-null but is null");
            }
            Optional<GuildPlayer> optional = Optional.ofNullable(this.membersMap.get(playerId));
            return optional;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public GuildPlayer getMemberOrThrow(@NonNull PlayerIdentity player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        return this.getMember(player.getId()).orElseThrow(() -> new NotGuildMemberException(player, MinimalGuild.fromGuild(this)));
    }

    public boolean isMember(@NonNull UUID playerId) {
        this.lock.readLock().lock();
        try {
            if (playerId == null) {
                throw new NullPointerException("playerId is marked non-null but is null");
            }
            boolean bl = this.membersMap.containsKey(playerId);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void addMember(@NonNull GuildPlayer player) {
        this.lock.writeLock().lock();
        try {
            if (player == null) {
                throw new NullPointerException("player is marked non-null but is null");
            }
            this.membersMap.put(player.getPlayer().getId(), player);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void removeMember(@NonNull UUID playerId) {
        this.lock.writeLock().lock();
        try {
            if (playerId == null) {
                throw new NullPointerException("playerId is marked non-null but is null");
            }
            this.membersMap.remove(playerId);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public Optional<GuildInvitedPlayer> getInvitedPlayer(@NonNull UUID playerId) {
        this.lock.readLock().lock();
        try {
            if (playerId == null) {
                throw new NullPointerException("playerId is marked non-null but is null");
            }
            Optional<GuildInvitedPlayer> optional = Optional.ofNullable(this.invitedMap.get(playerId));
            return optional;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void addInvitedPlayer(@NonNull GuildInvitedPlayer player) {
        this.lock.writeLock().lock();
        try {
            if (player == null) {
                throw new NullPointerException("player is marked non-null but is null");
            }
            this.invitedMap.put(player.getIdentity().getId(), player);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void removeInvitedPlayer(@NonNull UUID playerId) {
        this.lock.writeLock().lock();
        try {
            if (playerId == null) {
                throw new NullPointerException("playerId is marked non-null but is null");
            }
            this.invitedMap.remove(playerId);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public boolean isInvited(@NonNull UUID playerId) {
        this.lock.readLock().lock();
        try {
            if (playerId == null) {
                throw new NullPointerException("playerId is marked non-null but is null");
            }
            boolean bl = this.invitedMap.containsKey(playerId);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Optional<GuildJoinRequestedPlayer> getJoinRequestedPlayer(@NonNull UUID playerId) {
        this.lock.readLock().lock();
        try {
            if (playerId == null) {
                throw new NullPointerException("playerId is marked non-null but is null");
            }
            Optional<GuildJoinRequestedPlayer> optional = Optional.ofNullable(this.joinRequested.get(playerId));
            return optional;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void addJoinRequestedPlayer(@NonNull GuildJoinRequestedPlayer player) {
        this.lock.writeLock().lock();
        try {
            if (player == null) {
                throw new NullPointerException("player is marked non-null but is null");
            }
            this.joinRequested.put(player.getIdentity().getId(), player);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void removeJoinRequestedPlayer(@NonNull UUID playerId) {
        this.lock.writeLock().lock();
        try {
            if (playerId == null) {
                throw new NullPointerException("playerId is marked non-null but is null");
            }
            this.joinRequested.remove(playerId);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public boolean isJoinRequested(@NonNull UUID playerId) {
        this.lock.readLock().lock();
        try {
            if (playerId == null) {
                throw new NullPointerException("playerId is marked non-null but is null");
            }
            boolean bl = this.joinRequested.containsKey(playerId);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<GuildPermissionContext> getPermissionContext(@NonNull GuildRole role, @NonNull GuildPermission permission) {
        this.lock.readLock().lock();
        try {
            if (role == null) {
                throw new NullPointerException("role is marked non-null but is null");
            }
            if (permission == null) {
                throw new NullPointerException("permission is marked non-null but is null");
            }
            Map<GuildPermission, GuildPermissionContext> permissions = this.rolePermissions.get((Object)role);
            if (permissions == null) {
                Optional<GuildPermissionContext> optional = Optional.empty();
                return optional;
            }
            Optional<GuildPermissionContext> optional = Optional.ofNullable(permissions.get((Object)permission));
            return optional;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setPermissionContext(@NonNull GuildPermissionContext context) {
        this.lock.writeLock().lock();
        try {
            if (context == null) {
                throw new NullPointerException("context is marked non-null but is null");
            }
            GuildRole role = context.getRole();
            GuildPermission permission = context.getPermission();
            Map permissions = this.rolePermissions.computeIfAbsent(role, k -> new EnumMap(GuildPermission.class));
            permissions.put(permission, context);
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removePermissionContext(@NonNull GuildPermissionContext context) {
        this.lock.writeLock().lock();
        try {
            if (context == null) {
                throw new NullPointerException("context is marked non-null but is null");
            }
            GuildRole role = context.getRole();
            GuildPermission permission = context.getPermission();
            Map<GuildPermission, GuildPermissionContext> permissions = this.rolePermissions.get((Object)role);
            if (permissions == null) {
                boolean bl = false;
                return bl;
            }
            GuildPermissionContext removedContext = permissions.remove((Object)permission);
            if (removedContext == null) {
                boolean bl = false;
                return bl;
            }
            if (permissions.isEmpty()) {
                this.rolePermissions.remove((Object)role);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @JsonIgnore
    public List<GuildPermissionContext> getAllPermissionContexts() {
        this.lock.readLock().lock();
        try {
            List<GuildPermissionContext> list = this.rolePermissions.values().stream().flatMap(rolePermissions -> rolePermissions.values().stream()).toList();
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasPermission(@NonNull UUID requestingPlayerId, @NonNull GuildPermission permission) {
        this.lock.readLock().lock();
        try {
            if (requestingPlayerId == null) {
                throw new NullPointerException("requestingPlayerId is marked non-null but is null");
            }
            if (permission == null) {
                throw new NullPointerException("permission is marked non-null but is null");
            }
            boolean bl = this.getMember(requestingPlayerId).flatMap(requestingPlayer -> this.getPermissionContext(requestingPlayer.getRole(), permission)).isPresent();
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean hasPermissionForTarget(@NonNull UUID requestingPlayerId, @NonNull UUID targetPlayerId, @NonNull GuildPermission permission) {
        if (requestingPlayerId == null) {
            throw new NullPointerException("requestingPlayerId is marked non-null but is null");
        }
        if (targetPlayerId == null) {
            throw new NullPointerException("targetPlayerId is marked non-null but is null");
        }
        if (permission == null) {
            throw new NullPointerException("permission is marked non-null but is null");
        }
        Optional<GuildPlayer> requestingPlayerOpt = this.getMember(requestingPlayerId);
        if (requestingPlayerOpt.isEmpty()) {
            return false;
        }
        Optional<GuildPlayer> targetPlayerOpt = this.getMember(targetPlayerId);
        if (targetPlayerOpt.isEmpty()) {
            return false;
        }
        GuildPlayer requestingPlayer = requestingPlayerOpt.get();
        Optional<GuildPermissionContext> requestingPermissionContext = this.getPermissionContext(requestingPlayer.getRole(), permission);
        if (requestingPermissionContext.isEmpty()) {
            return false;
        }
        GuildPermissionContext context = requestingPermissionContext.get();
        return context.getTarget().canTarget(targetPlayerOpt.get(), requestingPlayer);
    }

    @JsonIgnore
    public boolean canDirectlyJoin() {
        return this.getAccess() == GuildAccess.PUBLIC;
    }

    public boolean canLeave(@NonNull UUID playerId) {
        if (playerId == null) {
            throw new NullPointerException("playerId is marked non-null but is null");
        }
        return this.getMember(playerId).map(GuildPlayer::getRole).map(role -> role != GuildRole.OWNER).orElse(false);
    }

    public List<GuildPlayer> getMembersByRole(@NonNull GuildRole role) {
        this.lock.readLock().lock();
        try {
            if (role == null) {
                throw new NullPointerException("role is marked non-null but is null");
            }
            List<GuildPlayer> list = this.membersMap.values().stream().filter(member -> member.getRole() == role).toList();
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public int getMemberCountByRole(@NonNull GuildRole role) {
        this.lock.readLock().lock();
        try {
            if (role == null) {
                throw new NullPointerException("role is marked non-null but is null");
            }
            int n = (int)this.membersMap.values().stream().filter(member -> member.getRole() == role).count();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @JsonIgnore
    public int getMemberCount() {
        this.lock.readLock().lock();
        try {
            int n = this.membersMap.size();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @JsonIgnore
    public boolean isFull() {
        return this.getMemberCount() >= this.getMemberProperties().getMaxMembers();
    }

    public boolean canAssignRole(@NonNull GuildRole role) {
        if (role == null) {
            throw new NullPointerException("role is marked non-null but is null");
        }
        return this.getMemberProperties().getMemberLimit(role) > this.getMemberCountByRole(role);
    }

    @NonNull
    public @NonNull Optional<@NonNull GuildRole> findLowerApplicableRole(@NonNull GuildRole currentRole) {
        if (currentRole == null) {
            throw new NullPointerException("currentRole is marked non-null but is null");
        }
        GuildRole lowerRole = currentRole.getLowerRole().orElse(null);
        while (lowerRole != null) {
            if (!lowerRole.isSpecialRank() && this.canAssignRole(lowerRole)) {
                return Optional.of(lowerRole);
            }
            lowerRole = lowerRole.getLowerRole().orElse(null);
        }
        return Optional.empty();
    }

    @NonNull
    public Optional<GuildRole> findHigherApplicableRole(@NonNull GuildRole currentRole) {
        if (currentRole == null) {
            throw new NullPointerException("currentRole is marked non-null but is null");
        }
        GuildRole higherRole = currentRole.getHigherRole().orElse(null);
        while (higherRole != null) {
            if (!higherRole.isSpecialRank() && this.canAssignRole(higherRole)) {
                return Optional.of(higherRole);
            }
            higherRole = higherRole.getHigherRole().orElse(null);
        }
        return Optional.empty();
    }

    @Generated
    Guild(@NonNull String id, @NonNull String name, @NonNull GuildAccess access, @NonNull @NonNull Map<GuildRole, @NonNull Map<@NonNull GuildPermission, GuildPermissionContext>> rolePermissions, @NonNull Map<UUID, GuildPlayer> membersMap, @NonNull Map<UUID, GuildInvitedPlayer> invitedMap, @NonNull Map<UUID, GuildJoinRequestedPlayer> joinRequested, @NonNull GuildMemberProperties memberProperties, long totalExperience, int level) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (access == null) {
            throw new NullPointerException("access is marked non-null but is null");
        }
        if (rolePermissions == null) {
            throw new NullPointerException("rolePermissions is marked non-null but is null");
        }
        if (membersMap == null) {
            throw new NullPointerException("membersMap is marked non-null but is null");
        }
        if (invitedMap == null) {
            throw new NullPointerException("invitedMap is marked non-null but is null");
        }
        if (joinRequested == null) {
            throw new NullPointerException("joinRequested is marked non-null but is null");
        }
        if (memberProperties == null) {
            throw new NullPointerException("memberProperties is marked non-null but is null");
        }
        this.id = id;
        this.name = name;
        this.access = access;
        this.rolePermissions = rolePermissions;
        this.membersMap = membersMap;
        this.invitedMap = invitedMap;
        this.joinRequested = joinRequested;
        this.memberProperties = memberProperties;
        this.totalExperience = totalExperience;
        this.level = level;
    }

    @Generated
    public static GuildBuilder builder() {
        return new GuildBuilder();
    }

    @Generated
    public GuildBuilder toBuilder() {
        return new GuildBuilder().id(this.id).name(this.name).access(this.access).rolePermissions(this.rolePermissions).membersMap(this.membersMap).invitedMap(this.invitedMap).joinRequested(this.joinRequested).memberProperties(this.memberProperties).totalExperience(this.totalExperience).level(this.level);
    }

    @Generated
    public ReadWriteLock getLock() {
        return this.lock;
    }

    @NonNull
    @Generated
    public Validator getValidator() {
        return this.validator;
    }

    @NonNull
    @Generated
    public String getId() {
        return this.id;
    }

    @NonNull
    @Generated
    public String getName() {
        return this.name;
    }

    @NonNull
    @Generated
    public GuildAccess getAccess() {
        return this.access;
    }

    @NonNull
    @Generated
    public Map<UUID, GuildPlayer> getMembersMap() {
        return this.membersMap;
    }

    @NonNull
    @Generated
    public Map<UUID, GuildInvitedPlayer> getInvitedMap() {
        return this.invitedMap;
    }

    @NonNull
    @Generated
    public Map<UUID, GuildJoinRequestedPlayer> getJoinRequested() {
        return this.joinRequested;
    }

    @NonNull
    @Generated
    public GuildMemberProperties getMemberProperties() {
        return this.memberProperties;
    }

    @Generated
    public long getTotalExperience() {
        return this.totalExperience;
    }

    @Generated
    public int getLevel() {
        return this.level;
    }

    @Generated
    public void setName(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.name = name;
    }

    @Generated
    public void setAccess(@NonNull GuildAccess access) {
        if (access == null) {
            throw new NullPointerException("access is marked non-null but is null");
        }
        this.access = access;
    }

    @Generated
    public void setTotalExperience(long totalExperience) {
        this.totalExperience = totalExperience;
    }

    @Generated
    public void setLevel(int level) {
        this.level = level;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Guild)) {
            return false;
        }
        Guild other = (Guild)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTotalExperience() != other.getTotalExperience()) {
            return false;
        }
        if (this.getLevel() != other.getLevel()) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        GuildAccess this$access = this.getAccess();
        GuildAccess other$access = other.getAccess();
        if (this$access == null ? other$access != null : !((Object)((Object)this$access)).equals((Object)other$access)) {
            return false;
        }
        Map<GuildRole, Map<GuildPermission, GuildPermissionContext>> this$rolePermissions = this.getRolePermissions();
        Map<GuildRole, Map<GuildPermission, GuildPermissionContext>> other$rolePermissions = other.getRolePermissions();
        if (this$rolePermissions == null ? other$rolePermissions != null : !((Object)this$rolePermissions).equals(other$rolePermissions)) {
            return false;
        }
        Map<UUID, GuildPlayer> this$membersMap = this.getMembersMap();
        Map<UUID, GuildPlayer> other$membersMap = other.getMembersMap();
        if (this$membersMap == null ? other$membersMap != null : !((Object)this$membersMap).equals(other$membersMap)) {
            return false;
        }
        Map<UUID, GuildInvitedPlayer> this$invitedMap = this.getInvitedMap();
        Map<UUID, GuildInvitedPlayer> other$invitedMap = other.getInvitedMap();
        if (this$invitedMap == null ? other$invitedMap != null : !((Object)this$invitedMap).equals(other$invitedMap)) {
            return false;
        }
        Map<UUID, GuildJoinRequestedPlayer> this$joinRequested = this.getJoinRequested();
        Map<UUID, GuildJoinRequestedPlayer> other$joinRequested = other.getJoinRequested();
        if (this$joinRequested == null ? other$joinRequested != null : !((Object)this$joinRequested).equals(other$joinRequested)) {
            return false;
        }
        GuildMemberProperties this$memberProperties = this.getMemberProperties();
        GuildMemberProperties other$memberProperties = other.getMemberProperties();
        return !(this$memberProperties == null ? other$memberProperties != null : !((Object)this$memberProperties).equals(other$memberProperties));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Guild;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $totalExperience = this.getTotalExperience();
        result = result * 59 + (int)($totalExperience >>> 32 ^ $totalExperience);
        result = result * 59 + this.getLevel();
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        GuildAccess $access = this.getAccess();
        result = result * 59 + ($access == null ? 43 : ((Object)((Object)$access)).hashCode());
        Map<GuildRole, Map<GuildPermission, GuildPermissionContext>> $rolePermissions = this.getRolePermissions();
        result = result * 59 + ($rolePermissions == null ? 43 : ((Object)$rolePermissions).hashCode());
        Map<UUID, GuildPlayer> $membersMap = this.getMembersMap();
        result = result * 59 + ($membersMap == null ? 43 : ((Object)$membersMap).hashCode());
        Map<UUID, GuildInvitedPlayer> $invitedMap = this.getInvitedMap();
        result = result * 59 + ($invitedMap == null ? 43 : ((Object)$invitedMap).hashCode());
        Map<UUID, GuildJoinRequestedPlayer> $joinRequested = this.getJoinRequested();
        result = result * 59 + ($joinRequested == null ? 43 : ((Object)$joinRequested).hashCode());
        GuildMemberProperties $memberProperties = this.getMemberProperties();
        result = result * 59 + ($memberProperties == null ? 43 : ((Object)$memberProperties).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Guild(lock=" + String.valueOf(this.getLock()) + ", validator=" + String.valueOf(this.getValidator()) + ", id=" + this.getId() + ", name=" + this.getName() + ", access=" + String.valueOf((Object)this.getAccess()) + ", rolePermissions=" + String.valueOf(this.getRolePermissions()) + ", membersMap=" + String.valueOf(this.getMembersMap()) + ", invitedMap=" + String.valueOf(this.getInvitedMap()) + ", joinRequested=" + String.valueOf(this.getJoinRequested()) + ", memberProperties=" + String.valueOf(this.getMemberProperties()) + ", totalExperience=" + this.getTotalExperience() + ", level=" + this.getLevel() + ")";
    }

    public class Validator {
        public void verifyCallerPermission(@Nullable PlayerIdentity requestingPlayer, @NonNull GuildPermission permission) {
            if (permission == null) {
                throw new NullPointerException("permission is marked non-null but is null");
            }
            if (requestingPlayer == null) {
                return;
            }
            if (!Guild.this.hasPermission(requestingPlayer.getId(), permission)) {
                throw new GuildPermissionException(requestingPlayer, MinimalGuild.fromGuild(Guild.this), permission);
            }
        }

        public void verifyCallerPermissionForTarget(@Nullable PlayerIdentity requestingPlayer, @NonNull PlayerIdentity targetPlayer, @NonNull GuildPermission requiredPermission) {
            if (targetPlayer == null) {
                throw new NullPointerException("targetPlayer is marked non-null but is null");
            }
            if (requiredPermission == null) {
                throw new NullPointerException("requiredPermission is marked non-null but is null");
            }
            if (requestingPlayer == null) {
                return;
            }
            if (!Guild.this.hasPermissionForTarget(requestingPlayer.getId(), targetPlayer.getId(), requiredPermission)) {
                throw new GuildPermissionTargetException(requestingPlayer, targetPlayer, MinimalGuild.fromGuild(Guild.this), requiredPermission);
            }
        }

        public void verifyMemberAdd(@NonNull PlayerGuildInformation targetPlayer) {
            if (targetPlayer == null) {
                throw new NullPointerException("targetPlayer is marked non-null but is null");
            }
            if (Guild.this.isMember(targetPlayer.getPlayer().getId())) {
                throw new AlreadyGuildMemberException(targetPlayer.getPlayer(), MinimalGuild.fromGuild(Guild.this));
            }
            if (Guild.this.isFull()) {
                throw new GuildFullException(MinimalGuild.fromGuild(Guild.this), Guild.this.getMemberProperties().getMaxMembers());
            }
            if (!targetPlayer.canJoinGuild()) {
                throw new PlayerGuildLimitException(targetPlayer.getPlayer(), PlayerGuildLimitException.LimitType.MEMBERSHIP, targetPlayer.getMaxJoinedGuilds());
            }
            GuildRole starterRole = GuildCommon.getDefaultRole();
            if (!Guild.this.canAssignRole(starterRole)) {
                throw new GuildRoleLimitException(targetPlayer.getPlayer(), MinimalGuild.fromGuild(Guild.this), starterRole, Guild.this.getMemberProperties().getMemberLimit(starterRole));
            }
        }

        public void verifyJoin(@NonNull PlayerGuildInformation targetPlayer) {
            if (targetPlayer == null) {
                throw new NullPointerException("targetPlayer is marked non-null but is null");
            }
            if (!Guild.this.canDirectlyJoin()) {
                throw new NotInvitedToGuildException(targetPlayer.getPlayer(), MinimalGuild.fromGuild(Guild.this));
            }
            this.verifyMemberAdd(targetPlayer);
        }

        public void verifyAcceptInviteSimple(@NonNull PlayerIdentity targetPlayer) {
            if (targetPlayer == null) {
                throw new NullPointerException("targetPlayer is marked non-null but is null");
            }
            if (!Guild.this.isInvited(targetPlayer.getId())) {
                throw new NotInvitedToGuildException(targetPlayer, MinimalGuild.fromGuild(Guild.this));
            }
        }

        public void verifyAcceptInvite(@NonNull PlayerGuildInformation targetPlayer) {
            if (targetPlayer == null) {
                throw new NullPointerException("targetPlayer is marked non-null but is null");
            }
            this.verifyAcceptInviteSimple(targetPlayer.getPlayer());
            this.verifyMemberAdd(targetPlayer);
        }

        public void verifyUpdateMemberRole(@NonNull PlayerIdentity targetPlayer, @NonNull GuildRole newRole, @Nullable PlayerIdentity requestingPlayer) {
            GuildPlayer requestingGuildPlayer;
            GuildRole requestingRole;
            if (targetPlayer == null) {
                throw new NullPointerException("targetPlayer is marked non-null but is null");
            }
            if (newRole == null) {
                throw new NullPointerException("newRole is marked non-null but is null");
            }
            if (newRole == GuildRole.OWNER) {
                throw new DirectOwnerAssignmentException(MinimalGuild.fromGuild(Guild.this));
            }
            this.verifyCallerPermissionForTarget(requestingPlayer, targetPlayer, GuildPermission.CHANGE_ROLLS);
            if (requestingPlayer != null && !newRole.isLowerThan(requestingRole = (requestingGuildPlayer = Guild.this.getMemberOrThrow(requestingPlayer)).getRole())) {
                throw new GuildPermissionTargetException(requestingPlayer, targetPlayer, MinimalGuild.fromGuild(Guild.this), GuildPermission.CHANGE_ROLLS);
            }
            if (!Guild.this.canAssignRole(newRole)) {
                throw new GuildRoleLimitException(targetPlayer, MinimalGuild.fromGuild(Guild.this), newRole, Guild.this.getMemberProperties().getMemberLimit(newRole));
            }
            GuildPlayer guildPlayer = Guild.this.getMemberOrThrow(targetPlayer);
            if (guildPlayer.getRole() == GuildRole.OWNER) {
                throw new GuildOwnerModificationException(targetPlayer, MinimalGuild.fromGuild(Guild.this));
            }
        }

        public void verifyTransferOwnershipSimple(@NonNull PlayerIdentity targetPlayer, @Nullable PlayerIdentity requestingPlayer) {
            if (targetPlayer == null) {
                throw new NullPointerException("targetPlayer is marked non-null but is null");
            }
            this.verifyCallerPermissionForTarget(requestingPlayer, targetPlayer, GuildPermission.TRANSFER_OWNERSHIP);
            GuildPlayer newOwner = Guild.this.getMemberOrThrow(targetPlayer);
            if (newOwner.getRole() == GuildRole.OWNER) {
                throw new AlreadyGuildOwnerException(targetPlayer, MinimalGuild.fromGuild(Guild.this));
            }
        }

        public void verifyTransferOwnership(@NonNull PlayerGuildInformation targetPlayer, @Nullable PlayerIdentity requestingPlayer) {
            if (targetPlayer == null) {
                throw new NullPointerException("targetPlayer is marked non-null but is null");
            }
            this.verifyTransferOwnershipSimple(targetPlayer.getPlayer(), requestingPlayer);
            if (targetPlayer.getOwnedGuildIds().size() >= targetPlayer.getMaxOwnedGuilds()) {
                throw new PlayerGuildLimitException(targetPlayer.getPlayer(), PlayerGuildLimitException.LimitType.OWNERSHIP, targetPlayer.getMaxOwnedGuilds());
            }
        }

        public void verifyMemberLeave(@NonNull PlayerIdentity targetPlayer) {
            if (targetPlayer == null) {
                throw new NullPointerException("targetPlayer is marked non-null but is null");
            }
            Guild.this.getMemberOrThrow(targetPlayer);
            if (!Guild.this.canLeave(targetPlayer.getId())) {
                throw new OwnerLeaveGuildException(targetPlayer, MinimalGuild.fromGuild(Guild.this));
            }
        }

        public void verifyKickMember(@NonNull PlayerIdentity targetPlayer, @Nullable PlayerIdentity requestingPlayer) {
            if (targetPlayer == null) {
                throw new NullPointerException("targetPlayer is marked non-null but is null");
            }
            Guild.this.getMemberOrThrow(targetPlayer);
            this.verifyCallerPermissionForTarget(requestingPlayer, targetPlayer, GuildPermission.REMOVE_MEMBERS);
            if (!Guild.this.canLeave(targetPlayer.getId())) {
                throw new GuildOwnerModificationException(targetPlayer, MinimalGuild.fromGuild(Guild.this));
            }
        }

        public void verifyCanInvitePlayers(@Nullable PlayerIdentity requestingPlayer) {
            this.verifyCallerPermission(requestingPlayer, GuildPermission.INVITE_MEMBERS);
        }

        public void verifyInvitePlayer(@NonNull PlayerIdentity targetPlayer, @Nullable PlayerIdentity requestingPlayer) {
            if (targetPlayer == null) {
                throw new NullPointerException("targetPlayer is marked non-null but is null");
            }
            this.verifyCanInvitePlayers(requestingPlayer);
            if (Guild.this.getMember(targetPlayer.getId()).isPresent()) {
                throw new AlreadyGuildMemberException(targetPlayer, MinimalGuild.fromGuild(Guild.this));
            }
            if (Guild.this.isInvited(targetPlayer.getId())) {
                throw new AlreadyInvitedToGuildException(targetPlayer, MinimalGuild.fromGuild(Guild.this));
            }
        }

        public void verifyCancelInvite(@NonNull PlayerIdentity targetPlayer, @Nullable PlayerIdentity requestingPlayer) {
            if (targetPlayer == null) {
                throw new NullPointerException("targetPlayer is marked non-null but is null");
            }
            this.verifyCallerPermission(requestingPlayer, GuildPermission.UNINVITE_MEMBERS);
            if (!Guild.this.isInvited(targetPlayer.getId())) {
                throw new NotInvitedToGuildException(targetPlayer, MinimalGuild.fromGuild(Guild.this));
            }
        }

        public void verifyRejectInvite(@NonNull PlayerIdentity targetPlayer) {
            if (targetPlayer == null) {
                throw new NullPointerException("targetPlayer is marked non-null but is null");
            }
            if (!Guild.this.isInvited(targetPlayer.getId())) {
                throw new NotInvitedToGuildException(targetPlayer, MinimalGuild.fromGuild(Guild.this));
            }
        }

        public void verifyDelete(@Nullable PlayerIdentity requestingPlayer) {
            this.verifyCallerPermission(requestingPlayer, GuildPermission.DISBAND_GUILD);
        }

        public void verifyUpdateAccess(@Nullable PlayerIdentity requestingPlayer) {
            this.verifyCallerPermission(requestingPlayer, GuildPermission.CHANGE_ACCESS);
        }

        public void verifyUpdateAccess(@Nullable PlayerIdentity requestingPlayer, @NonNull GuildAccess newAccess) {
            if (newAccess == null) {
                throw new NullPointerException("newAccess is marked non-null but is null");
            }
            this.verifyUpdateAccess(requestingPlayer);
        }

        public void verifyRejectRequest(@NonNull PlayerIdentity targetPlayer, @Nullable PlayerIdentity requestingPlayer) {
            if (targetPlayer == null) {
                throw new NullPointerException("targetPlayer is marked non-null but is null");
            }
            this.verifyCallerPermission(requestingPlayer, GuildPermission.DENY_JOIN_REQUESTS);
            if (!Guild.this.isJoinRequested(targetPlayer.getId())) {
                throw new NotRequestingToJoinGuildException(targetPlayer, MinimalGuild.fromGuild(Guild.this));
            }
        }

        public void verifyAcceptRequestSimple(@NonNull PlayerIdentity targetPlayer, @Nullable PlayerIdentity requestingPlayer) {
            if (targetPlayer == null) {
                throw new NullPointerException("targetPlayer is marked non-null but is null");
            }
            this.verifyCallerPermission(requestingPlayer, GuildPermission.ACCEPT_JOIN_REQUESTS);
            if (!Guild.this.isJoinRequested(targetPlayer.getId())) {
                throw new NotRequestingToJoinGuildException(targetPlayer, MinimalGuild.fromGuild(Guild.this));
            }
        }

        public void verifyAcceptRequest(@NonNull PlayerGuildInformation targetPlayer, @Nullable PlayerIdentity requestingPlayer) {
            if (targetPlayer == null) {
                throw new NullPointerException("targetPlayer is marked non-null but is null");
            }
            this.verifyAcceptRequestSimple(targetPlayer.getPlayer(), requestingPlayer);
            this.verifyMemberAdd(targetPlayer);
        }

        public void verifyCancelRequest(@NonNull PlayerIdentity targetPlayer) {
            if (targetPlayer == null) {
                throw new NullPointerException("targetPlayer is marked non-null but is null");
            }
            if (!Guild.this.isJoinRequested(targetPlayer.getId())) {
                throw new NotRequestingToJoinGuildException(targetPlayer, MinimalGuild.fromGuild(Guild.this));
            }
        }

        public void verifyRequestJoin(@NonNull PlayerIdentity targetPlayer) {
            if (targetPlayer == null) {
                throw new NullPointerException("targetPlayer is marked non-null but is null");
            }
            if (Guild.this.getMember(targetPlayer.getId()).isPresent()) {
                throw new AlreadyGuildMemberException(targetPlayer, MinimalGuild.fromGuild(Guild.this));
            }
            if (Guild.this.isJoinRequested(targetPlayer.getId())) {
                throw new AlreadyRequestingToJoinException(targetPlayer, MinimalGuild.fromGuild(Guild.this));
            }
            if (Guild.this.canDirectlyJoin()) {
                throw new CantJoinRequestGuildException(targetPlayer, MinimalGuild.fromGuild(Guild.this));
            }
            if (Guild.this.isInvited(targetPlayer.getId())) {
                throw new AlreadyInvitedToGuildException(targetPlayer, MinimalGuild.fromGuild(Guild.this));
            }
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    public static class GuildBuilder {
        @Generated
        private String id;
        @Generated
        private String name;
        @Generated
        private GuildAccess access;
        @Generated
        private Map<GuildRole, @NonNull Map<@NonNull GuildPermission, GuildPermissionContext>> rolePermissions;
        @Generated
        private Map<UUID, GuildPlayer> membersMap;
        @Generated
        private Map<UUID, GuildInvitedPlayer> invitedMap;
        @Generated
        private Map<UUID, GuildJoinRequestedPlayer> joinRequested;
        @Generated
        private GuildMemberProperties memberProperties;
        @Generated
        private long totalExperience;
        @Generated
        private int level;

        @Generated
        GuildBuilder() {
        }

        @Generated
        public GuildBuilder id(@NonNull String id) {
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            this.id = id;
            return this;
        }

        @Generated
        public GuildBuilder name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        @Generated
        public GuildBuilder access(@NonNull GuildAccess access) {
            if (access == null) {
                throw new NullPointerException("access is marked non-null but is null");
            }
            this.access = access;
            return this;
        }

        @Generated
        public GuildBuilder rolePermissions(@NonNull @NonNull Map<GuildRole, @NonNull Map<@NonNull GuildPermission, GuildPermissionContext>> rolePermissions) {
            if (rolePermissions == null) {
                throw new NullPointerException("rolePermissions is marked non-null but is null");
            }
            this.rolePermissions = rolePermissions;
            return this;
        }

        @Generated
        public GuildBuilder membersMap(@NonNull Map<UUID, GuildPlayer> membersMap) {
            if (membersMap == null) {
                throw new NullPointerException("membersMap is marked non-null but is null");
            }
            this.membersMap = membersMap;
            return this;
        }

        @Generated
        public GuildBuilder invitedMap(@NonNull Map<UUID, GuildInvitedPlayer> invitedMap) {
            if (invitedMap == null) {
                throw new NullPointerException("invitedMap is marked non-null but is null");
            }
            this.invitedMap = invitedMap;
            return this;
        }

        @Generated
        public GuildBuilder joinRequested(@NonNull Map<UUID, GuildJoinRequestedPlayer> joinRequested) {
            if (joinRequested == null) {
                throw new NullPointerException("joinRequested is marked non-null but is null");
            }
            this.joinRequested = joinRequested;
            return this;
        }

        @Generated
        public GuildBuilder memberProperties(@NonNull GuildMemberProperties memberProperties) {
            if (memberProperties == null) {
                throw new NullPointerException("memberProperties is marked non-null but is null");
            }
            this.memberProperties = memberProperties;
            return this;
        }

        @Generated
        public GuildBuilder totalExperience(long totalExperience) {
            this.totalExperience = totalExperience;
            return this;
        }

        @Generated
        public GuildBuilder level(int level) {
            this.level = level;
            return this;
        }

        @Generated
        public Guild build() {
            return new Guild(this.id, this.name, this.access, this.rolePermissions, this.membersMap, this.invitedMap, this.joinRequested, this.memberProperties, this.totalExperience, this.level);
        }

        @Generated
        public String toString() {
            return "Guild.GuildBuilder(id=" + this.id + ", name=" + this.name + ", access=" + String.valueOf((Object)this.access) + ", rolePermissions=" + String.valueOf(this.rolePermissions) + ", membersMap=" + String.valueOf(this.membersMap) + ", invitedMap=" + String.valueOf(this.invitedMap) + ", joinRequested=" + String.valueOf(this.joinRequested) + ", memberProperties=" + String.valueOf(this.memberProperties) + ", totalExperience=" + this.totalExperience + ", level=" + this.level + ")";
        }
    }
}

