/*
 * Decompiled with CFR 0.152.
 */
package com.mineplex.studio.dataplane.common.guild.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.mineplex.studio.dataplane.common.guild.model.GuildRole;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import lombok.Generated;
import lombok.NonNull;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=GuildMemberPropertiesBuilder.class)
public class GuildMemberProperties {
    private final transient ReadWriteLock lock = new ReentrantReadWriteLock();
    @NonNull
    private final List<GuildMemberLimitByRole> memberLimits;
    private int maxMembers;

    @NonNull
    public List<GuildMemberLimitByRole> getMemberLimits() {
        this.lock.readLock().lock();
        try {
            List<GuildMemberLimitByRole> list = List.copyOf(this.memberLimits);
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean removeMemberRoleLimit(@NonNull GuildRole role) {
        this.lock.writeLock().lock();
        try {
            if (role == null) {
                throw new NullPointerException("role is marked non-null but is null");
            }
            boolean bl = this.memberLimits.removeIf(limit -> limit.getRole() == role);
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setMemberRoleLimit(@NonNull GuildRole role, int maxMembers) {
        this.lock.writeLock().lock();
        try {
            if (role == null) {
                throw new NullPointerException("role is marked non-null but is null");
            }
            this.removeMemberRoleLimit(role);
            boolean bl = this.memberLimits.add(new GuildMemberLimitByRole(role, maxMembers));
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMemberLimit(@NonNull GuildRole role) {
        this.lock.readLock().lock();
        try {
            if (role == null) {
                throw new NullPointerException("role is marked non-null but is null");
            }
            for (GuildMemberLimitByRole limit : this.memberLimits) {
                if (limit.getRole() != role) continue;
                int n = limit.getMaxMembers();
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Generated
    GuildMemberProperties(@NonNull List<GuildMemberLimitByRole> memberLimits, int maxMembers) {
        if (memberLimits == null) {
            throw new NullPointerException("memberLimits is marked non-null but is null");
        }
        this.memberLimits = memberLimits;
        this.maxMembers = maxMembers;
    }

    @Generated
    public static GuildMemberPropertiesBuilder builder() {
        return new GuildMemberPropertiesBuilder();
    }

    @Generated
    public GuildMemberPropertiesBuilder toBuilder() {
        return new GuildMemberPropertiesBuilder().memberLimits(this.memberLimits).maxMembers(this.maxMembers);
    }

    @Generated
    public ReadWriteLock getLock() {
        return this.lock;
    }

    @Generated
    public int getMaxMembers() {
        return this.maxMembers;
    }

    @Generated
    public void setMaxMembers(int maxMembers) {
        this.maxMembers = maxMembers;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GuildMemberProperties)) {
            return false;
        }
        GuildMemberProperties other = (GuildMemberProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMaxMembers() != other.getMaxMembers()) {
            return false;
        }
        List<GuildMemberLimitByRole> this$memberLimits = this.getMemberLimits();
        List<GuildMemberLimitByRole> other$memberLimits = other.getMemberLimits();
        return !(this$memberLimits == null ? other$memberLimits != null : !((Object)this$memberLimits).equals(other$memberLimits));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GuildMemberProperties;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMaxMembers();
        List<GuildMemberLimitByRole> $memberLimits = this.getMemberLimits();
        result = result * 59 + ($memberLimits == null ? 43 : ((Object)$memberLimits).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "GuildMemberProperties(lock=" + String.valueOf(this.getLock()) + ", memberLimits=" + String.valueOf(this.getMemberLimits()) + ", maxMembers=" + this.getMaxMembers() + ")";
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonDeserialize(builder=GuildMemberLimitByRoleBuilder.class)
    public static final class GuildMemberLimitByRole {
        @NonNull
        private final GuildRole role;
        private final int maxMembers;

        @Generated
        GuildMemberLimitByRole(@NonNull GuildRole role, int maxMembers) {
            if (role == null) {
                throw new NullPointerException("role is marked non-null but is null");
            }
            this.role = role;
            this.maxMembers = maxMembers;
        }

        @Generated
        public static GuildMemberLimitByRoleBuilder builder() {
            return new GuildMemberLimitByRoleBuilder();
        }

        @Generated
        public GuildMemberLimitByRoleBuilder toBuilder() {
            return new GuildMemberLimitByRoleBuilder().role(this.role).maxMembers(this.maxMembers);
        }

        @NonNull
        @Generated
        public GuildRole getRole() {
            return this.role;
        }

        @Generated
        public int getMaxMembers() {
            return this.maxMembers;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GuildMemberLimitByRole)) {
                return false;
            }
            GuildMemberLimitByRole other = (GuildMemberLimitByRole)o;
            if (this.getMaxMembers() != other.getMaxMembers()) {
                return false;
            }
            GuildRole this$role = this.getRole();
            GuildRole other$role = other.getRole();
            return !(this$role == null ? other$role != null : !((Object)((Object)this$role)).equals((Object)other$role));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getMaxMembers();
            GuildRole $role = this.getRole();
            result = result * 59 + ($role == null ? 43 : ((Object)((Object)$role)).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "GuildMemberProperties.GuildMemberLimitByRole(role=" + String.valueOf((Object)this.getRole()) + ", maxMembers=" + this.getMaxMembers() + ")";
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        @Generated
        public static class GuildMemberLimitByRoleBuilder {
            @Generated
            private GuildRole role;
            @Generated
            private int maxMembers;

            @Generated
            GuildMemberLimitByRoleBuilder() {
            }

            @Generated
            public GuildMemberLimitByRoleBuilder role(@NonNull GuildRole role) {
                if (role == null) {
                    throw new NullPointerException("role is marked non-null but is null");
                }
                this.role = role;
                return this;
            }

            @Generated
            public GuildMemberLimitByRoleBuilder maxMembers(int maxMembers) {
                this.maxMembers = maxMembers;
                return this;
            }

            @Generated
            public GuildMemberLimitByRole build() {
                return new GuildMemberLimitByRole(this.role, this.maxMembers);
            }

            @Generated
            public String toString() {
                return "GuildMemberProperties.GuildMemberLimitByRole.GuildMemberLimitByRoleBuilder(role=" + String.valueOf((Object)this.role) + ", maxMembers=" + this.maxMembers + ")";
            }
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    public static class GuildMemberPropertiesBuilder {
        @Generated
        private List<GuildMemberLimitByRole> memberLimits;
        @Generated
        private int maxMembers;

        @Generated
        GuildMemberPropertiesBuilder() {
        }

        @Generated
        public GuildMemberPropertiesBuilder memberLimits(@NonNull List<GuildMemberLimitByRole> memberLimits) {
            if (memberLimits == null) {
                throw new NullPointerException("memberLimits is marked non-null but is null");
            }
            this.memberLimits = memberLimits;
            return this;
        }

        @Generated
        public GuildMemberPropertiesBuilder maxMembers(int maxMembers) {
            this.maxMembers = maxMembers;
            return this;
        }

        @Generated
        public GuildMemberProperties build() {
            return new GuildMemberProperties(this.memberLimits, this.maxMembers);
        }

        @Generated
        public String toString() {
            return "GuildMemberProperties.GuildMemberPropertiesBuilder(memberLimits=" + String.valueOf(this.memberLimits) + ", maxMembers=" + this.maxMembers + ")";
        }
    }
}

