/*
 * Decompiled with CFR 0.152.
 */
package com.mineplex.studio.dataplane.common.guild.model;

import com.mineplex.studio.dataplane.common.guild.model.GuildPlayer;
import java.util.Objects;
import lombok.NonNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum GuildPermissionTargetingMode {
    ANY{

        @Override
        public boolean canTarget(@NonNull GuildPlayer targetPlayer, @NonNull GuildPlayer sourcePlayer) {
            if (targetPlayer == null) {
                throw new NullPointerException("targetPlayer is marked non-null but is null");
            }
            if (sourcePlayer == null) {
                throw new NullPointerException("sourcePlayer is marked non-null but is null");
            }
            return true;
        }
    }
    ,
    LOWER{

        @Override
        public boolean canTarget(@NonNull GuildPlayer targetPlayer, @NonNull GuildPlayer sourcePlayer) {
            if (targetPlayer == null) {
                throw new NullPointerException("targetPlayer is marked non-null but is null");
            }
            if (sourcePlayer == null) {
                throw new NullPointerException("sourcePlayer is marked non-null but is null");
            }
            return sourcePlayer.getRole().isHigherThan(targetPlayer.getRole());
        }
    }
    ,
    SAME_OR_LOWER{

        @Override
        public boolean canTarget(@NonNull GuildPlayer targetPlayer, @NonNull GuildPlayer sourcePlayer) {
            if (targetPlayer == null) {
                throw new NullPointerException("targetPlayer is marked non-null but is null");
            }
            if (sourcePlayer == null) {
                throw new NullPointerException("sourcePlayer is marked non-null but is null");
            }
            return sourcePlayer.getRole().isHigherThan(targetPlayer.getRole()) || sourcePlayer.getRole().isEqualTo(targetPlayer.getRole());
        }
    }
    ,
    ONLY_SAME{

        @Override
        public boolean canTarget(@NonNull GuildPlayer targetPlayer, @NonNull GuildPlayer sourcePlayer) {
            if (targetPlayer == null) {
                throw new NullPointerException("targetPlayer is marked non-null but is null");
            }
            if (sourcePlayer == null) {
                throw new NullPointerException("sourcePlayer is marked non-null but is null");
            }
            return sourcePlayer.getRole().isEqualTo(targetPlayer.getRole());
        }
    }
    ,
    SELF{

        @Override
        public boolean canTarget(@NonNull GuildPlayer targetPlayer, @NonNull GuildPlayer sourcePlayer) {
            if (targetPlayer == null) {
                throw new NullPointerException("targetPlayer is marked non-null but is null");
            }
            if (sourcePlayer == null) {
                throw new NullPointerException("sourcePlayer is marked non-null but is null");
            }
            return Objects.equals(targetPlayer.getPlayer().getId(), sourcePlayer.getPlayer().getId());
        }
    };


    public abstract boolean canTarget(@NonNull GuildPlayer var1, @NonNull GuildPlayer var2);
}

