/*
 * Decompiled with CFR 0.152.
 */
package com.mineplex.studio.dataplane.common.guild.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;

public enum GuildRole {
    OWNER(true, Integer.MAX_VALUE),
    OFFICER(false, 100),
    MEMBER(false, 0);

    private final boolean specialRank;
    private final int priority;

    public boolean isHigherThan(@NonNull GuildRole otherRole) {
        if (otherRole == null) {
            throw new NullPointerException("otherRole is marked non-null but is null");
        }
        return this.priority > otherRole.priority;
    }

    public boolean isLowerThan(@NonNull GuildRole otherRole) {
        if (otherRole == null) {
            throw new NullPointerException("otherRole is marked non-null but is null");
        }
        return this.priority < otherRole.priority;
    }

    public boolean isEqualTo(@NonNull GuildRole otherRole) {
        if (otherRole == null) {
            throw new NullPointerException("otherRole is marked non-null but is null");
        }
        return this.priority == otherRole.priority;
    }

    @JsonIgnore
    @NonNull
    public Optional<GuildRole> getHigherRole() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case MEMBER -> Optional.of(OFFICER);
            case OFFICER -> Optional.of(OWNER);
            case OWNER -> Optional.empty();
        };
    }

    @JsonIgnore
    public Optional<GuildRole> getLowerRole() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case OWNER -> Optional.of(OFFICER);
            case OFFICER -> Optional.of(MEMBER);
            case MEMBER -> Optional.empty();
        };
    }

    @Generated
    private GuildRole(boolean specialRank, int priority) {
        this.specialRank = specialRank;
        this.priority = priority;
    }

    @Generated
    public boolean isSpecialRank() {
        return this.specialRank;
    }

    @Generated
    public int getPriority() {
        return this.priority;
    }
}

