/*
 * Decompiled with CFR 0.152.
 */
package com.mineplex.studio.dataplane.common.guild.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.mineplex.studio.dataplane.common.profile.model.PlayerIdentity;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import lombok.Generated;
import lombok.NonNull;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=PlayerGuildInformationBuilder.class)
public class PlayerGuildInformation {
    private final transient ReadWriteLock lock = new ReentrantReadWriteLock();
    @NonNull
    private final PlayerIdentity player;
    @NonNull
    private final Set<String> ownedGuildIds;
    @NonNull
    private final Set<String> joinedGuildIds;
    @NonNull
    private final Set<String> invitedGuildIds;
    @NonNull
    private final Set<String> joinRequestedGuildIds;
    private int maxOwnedGuilds;
    private int maxJoinedGuilds;
    private int maxTotalGuilds;

    @NonNull
    public Set<String> getOwnedGuildIds() {
        this.lock.readLock().lock();
        try {
            Set<String> set = Set.copyOf(this.ownedGuildIds);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean ownsGuild(@NonNull String guildId) {
        this.lock.readLock().lock();
        try {
            if (guildId == null) {
                throw new NullPointerException("guildId is marked non-null but is null");
            }
            boolean bl = this.ownedGuildIds.contains(guildId);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean addOwnedGuild(@NonNull String guildId) {
        this.lock.writeLock().lock();
        try {
            if (guildId == null) {
                throw new NullPointerException("guildId is marked non-null but is null");
            }
            boolean bl = this.ownedGuildIds.add(guildId);
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public boolean removeOwnedGuild(@NonNull String guildId) {
        this.lock.writeLock().lock();
        try {
            if (guildId == null) {
                throw new NullPointerException("guildId is marked non-null but is null");
            }
            boolean bl = this.ownedGuildIds.remove(guildId);
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @NonNull
    public Set<String> getJoinedGuildIds() {
        this.lock.readLock().lock();
        try {
            Set<String> set = Set.copyOf(this.joinedGuildIds);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean hasJoinedGuild(@NonNull String guildId) {
        this.lock.readLock().lock();
        try {
            if (guildId == null) {
                throw new NullPointerException("guildId is marked non-null but is null");
            }
            boolean bl = this.joinedGuildIds.contains(guildId);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean addJoinedGuild(@NonNull String guildId) {
        this.lock.writeLock().lock();
        try {
            if (guildId == null) {
                throw new NullPointerException("guildId is marked non-null but is null");
            }
            boolean bl = this.joinedGuildIds.add(guildId);
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public boolean removeJoinedGuild(@NonNull String guildId) {
        this.lock.writeLock().lock();
        try {
            if (guildId == null) {
                throw new NullPointerException("guildId is marked non-null but is null");
            }
            boolean bl = this.joinedGuildIds.remove(guildId);
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @NonNull
    public Set<String> getInvitedGuildIds() {
        this.lock.readLock().lock();
        try {
            Set<String> set = Set.copyOf(this.invitedGuildIds);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean hasInvitedGuild(@NonNull String guildId) {
        this.lock.readLock().lock();
        try {
            if (guildId == null) {
                throw new NullPointerException("guildId is marked non-null but is null");
            }
            boolean bl = this.invitedGuildIds.contains(guildId);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean addInvitedGuild(@NonNull String guildId) {
        this.lock.writeLock().lock();
        try {
            if (guildId == null) {
                throw new NullPointerException("guildId is marked non-null but is null");
            }
            boolean bl = this.invitedGuildIds.add(guildId);
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public boolean removeInvitedGuild(@NonNull String guildId) {
        this.lock.writeLock().lock();
        try {
            if (guildId == null) {
                throw new NullPointerException("guildId is marked non-null but is null");
            }
            boolean bl = this.invitedGuildIds.remove(guildId);
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @NonNull
    public Set<String> getJoinRequestedGuildIds() {
        this.lock.readLock().lock();
        try {
            Set<String> set = Set.copyOf(this.joinRequestedGuildIds);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean isJoinRequestingGuild(@NonNull String guildId) {
        this.lock.readLock().lock();
        try {
            if (guildId == null) {
                throw new NullPointerException("guildId is marked non-null but is null");
            }
            boolean bl = this.joinRequestedGuildIds.contains(guildId);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean addJoinRequestingGuild(@NonNull String guildId) {
        this.lock.writeLock().lock();
        try {
            if (guildId == null) {
                throw new NullPointerException("guildId is marked non-null but is null");
            }
            boolean bl = this.joinRequestedGuildIds.add(guildId);
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public boolean removeJoinRequestingGuild(@NonNull String guildId) {
        this.lock.writeLock().lock();
        try {
            if (guildId == null) {
                throw new NullPointerException("guildId is marked non-null but is null");
            }
            boolean bl = this.joinRequestedGuildIds.remove(guildId);
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public int getMaxOwnedGuilds() {
        this.lock.readLock().lock();
        try {
            int n = this.maxOwnedGuilds;
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void setMaxOwnedGuilds(int maxOwnedGuilds) {
        this.lock.writeLock().lock();
        try {
            this.maxOwnedGuilds = maxOwnedGuilds;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public int getMaxJoinedGuilds() {
        this.lock.readLock().lock();
        try {
            int n = this.maxJoinedGuilds;
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void setMaxJoinedGuilds(int maxJoinedGuilds) {
        this.lock.writeLock().lock();
        try {
            this.maxJoinedGuilds = maxJoinedGuilds;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public int getMaxTotalGuilds() {
        this.lock.readLock().lock();
        try {
            int n = this.maxTotalGuilds;
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void setMaxTotalGuilds(int maxTotalGuilds) {
        this.lock.writeLock().lock();
        try {
            this.maxTotalGuilds = maxTotalGuilds;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public int getTotalGuilds() {
        this.lock.readLock().lock();
        try {
            int n = this.ownedGuildIds.size() + this.joinedGuildIds.size();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean canJoinGuild() {
        return this.getMaxJoinedGuilds() > this.joinedGuildIds.size() && this.getMaxTotalGuilds() > this.getTotalGuilds();
    }

    public boolean canCreateGuild() {
        return this.getMaxOwnedGuilds() > this.ownedGuildIds.size() && this.getMaxTotalGuilds() > this.getTotalGuilds();
    }

    @Generated
    PlayerGuildInformation(@NonNull PlayerIdentity player, @NonNull Set<String> ownedGuildIds, @NonNull Set<String> joinedGuildIds, @NonNull Set<String> invitedGuildIds, @NonNull Set<String> joinRequestedGuildIds, int maxOwnedGuilds, int maxJoinedGuilds, int maxTotalGuilds) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (ownedGuildIds == null) {
            throw new NullPointerException("ownedGuildIds is marked non-null but is null");
        }
        if (joinedGuildIds == null) {
            throw new NullPointerException("joinedGuildIds is marked non-null but is null");
        }
        if (invitedGuildIds == null) {
            throw new NullPointerException("invitedGuildIds is marked non-null but is null");
        }
        if (joinRequestedGuildIds == null) {
            throw new NullPointerException("joinRequestedGuildIds is marked non-null but is null");
        }
        this.player = player;
        this.ownedGuildIds = ownedGuildIds;
        this.joinedGuildIds = joinedGuildIds;
        this.invitedGuildIds = invitedGuildIds;
        this.joinRequestedGuildIds = joinRequestedGuildIds;
        this.maxOwnedGuilds = maxOwnedGuilds;
        this.maxJoinedGuilds = maxJoinedGuilds;
        this.maxTotalGuilds = maxTotalGuilds;
    }

    @Generated
    public static PlayerGuildInformationBuilder builder() {
        return new PlayerGuildInformationBuilder();
    }

    @Generated
    public PlayerGuildInformationBuilder toBuilder() {
        return new PlayerGuildInformationBuilder().player(this.player).ownedGuildIds(this.ownedGuildIds).joinedGuildIds(this.joinedGuildIds).invitedGuildIds(this.invitedGuildIds).joinRequestedGuildIds(this.joinRequestedGuildIds).maxOwnedGuilds(this.maxOwnedGuilds).maxJoinedGuilds(this.maxJoinedGuilds).maxTotalGuilds(this.maxTotalGuilds);
    }

    @Generated
    public ReadWriteLock getLock() {
        return this.lock;
    }

    @NonNull
    @Generated
    public PlayerIdentity getPlayer() {
        return this.player;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PlayerGuildInformation)) {
            return false;
        }
        PlayerGuildInformation other = (PlayerGuildInformation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMaxOwnedGuilds() != other.getMaxOwnedGuilds()) {
            return false;
        }
        if (this.getMaxJoinedGuilds() != other.getMaxJoinedGuilds()) {
            return false;
        }
        if (this.getMaxTotalGuilds() != other.getMaxTotalGuilds()) {
            return false;
        }
        PlayerIdentity this$player = this.getPlayer();
        PlayerIdentity other$player = other.getPlayer();
        if (this$player == null ? other$player != null : !((Object)this$player).equals(other$player)) {
            return false;
        }
        Set<String> this$ownedGuildIds = this.getOwnedGuildIds();
        Set<String> other$ownedGuildIds = other.getOwnedGuildIds();
        if (this$ownedGuildIds == null ? other$ownedGuildIds != null : !((Object)this$ownedGuildIds).equals(other$ownedGuildIds)) {
            return false;
        }
        Set<String> this$joinedGuildIds = this.getJoinedGuildIds();
        Set<String> other$joinedGuildIds = other.getJoinedGuildIds();
        if (this$joinedGuildIds == null ? other$joinedGuildIds != null : !((Object)this$joinedGuildIds).equals(other$joinedGuildIds)) {
            return false;
        }
        Set<String> this$invitedGuildIds = this.getInvitedGuildIds();
        Set<String> other$invitedGuildIds = other.getInvitedGuildIds();
        if (this$invitedGuildIds == null ? other$invitedGuildIds != null : !((Object)this$invitedGuildIds).equals(other$invitedGuildIds)) {
            return false;
        }
        Set<String> this$joinRequestedGuildIds = this.getJoinRequestedGuildIds();
        Set<String> other$joinRequestedGuildIds = other.getJoinRequestedGuildIds();
        return !(this$joinRequestedGuildIds == null ? other$joinRequestedGuildIds != null : !((Object)this$joinRequestedGuildIds).equals(other$joinRequestedGuildIds));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PlayerGuildInformation;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMaxOwnedGuilds();
        result = result * 59 + this.getMaxJoinedGuilds();
        result = result * 59 + this.getMaxTotalGuilds();
        PlayerIdentity $player = this.getPlayer();
        result = result * 59 + ($player == null ? 43 : ((Object)$player).hashCode());
        Set<String> $ownedGuildIds = this.getOwnedGuildIds();
        result = result * 59 + ($ownedGuildIds == null ? 43 : ((Object)$ownedGuildIds).hashCode());
        Set<String> $joinedGuildIds = this.getJoinedGuildIds();
        result = result * 59 + ($joinedGuildIds == null ? 43 : ((Object)$joinedGuildIds).hashCode());
        Set<String> $invitedGuildIds = this.getInvitedGuildIds();
        result = result * 59 + ($invitedGuildIds == null ? 43 : ((Object)$invitedGuildIds).hashCode());
        Set<String> $joinRequestedGuildIds = this.getJoinRequestedGuildIds();
        result = result * 59 + ($joinRequestedGuildIds == null ? 43 : ((Object)$joinRequestedGuildIds).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PlayerGuildInformation(lock=" + String.valueOf(this.getLock()) + ", player=" + String.valueOf(this.getPlayer()) + ", ownedGuildIds=" + String.valueOf(this.getOwnedGuildIds()) + ", joinedGuildIds=" + String.valueOf(this.getJoinedGuildIds()) + ", invitedGuildIds=" + String.valueOf(this.getInvitedGuildIds()) + ", joinRequestedGuildIds=" + String.valueOf(this.getJoinRequestedGuildIds()) + ", maxOwnedGuilds=" + this.getMaxOwnedGuilds() + ", maxJoinedGuilds=" + this.getMaxJoinedGuilds() + ", maxTotalGuilds=" + this.getMaxTotalGuilds() + ")";
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    public static class PlayerGuildInformationBuilder {
        @Generated
        private PlayerIdentity player;
        @Generated
        private Set<String> ownedGuildIds;
        @Generated
        private Set<String> joinedGuildIds;
        @Generated
        private Set<String> invitedGuildIds;
        @Generated
        private Set<String> joinRequestedGuildIds;
        @Generated
        private int maxOwnedGuilds;
        @Generated
        private int maxJoinedGuilds;
        @Generated
        private int maxTotalGuilds;

        @Generated
        PlayerGuildInformationBuilder() {
        }

        @Generated
        public PlayerGuildInformationBuilder player(@NonNull PlayerIdentity player) {
            if (player == null) {
                throw new NullPointerException("player is marked non-null but is null");
            }
            this.player = player;
            return this;
        }

        @Generated
        public PlayerGuildInformationBuilder ownedGuildIds(@NonNull Set<String> ownedGuildIds) {
            if (ownedGuildIds == null) {
                throw new NullPointerException("ownedGuildIds is marked non-null but is null");
            }
            this.ownedGuildIds = ownedGuildIds;
            return this;
        }

        @Generated
        public PlayerGuildInformationBuilder joinedGuildIds(@NonNull Set<String> joinedGuildIds) {
            if (joinedGuildIds == null) {
                throw new NullPointerException("joinedGuildIds is marked non-null but is null");
            }
            this.joinedGuildIds = joinedGuildIds;
            return this;
        }

        @Generated
        public PlayerGuildInformationBuilder invitedGuildIds(@NonNull Set<String> invitedGuildIds) {
            if (invitedGuildIds == null) {
                throw new NullPointerException("invitedGuildIds is marked non-null but is null");
            }
            this.invitedGuildIds = invitedGuildIds;
            return this;
        }

        @Generated
        public PlayerGuildInformationBuilder joinRequestedGuildIds(@NonNull Set<String> joinRequestedGuildIds) {
            if (joinRequestedGuildIds == null) {
                throw new NullPointerException("joinRequestedGuildIds is marked non-null but is null");
            }
            this.joinRequestedGuildIds = joinRequestedGuildIds;
            return this;
        }

        @Generated
        public PlayerGuildInformationBuilder maxOwnedGuilds(int maxOwnedGuilds) {
            this.maxOwnedGuilds = maxOwnedGuilds;
            return this;
        }

        @Generated
        public PlayerGuildInformationBuilder maxJoinedGuilds(int maxJoinedGuilds) {
            this.maxJoinedGuilds = maxJoinedGuilds;
            return this;
        }

        @Generated
        public PlayerGuildInformationBuilder maxTotalGuilds(int maxTotalGuilds) {
            this.maxTotalGuilds = maxTotalGuilds;
            return this;
        }

        @Generated
        public PlayerGuildInformation build() {
            return new PlayerGuildInformation(this.player, this.ownedGuildIds, this.joinedGuildIds, this.invitedGuildIds, this.joinRequestedGuildIds, this.maxOwnedGuilds, this.maxJoinedGuilds, this.maxTotalGuilds);
        }

        @Generated
        public String toString() {
            return "PlayerGuildInformation.PlayerGuildInformationBuilder(player=" + String.valueOf(this.player) + ", ownedGuildIds=" + String.valueOf(this.ownedGuildIds) + ", joinedGuildIds=" + String.valueOf(this.joinedGuildIds) + ", invitedGuildIds=" + String.valueOf(this.invitedGuildIds) + ", joinRequestedGuildIds=" + String.valueOf(this.joinRequestedGuildIds) + ", maxOwnedGuilds=" + this.maxOwnedGuilds + ", maxJoinedGuilds=" + this.maxJoinedGuilds + ", maxTotalGuilds=" + this.maxTotalGuilds + ")";
        }
    }
}

