/*
 * Decompiled with CFR 0.152.
 */
package com.mineplex.studio.dataplane.common.inventory;

import com.mineplex.studio.dataplane.common.inventory.InventoryGrpcMapper;
import com.mineplex.studio.dataplane.common.inventory.model.DisplayPlayerItem;
import com.mineplex.studio.dataplane.common.inventory.model.PlayerInventory;
import com.mineplex.studio.dataplane.common.inventory.model.PlayerItem;
import com.mineplex.studio.dataplane.common.inventory.model.PlayerOwnedItem;
import com.mineplex.studio.dataplane.contracts.DisplayInventoryItem;
import com.mineplex.studio.dataplane.contracts.GetPlayerInventoryResponse;
import com.mineplex.studio.dataplane.contracts.InventoryItem;
import com.mineplex.studio.dataplane.contracts.InventoryOwnedItem;
import java.util.ArrayList;
import java.util.List;

public class InventoryGrpcMapperImpl
implements InventoryGrpcMapper {
    @Override
    public PlayerItem grpcPlayerItemToPlayerItem(InventoryItem playerItem) {
        if (playerItem == null) {
            return null;
        }
        PlayerItem.PlayerItemBuilder playerItem1 = PlayerItem.builder();
        playerItem1.namespace(playerItem.getNamespace());
        playerItem1.itemId(playerItem.getItemId());
        return playerItem1.build();
    }

    @Override
    public DisplayPlayerItem grpcDisplayInventoryItemToDisplayPlayerItem(DisplayInventoryItem playerItem) {
        if (playerItem == null) {
            return null;
        }
        DisplayPlayerItem.DisplayPlayerItemBuilder displayPlayerItem = DisplayPlayerItem.builder();
        displayPlayerItem.namespace(playerItem.getNamespace());
        displayPlayerItem.itemId(playerItem.getItemId());
        displayPlayerItem.displayName(playerItem.getDisplayName());
        return displayPlayerItem.build();
    }

    @Override
    public InventoryItem playerItemToGrpcPlayerItem(PlayerItem playerItem) {
        if (playerItem == null) {
            return null;
        }
        InventoryItem.Builder inventoryItem = InventoryItem.newBuilder();
        inventoryItem.setItemId(playerItem.getItemId());
        inventoryItem.setNamespace(playerItem.getNamespace());
        return inventoryItem.build();
    }

    @Override
    public DisplayInventoryItem displayPlayerItemToGrpcDisplayPlayerItem(DisplayPlayerItem playerItem) {
        if (playerItem == null) {
            return null;
        }
        DisplayInventoryItem.Builder displayInventoryItem = DisplayInventoryItem.newBuilder();
        displayInventoryItem.setItemId(playerItem.getItemId());
        displayInventoryItem.setNamespace(playerItem.getNamespace());
        displayInventoryItem.setDisplayName(playerItem.getDisplayName());
        return displayInventoryItem.build();
    }

    @Override
    public PlayerOwnedItem grpcPlayerOwnedItemToPlayerOwnedItem(InventoryOwnedItem playerOwnedItem) {
        if (playerOwnedItem == null) {
            return null;
        }
        PlayerOwnedItem.PlayerOwnedItemBuilder playerOwnedItem1 = PlayerOwnedItem.builder();
        if (playerOwnedItem.hasItem()) {
            playerOwnedItem1.item(this.grpcPlayerItemToPlayerItem(playerOwnedItem.getItem()));
        }
        playerOwnedItem1.quantity(playerOwnedItem.getQuantity());
        return playerOwnedItem1.build();
    }

    @Override
    public InventoryOwnedItem playerOwnedItemToGrpcPlayerOwnedItem(PlayerOwnedItem playerOwnedItem) {
        if (playerOwnedItem == null) {
            return null;
        }
        InventoryOwnedItem.Builder inventoryOwnedItem = InventoryOwnedItem.newBuilder();
        inventoryOwnedItem.setItem(this.playerItemToGrpcPlayerItem(playerOwnedItem.getItem()));
        inventoryOwnedItem.setQuantity(playerOwnedItem.getQuantity());
        return inventoryOwnedItem.build();
    }

    @Override
    public PlayerInventory grpcPlayerInventoryToPlayerInventory(GetPlayerInventoryResponse playerInventory) {
        if (playerInventory == null) {
            return null;
        }
        PlayerInventory.PlayerInventoryBuilder playerInventory1 = PlayerInventory.builder();
        playerInventory1.playerId(playerInventory.getPlayerId());
        playerInventory1.ownedItems(this.inventoryOwnedItemListToPlayerOwnedItemList(playerInventory.getOwnedItemsList()));
        playerInventory1.equippedItems(this.inventoryItemListToPlayerItemList(playerInventory.getEquippedItemsList()));
        return playerInventory1.build();
    }

    @Override
    public GetPlayerInventoryResponse playerInventoryToGrpcPlayerInventory(PlayerInventory playerInventory) {
        if (playerInventory == null) {
            return null;
        }
        GetPlayerInventoryResponse.Builder getPlayerInventoryResponse = GetPlayerInventoryResponse.newBuilder();
        getPlayerInventoryResponse.setPlayerId(playerInventory.getPlayerId());
        if (playerInventory.getOwnedItems() != null) {
            for (PlayerOwnedItem ownedItem : playerInventory.getOwnedItems()) {
                getPlayerInventoryResponse.addOwnedItems(this.playerOwnedItemToGrpcPlayerOwnedItem(ownedItem));
            }
        }
        if (playerInventory.getEquippedItems() != null) {
            for (PlayerItem equippedItem : playerInventory.getEquippedItems()) {
                getPlayerInventoryResponse.addEquippedItems(this.playerItemToGrpcPlayerItem(equippedItem));
            }
        }
        return getPlayerInventoryResponse.build();
    }

    protected List<PlayerOwnedItem> inventoryOwnedItemListToPlayerOwnedItemList(List<InventoryOwnedItem> list) {
        if (list == null) {
            return null;
        }
        ArrayList<PlayerOwnedItem> list1 = new ArrayList<PlayerOwnedItem>(list.size());
        for (InventoryOwnedItem inventoryOwnedItem : list) {
            list1.add(this.grpcPlayerOwnedItemToPlayerOwnedItem(inventoryOwnedItem));
        }
        return list1;
    }

    protected List<PlayerItem> inventoryItemListToPlayerItemList(List<InventoryItem> list) {
        if (list == null) {
            return null;
        }
        ArrayList<PlayerItem> list1 = new ArrayList<PlayerItem>(list.size());
        for (InventoryItem inventoryItem : list) {
            list1.add(this.grpcPlayerItemToPlayerItem(inventoryItem));
        }
        return list1;
    }
}

