/*
 * Decompiled with CFR 0.152.
 */
package com.mineplex.studio.dataplane.common.profile;

import com.mineplex.studio.dataplane.common.CommonMapper;
import com.mineplex.studio.dataplane.common.profile.ProfileGrpcMapper;
import com.mineplex.studio.dataplane.common.profile.model.PlayerIdentity;
import com.mineplex.studio.dataplane.common.profile.model.PlayerProfile;
import com.mineplex.studio.dataplane.common.profile.model.PlayerProfileSkin;
import com.mineplex.studio.dataplane.contracts.PlayerIdentity;
import com.mineplex.studio.dataplane.contracts.PlayerProfile;
import com.mineplex.studio.dataplane.contracts.PlayerProfileUpdate;
import com.mineplex.studio.dataplane.contracts.PlayerSkin;
import java.util.UUID;

public class ProfileGrpcMapperImpl
implements ProfileGrpcMapper {
    private final CommonMapper commonMapper = CommonMapper.INSTANCE;

    @Override
    public PlayerIdentity grpcPlayerIdentitytoPlayerIdentity(com.mineplex.studio.dataplane.contracts.PlayerIdentity playerIdentity) {
        if (playerIdentity == null) {
            return null;
        }
        PlayerIdentity.PlayerIdentityBuilder playerIdentity1 = PlayerIdentity.builder();
        if (playerIdentity.getPlayerId() != null) {
            playerIdentity1.id(UUID.fromString(playerIdentity.getPlayerId()));
        }
        if (playerIdentity.hasProfile()) {
            playerIdentity1.profile(this.grpcPlayerProfiletoPlayerProfile(playerIdentity.getProfile()));
        }
        return playerIdentity1.build();
    }

    @Override
    public PlayerProfile grpcPlayerProfiletoPlayerProfile(com.mineplex.studio.dataplane.contracts.PlayerProfile playerProfile) {
        if (playerProfile == null) {
            return null;
        }
        PlayerProfile.PlayerProfileBuilder playerProfile1 = PlayerProfile.builder();
        playerProfile1.name(playerProfile.getUsername());
        if (playerProfile.getPlayerId() != null) {
            playerProfile1.id(UUID.fromString(playerProfile.getPlayerId()));
        }
        if (playerProfile.hasSkin()) {
            playerProfile1.skin(this.grpcPlayerProfileSkinToPlayerSkin(playerProfile.getSkin()));
        }
        return playerProfile1.build();
    }

    @Override
    public PlayerProfileSkin grpcPlayerProfileSkinToPlayerSkin(PlayerSkin playerProfileSkin) {
        if (playerProfileSkin == null) {
            return null;
        }
        PlayerProfileSkin.PlayerProfileSkinBuilder playerProfileSkin1 = PlayerProfileSkin.builder();
        playerProfileSkin1.textures(playerProfileSkin.getValue());
        playerProfileSkin1.signature(playerProfileSkin.getSignature());
        return playerProfileSkin1.build();
    }

    @Override
    public com.mineplex.studio.dataplane.contracts.PlayerIdentity playerIdentityToGrpcPlayerIdentity(PlayerIdentity playerIdentity) {
        if (playerIdentity == null) {
            return null;
        }
        PlayerIdentity.Builder playerIdentity1 = com.mineplex.studio.dataplane.contracts.PlayerIdentity.newBuilder();
        if (playerIdentity.hasProfile()) {
            playerIdentity1.setProfile(this.playerProfileToGrpcPlayerProfile(this.commonMapper.unwrapOptional(playerIdentity.getProfile())));
        }
        if (playerIdentity.getId() != null) {
            playerIdentity1.setPlayerId(playerIdentity.getId().toString());
        }
        return playerIdentity1.build();
    }

    @Override
    public com.mineplex.studio.dataplane.contracts.PlayerProfile playerProfileToGrpcPlayerProfile(PlayerProfile playerProfile) {
        if (playerProfile == null) {
            return null;
        }
        PlayerProfile.Builder playerProfile1 = com.mineplex.studio.dataplane.contracts.PlayerProfile.newBuilder();
        if (playerProfile.hasSkin()) {
            playerProfile1.setSkin(this.playerProfileSkinToGrpcPlayerProfileSkin(this.commonMapper.unwrapOptional(playerProfile.getSkin())));
        }
        if (playerProfile.getId() != null) {
            playerProfile1.setPlayerId(playerProfile.getId().toString());
        }
        playerProfile1.setUsername(playerProfile.getName());
        return playerProfile1.build();
    }

    @Override
    public PlayerSkin playerProfileSkinToGrpcPlayerProfileSkin(PlayerProfileSkin playerProfileSkin) {
        if (playerProfileSkin == null) {
            return null;
        }
        PlayerSkin.Builder playerSkin = PlayerSkin.newBuilder();
        playerSkin.setValue(playerProfileSkin.getTextures());
        playerSkin.setSignature(playerProfileSkin.getSignature());
        return playerSkin.build();
    }

    @Override
    public PlayerProfileUpdate playerProfileToPlayerProfileUpdate(PlayerProfile playerProfile) {
        if (playerProfile == null) {
            return null;
        }
        PlayerProfileUpdate.Builder playerProfileUpdate = PlayerProfileUpdate.newBuilder();
        playerProfileUpdate.setUsername(playerProfile.getName());
        if (playerProfile.getId() != null) {
            playerProfileUpdate.setPlayerId(playerProfile.getId().toString());
        }
        if (playerProfile.hasSkin()) {
            playerProfileUpdate.setSkin(this.playerProfileSkinToGrpcPlayerProfileSkin(this.commonMapper.unwrapOptional(playerProfile.getSkin())));
        }
        return playerProfileUpdate.build();
    }
}

