/*
 * Decompiled with CFR 0.152.
 */
package com.mineplex.studio.dataplane.common.profile.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.mineplex.studio.dataplane.common.profile.model.PlayerProfileSkin;
import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=PlayerProfileBuilder.class)
public final class PlayerProfile
implements Serializable {
    private static final long serialVersionUID = 6514616253341059238L;
    @NonNull
    private final UUID id;
    @NonNull
    private final String name;
    @Nullable
    private final PlayerProfileSkin skin;

    public boolean hasSkin() {
        return this.getSkin().isPresent();
    }

    @NonNull
    public Optional<PlayerProfileSkin> getSkin() {
        return Optional.ofNullable(this.skin);
    }

    @Deprecated(forRemoval=true)
    @JsonIgnore
    @NonNull
    public UUID getUuid() {
        return this.getId();
    }

    @Generated
    PlayerProfile(@NonNull UUID id, @NonNull String name, @Nullable PlayerProfileSkin skin) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.id = id;
        this.name = name;
        this.skin = skin;
    }

    @Generated
    public static PlayerProfileBuilder builder() {
        return new PlayerProfileBuilder();
    }

    @Generated
    public PlayerProfileBuilder toBuilder() {
        return new PlayerProfileBuilder().id(this.id).name(this.name).skin(this.skin);
    }

    @NonNull
    @Generated
    public UUID getId() {
        return this.id;
    }

    @NonNull
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PlayerProfile)) {
            return false;
        }
        PlayerProfile other = (PlayerProfile)o;
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Optional<PlayerProfileSkin> this$skin = this.getSkin();
        Optional<PlayerProfileSkin> other$skin = other.getSkin();
        return !(this$skin == null ? other$skin != null : !((Object)this$skin).equals(other$skin));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Optional<PlayerProfileSkin> $skin = this.getSkin();
        result = result * 59 + ($skin == null ? 43 : ((Object)$skin).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PlayerProfile(id=" + String.valueOf(this.getId()) + ", name=" + this.getName() + ", skin=" + String.valueOf(this.getSkin()) + ")";
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    public static class PlayerProfileBuilder {
        @Generated
        private UUID id;
        @Generated
        private String name;
        @Generated
        private PlayerProfileSkin skin;

        @Generated
        PlayerProfileBuilder() {
        }

        @Generated
        public PlayerProfileBuilder id(@NonNull UUID id) {
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            this.id = id;
            return this;
        }

        @Generated
        public PlayerProfileBuilder name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        @Generated
        public PlayerProfileBuilder skin(@Nullable PlayerProfileSkin skin) {
            this.skin = skin;
            return this;
        }

        @Generated
        public PlayerProfile build() {
            return new PlayerProfile(this.id, this.name, this.skin);
        }

        @Generated
        public String toString() {
            return "PlayerProfile.PlayerProfileBuilder(id=" + String.valueOf(this.id) + ", name=" + this.name + ", skin=" + String.valueOf(this.skin) + ")";
        }
    }
}

