/*
 * Decompiled with CFR 0.152.
 */
package com.mineplex.studio.dataplane.common.punishment;

import com.mineplex.studio.dataplane.common.CommonGrpcMapper;
import com.mineplex.studio.dataplane.common.CommonMapper;
import com.mineplex.studio.dataplane.common.punishment.PunishmentGrpcMapper;
import com.mineplex.studio.dataplane.common.punishment.model.GlobalPunishmentImpl;
import com.mineplex.studio.dataplane.common.punishment.model.InternalPunishment;
import com.mineplex.studio.dataplane.common.punishment.model.Punishment;
import com.mineplex.studio.dataplane.common.punishment.model.PunishmentImpl;
import com.mineplex.studio.dataplane.common.punishment.model.PunishmentReason;
import com.mineplex.studio.dataplane.common.punishment.model.PunishmentReasonImpl;
import com.mineplex.studio.dataplane.common.punishment.model.PunishmentRemoval;
import com.mineplex.studio.dataplane.common.punishment.model.PunishmentRemovalImpl;
import com.mineplex.studio.dataplane.common.punishment.model.PunishmentType;
import com.mineplex.studio.dataplane.contracts.PunishmentReason;
import com.mineplex.studio.dataplane.contracts.PunishmentRemoval;
import com.mineplex.studio.dataplane.contracts.PunishmentRequest;
import com.mineplex.studio.dataplane.contracts.PunishmentResponse;
import com.mineplex.studio.deps.com.google.protobuf.ProtocolStringList;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.UUID;

public class PunishmentGrpcMapperImpl
implements PunishmentGrpcMapper {
    private final CommonGrpcMapper commonGrpcMapper = CommonGrpcMapper.INSTANCE;
    private final CommonMapper commonMapper = CommonMapper.INSTANCE;

    @Override
    public PunishmentRequest punishmentToPunishmentRequest(Punishment punishment) {
        if (punishment == null) {
            return null;
        }
        PunishmentRequest.Builder punishmentRequest = PunishmentRequest.newBuilder();
        if (punishment.hasNotes()) {
            punishmentRequest.setNotes(this.commonMapper.unwrapOptional(punishment.getNotes()));
        }
        if (punishment.hasRemovalInformation()) {
            punishmentRequest.setRemovalInformation(this.punishmentRemovalToGrpcPunishmentRemoval(this.commonMapper.unwrapOptional(punishment.getRemovalInformation())));
        }
        if (punishment.hasIdentifier()) {
            punishmentRequest.setIdentifier(this.commonMapper.unwrapOptional(punishment.getIdentifier()).toString());
        }
        punishmentRequest.setStartTimestamp(this.commonGrpcMapper.instantToGrpcTimestamp(punishment.getStartTimestamp()));
        punishmentRequest.setRemainingDuration(this.commonGrpcMapper.durationToGrpcDuration(punishment.getRemainingDuration()));
        if (punishment.hasModeratorId()) {
            punishmentRequest.setModeratorId(this.commonMapper.unwrapOptional(punishment.getModeratorId()).toString());
        }
        if (punishment.getApplicableProjects() != null) {
            for (String applicableProject : punishment.getApplicableProjects()) {
                punishmentRequest.addApplicableProjects(applicableProject);
            }
        }
        if (punishment.getPlayerId() != null) {
            punishmentRequest.setPlayerId(punishment.getPlayerId().toString());
        }
        punishmentRequest.setPunishmentReason(this.punishmentReasonToGrpcPunishmentReason(punishment.getPunishmentReason()));
        return punishmentRequest.build();
    }

    @Override
    public PunishmentResponse punishmentToPunishmentResponse(Punishment punishment, boolean minimalInfo) {
        if (punishment == null) {
            return null;
        }
        PunishmentResponse.Builder punishmentResponse = PunishmentResponse.newBuilder();
        if (punishment != null) {
            if (punishment.hasModeratorId()) {
                punishmentResponse.setModeratorId(this.commonMapper.unwrapOptional(punishment.getModeratorId()).toString());
            }
            if (punishment.hasNotes()) {
                punishmentResponse.setNotes(this.commonMapper.unwrapOptional(punishment.getNotes()));
            }
            if (punishment.hasRemovalInformation()) {
                punishmentResponse.setRemovalInformation(this.punishmentRemovalToGrpcPunishmentRemoval(this.commonMapper.unwrapOptional(punishment.getRemovalInformation())));
            }
            if (punishment.hasIdentifier()) {
                punishmentResponse.setIdentifier(this.commonMapper.unwrapOptional(punishment.getIdentifier()).toString());
            }
            punishmentResponse.setStartTimestamp(this.commonGrpcMapper.instantToGrpcTimestamp(punishment.getStartTimestamp()));
            punishmentResponse.setRemainingDuration(this.commonGrpcMapper.durationToGrpcDuration(punishment.getRemainingDuration()));
            if (punishment.getApplicableProjects() != null) {
                for (String punishmentApplicableProject : punishment.getApplicableProjects()) {
                    punishmentResponse.addApplicableProjects(punishmentApplicableProject);
                }
            }
            if (punishment.getPlayerId() != null) {
                punishmentResponse.setPlayerId(punishment.getPlayerId().toString());
            }
            punishmentResponse.setPunishmentReason(this.punishmentReasonToGrpcPunishmentReason(punishment.getPunishmentReason()));
            punishmentResponse.setGlobal(punishment.isGlobal());
        }
        punishmentResponse.setMinimalInfo(minimalInfo);
        return punishmentResponse.build();
    }

    @Override
    public com.mineplex.studio.dataplane.contracts.PunishmentReason punishmentReasonToGrpcPunishmentReason(PunishmentReason contract) {
        if (contract == null) {
            return null;
        }
        PunishmentReason.Builder punishmentReason = com.mineplex.studio.dataplane.contracts.PunishmentReason.newBuilder();
        punishmentReason.setDuration(this.commonGrpcMapper.durationToGrpcDuration(contract.getDuration()));
        punishmentReason.setReasonId(contract.getReasonIdentifier());
        punishmentReason.setType(this.punishmentTypeToPunishmentType(contract.getType()));
        punishmentReason.setDisplayReason(contract.getDisplayReason());
        punishmentReason.setPriority(contract.getPriority());
        return punishmentReason.build();
    }

    @Override
    public com.mineplex.studio.dataplane.contracts.PunishmentRemoval punishmentRemovalToGrpcPunishmentRemoval(PunishmentRemoval contract) {
        if (contract == null) {
            return null;
        }
        PunishmentRemoval.Builder punishmentRemoval = com.mineplex.studio.dataplane.contracts.PunishmentRemoval.newBuilder();
        punishmentRemoval.setRemovalTimestamp(this.commonGrpcMapper.instantToGrpcTimestamp(contract.getRemovalTimestamp()));
        if (contract.getRemovalModerator() != null) {
            punishmentRemoval.setRemovalModeratorId(contract.getRemovalModerator().toString());
        }
        punishmentRemoval.setRemoveFromHistory(contract.isRemoveFromHistory());
        punishmentRemoval.setRemovalReason(contract.getRemovalReason());
        return punishmentRemoval.build();
    }

    @Override
    public GlobalPunishmentImpl punishmentResponseToGlobalPunishment(PunishmentResponse punishmentResponse) {
        if (punishmentResponse == null) {
            return null;
        }
        GlobalPunishmentImpl.GlobalPunishmentImplBuilder globalPunishmentImpl = GlobalPunishmentImpl.builder();
        if (punishmentResponse.hasStartTimestamp()) {
            globalPunishmentImpl.startTimestamp(this.commonGrpcMapper.grpcTimestampToInstant(punishmentResponse.getStartTimestamp()));
        }
        if (punishmentResponse.getIdentifier() != null) {
            globalPunishmentImpl.identifier(UUID.fromString(punishmentResponse.getIdentifier()));
        }
        if (punishmentResponse.getPlayerId() != null) {
            globalPunishmentImpl.playerId(UUID.fromString(punishmentResponse.getPlayerId()));
        }
        if (punishmentResponse.hasPunishmentReason()) {
            globalPunishmentImpl.punishmentReason(this.punishmentReasonToPunishmentReason(punishmentResponse.getPunishmentReason()));
        }
        return globalPunishmentImpl.build();
    }

    @Override
    public PunishmentImpl punishmentResponseToPunishmentImpl(PunishmentResponse punishmentResponse) {
        if (punishmentResponse == null) {
            return null;
        }
        PunishmentImpl.PunishmentImplBuilder punishmentImpl = PunishmentImpl.builder();
        punishmentImpl.applicableProjects(this.commonGrpcMapper.protocolStringListToStringSet(punishmentResponse.getApplicableProjectsList()));
        if (punishmentResponse.hasStartTimestamp()) {
            punishmentImpl.startTimestamp(this.commonGrpcMapper.grpcTimestampToInstant(punishmentResponse.getStartTimestamp()));
        }
        if (punishmentResponse.getPlayerId() != null) {
            punishmentImpl.playerId(UUID.fromString(punishmentResponse.getPlayerId()));
        }
        if (punishmentResponse.hasModeratorId()) {
            punishmentImpl.moderatorId(UUID.fromString(punishmentResponse.getModeratorId()));
        }
        if (punishmentResponse.hasPunishmentReason()) {
            punishmentImpl.punishmentReason(this.punishmentReasonToPunishmentReason(punishmentResponse.getPunishmentReason()));
        }
        if (punishmentResponse.hasRemovalInformation()) {
            punishmentImpl.removalInformation(this.punishmentRemovalToPunishmentRemoval(punishmentResponse.getRemovalInformation()));
        }
        if (punishmentResponse.getIdentifier() != null) {
            punishmentImpl.identifier(UUID.fromString(punishmentResponse.getIdentifier()));
        }
        punishmentImpl.notes(punishmentResponse.getNotes());
        return punishmentImpl.build();
    }

    @Override
    public InternalPunishment punishmentResponseToInternalPunishment(PunishmentResponse punishmentResponse) {
        ProtocolStringList protocolStringList;
        if (punishmentResponse == null) {
            return null;
        }
        InternalPunishment.InternalPunishmentBuilder internalPunishment = InternalPunishment.builder();
        if (punishmentResponse.hasStartTimestamp()) {
            internalPunishment.startTimestamp(this.commonGrpcMapper.grpcTimestampToInstant(punishmentResponse.getStartTimestamp()));
        }
        if (punishmentResponse.getPlayerId() != null) {
            internalPunishment.playerId(UUID.fromString(punishmentResponse.getPlayerId()));
        }
        if (punishmentResponse.hasModeratorId()) {
            internalPunishment.moderatorId(UUID.fromString(punishmentResponse.getModeratorId()));
        }
        if ((protocolStringList = punishmentResponse.getApplicableProjectsList()) != null) {
            internalPunishment.applicableProjects(new LinkedHashSet<String>(protocolStringList));
        }
        if (punishmentResponse.hasPunishmentReason()) {
            internalPunishment.punishmentReason(this.punishmentReasonToPunishmentReason(punishmentResponse.getPunishmentReason()));
        }
        if (punishmentResponse.hasRemovalInformation()) {
            internalPunishment.removalInformation(this.punishmentRemovalToPunishmentRemoval(punishmentResponse.getRemovalInformation()));
        }
        if (punishmentResponse.getIdentifier() != null) {
            internalPunishment.identifier(UUID.fromString(punishmentResponse.getIdentifier()));
        }
        internalPunishment.notes(punishmentResponse.getNotes());
        internalPunishment.global(punishmentResponse.getGlobal());
        return internalPunishment.build();
    }

    @Override
    public PunishmentImpl punishmentToPunishmentImpl(Punishment punishment) {
        if (punishment == null) {
            return null;
        }
        PunishmentImpl.PunishmentImplBuilder punishmentImpl = PunishmentImpl.builder();
        if (punishment.hasModeratorId()) {
            punishmentImpl.moderatorId(this.commonMapper.unwrapOptional(punishment.getModeratorId()));
        }
        if (punishment.hasRemovalInformation()) {
            punishmentImpl.removalInformation(this.commonMapper.unwrapOptional(punishment.getRemovalInformation()));
        }
        if (punishment.hasIdentifier()) {
            punishmentImpl.identifier(this.commonMapper.unwrapOptional(punishment.getIdentifier()));
        }
        if (punishment.hasNotes()) {
            punishmentImpl.notes(this.commonMapper.unwrapOptional(punishment.getNotes()));
        }
        punishmentImpl.playerId(punishment.getPlayerId());
        punishmentImpl.startTimestamp(punishment.getStartTimestamp());
        Set<String> set = punishment.getApplicableProjects();
        if (set != null) {
            punishmentImpl.applicableProjects(new LinkedHashSet<String>(set));
        }
        punishmentImpl.punishmentReason(punishment.getPunishmentReason());
        return punishmentImpl.build();
    }

    @Override
    public InternalPunishment punishmentToInternalPunishment(Punishment punishment) {
        if (punishment == null) {
            return null;
        }
        InternalPunishment.InternalPunishmentBuilder internalPunishment = InternalPunishment.builder();
        if (punishment.hasModeratorId()) {
            internalPunishment.moderatorId(this.commonMapper.unwrapOptional(punishment.getModeratorId()));
        }
        if (punishment.hasRemovalInformation()) {
            internalPunishment.removalInformation(this.commonMapper.unwrapOptional(punishment.getRemovalInformation()));
        }
        if (punishment.hasIdentifier()) {
            internalPunishment.identifier(this.commonMapper.unwrapOptional(punishment.getIdentifier()));
        }
        if (punishment.hasNotes()) {
            internalPunishment.notes(this.commonMapper.unwrapOptional(punishment.getNotes()));
        }
        internalPunishment.playerId(punishment.getPlayerId());
        internalPunishment.startTimestamp(punishment.getStartTimestamp());
        Set<String> set = punishment.getApplicableProjects();
        if (set != null) {
            internalPunishment.applicableProjects(new LinkedHashSet<String>(set));
        }
        internalPunishment.punishmentReason(punishment.getPunishmentReason());
        internalPunishment.global(punishment.isGlobal());
        return internalPunishment.build();
    }

    @Override
    public PunishmentReasonImpl punishmentReasonToPunishmentReason(com.mineplex.studio.dataplane.contracts.PunishmentReason contract) {
        if (contract == null) {
            return null;
        }
        PunishmentReasonImpl.PunishmentReasonImplBuilder punishmentReasonImpl = PunishmentReasonImpl.builder();
        punishmentReasonImpl.reasonIdentifier(contract.getReasonId());
        if (contract.hasDuration()) {
            punishmentReasonImpl.duration(this.commonGrpcMapper.grpcDurationToDuration(contract.getDuration()));
        }
        punishmentReasonImpl.type(this.grpcPunishmentTypeToPunishmentType(contract.getType()));
        punishmentReasonImpl.displayReason(contract.getDisplayReason());
        punishmentReasonImpl.priority(contract.getPriority());
        return punishmentReasonImpl.build();
    }

    @Override
    public PunishmentRemovalImpl punishmentRemovalToPunishmentRemoval(com.mineplex.studio.dataplane.contracts.PunishmentRemoval contract) {
        if (contract == null) {
            return null;
        }
        PunishmentRemovalImpl.PunishmentRemovalImplBuilder punishmentRemovalImpl = PunishmentRemovalImpl.builder();
        if (contract.getRemovalModeratorId() != null) {
            punishmentRemovalImpl.removalModerator(UUID.fromString(contract.getRemovalModeratorId()));
        }
        if (contract.hasRemovalTimestamp()) {
            punishmentRemovalImpl.removalTimestamp(this.commonGrpcMapper.grpcTimestampToInstant(contract.getRemovalTimestamp()));
        }
        punishmentRemovalImpl.removeFromHistory(contract.getRemoveFromHistory());
        punishmentRemovalImpl.removalReason(contract.getRemovalReason());
        return punishmentRemovalImpl.build();
    }

    @Override
    public PunishmentType grpcPunishmentTypeToPunishmentType(com.mineplex.studio.dataplane.contracts.PunishmentType type) {
        if (type == null) {
            return null;
        }
        return switch (type) {
            case com.mineplex.studio.dataplane.contracts.PunishmentType.UNRECOGNIZED -> throw new IllegalArgumentException("Unexpected enum constant: " + String.valueOf(type));
            case com.mineplex.studio.dataplane.contracts.PunishmentType.BAN -> PunishmentType.BAN;
            case com.mineplex.studio.dataplane.contracts.PunishmentType.MUTE -> PunishmentType.MUTE;
            case com.mineplex.studio.dataplane.contracts.PunishmentType.TEMP_BAN -> PunishmentType.TEMP_BAN;
            case com.mineplex.studio.dataplane.contracts.PunishmentType.TEMP_MUTE -> PunishmentType.TEMP_MUTE;
            case com.mineplex.studio.dataplane.contracts.PunishmentType.WARNING -> PunishmentType.WARNING;
            case com.mineplex.studio.dataplane.contracts.PunishmentType.PUNISHMENT_TYPE_UNSPECIFIED -> null;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + String.valueOf(type));
        };
    }

    protected com.mineplex.studio.dataplane.contracts.PunishmentType punishmentTypeToPunishmentType(PunishmentType punishmentType) {
        if (punishmentType == null) {
            return com.mineplex.studio.dataplane.contracts.PunishmentType.PUNISHMENT_TYPE_UNSPECIFIED;
        }
        return switch (punishmentType) {
            case PunishmentType.TEMP_MUTE -> com.mineplex.studio.dataplane.contracts.PunishmentType.TEMP_MUTE;
            case PunishmentType.TEMP_BAN -> com.mineplex.studio.dataplane.contracts.PunishmentType.TEMP_BAN;
            case PunishmentType.MUTE -> com.mineplex.studio.dataplane.contracts.PunishmentType.MUTE;
            case PunishmentType.BAN -> com.mineplex.studio.dataplane.contracts.PunishmentType.BAN;
            case PunishmentType.WARNING -> com.mineplex.studio.dataplane.contracts.PunishmentType.WARNING;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + String.valueOf((Object)punishmentType));
        };
    }
}

