/*
 * Decompiled with CFR 0.152.
 */
package com.mineplex.studio.dataplane.common.punishment.model;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.mineplex.studio.dataplane.common.punishment.model.GlobalPunishmentImpl;
import com.mineplex.studio.dataplane.common.punishment.model.InternalPunishment;
import com.mineplex.studio.dataplane.common.punishment.model.PunishmentImpl;
import com.mineplex.studio.dataplane.common.punishment.model.PunishmentReason;
import com.mineplex.studio.dataplane.common.punishment.model.PunishmentRemoval;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import lombok.NonNull;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=PunishmentImpl.class, name="impl"), @JsonSubTypes.Type(value=GlobalPunishmentImpl.class, name="global"), @JsonSubTypes.Type(value=InternalPunishment.class, name="internal")})
public interface Punishment {
    default public boolean hasIdentifier() {
        return this.getIdentifier().isPresent();
    }

    @NonNull
    public Optional<UUID> getIdentifier();

    @NonNull
    public UUID getPlayerId();

    default public boolean hasModeratorId() {
        return this.getModeratorId().isPresent();
    }

    @NonNull
    public Optional<UUID> getModeratorId();

    @NonNull
    public Instant getStartTimestamp();

    @NonNull
    public @NonNull Set<@NonNull String> getApplicableProjects();

    @NonNull
    public PunishmentReason getPunishmentReason();

    default public boolean hasNotes() {
        return this.getNotes().isPresent();
    }

    @NonNull
    public Optional<String> getNotes();

    default public boolean appliesTo(@NonNull String projectIdentifier) {
        if (projectIdentifier == null) {
            throw new NullPointerException("projectIdentifier is marked non-null but is null");
        }
        return this.getApplicableProjects().contains(projectIdentifier);
    }

    default public boolean hasRemovalInformation() {
        return this.getRemovalInformation().isPresent();
    }

    @NonNull
    public @NonNull Optional<@NonNull PunishmentRemoval> getRemovalInformation();

    default public boolean isRemoved() {
        return this.getRemovalInformation().isPresent();
    }

    public boolean isGlobal();

    default public boolean isActive() {
        if (this.isRemoved()) {
            return false;
        }
        if (this.getPunishmentReason().getType().isPermanent()) {
            return true;
        }
        Duration remainingDuration = this.getRemainingDuration();
        return remainingDuration.compareTo(Duration.ZERO) > 0;
    }

    @NonNull
    default public Duration getRemainingDuration() {
        if (this.getPunishmentReason().getType().isPermanent()) {
            return Duration.ZERO;
        }
        Instant expiryTimestamp = this.getStartTimestamp().plus(this.getPunishmentReason().getDuration());
        Instant now = Instant.now();
        return Duration.between(now, expiryTimestamp);
    }
}

