/*
 * Decompiled with CFR 0.152.
 */
package com.mineplex.studio.dataplane.common.quest;

import com.mineplex.studio.dataplane.common.CommonGrpcMapper;
import com.mineplex.studio.dataplane.common.CommonMapper;
import com.mineplex.studio.dataplane.common.quest.QuestGrpcMapper;
import com.mineplex.studio.dataplane.common.quest.model.MineplexQuestDefinition;
import com.mineplex.studio.dataplane.common.quest.model.PlayerQuestProgress;
import com.mineplex.studio.dataplane.common.quest.model.Quest;
import com.mineplex.studio.dataplane.common.quest.model.QuestDifficulty;
import com.mineplex.studio.dataplane.common.quest.model.QuestFrequency;
import com.mineplex.studio.dataplane.common.quest.model.reward.QuestReward;
import com.mineplex.studio.dataplane.common.quest.model.reward.QuestRewardGrpcMapper;
import com.mineplex.studio.dataplane.contracts.QuestDefinition;
import com.mineplex.studio.dataplane.contracts.QuestTicket;
import com.mineplex.studio.deps.com.google.protobuf.ProtocolStringList;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class QuestGrpcMapperImpl
implements QuestGrpcMapper {
    private final CommonGrpcMapper commonGrpcMapper = CommonGrpcMapper.INSTANCE;
    private final CommonMapper commonMapper = CommonMapper.INSTANCE;
    private final QuestRewardGrpcMapper questRewardGrpcMapper = QuestRewardGrpcMapper.INSTANCE;

    @Override
    public MineplexQuestDefinition grpcQuestDefinitionToQuestDefinition(QuestDefinition questDefinition) {
        if (questDefinition == null) {
            return null;
        }
        MineplexQuestDefinition.MineplexQuestDefinitionBuilder mineplexQuestDefinition = MineplexQuestDefinition.builder();
        ProtocolStringList protocolStringList = questDefinition.getObjectiveDescriptionList();
        if (protocolStringList != null) {
            mineplexQuestDefinition.objective(new ArrayList<String>(protocolStringList));
        }
        mineplexQuestDefinition.key(questDefinition.getKey());
        mineplexQuestDefinition.projectId(questDefinition.getProjectId());
        mineplexQuestDefinition.displayName(questDefinition.getDisplayName());
        ProtocolStringList protocolStringList1 = questDefinition.getStudioRewardsList();
        if (protocolStringList1 != null) {
            mineplexQuestDefinition.studioRewards(new ArrayList<String>(protocolStringList1));
        }
        mineplexQuestDefinition.difficulty(this.grpcQuestDifficultyToQuestDifficulty(questDefinition.getDifficulty()));
        mineplexQuestDefinition.frequency(this.grpcQuestFrequencyToQuestFrequency(questDefinition.getFrequency()));
        mineplexQuestDefinition.requiredProgress(questDefinition.getRequiredProgress());
        return mineplexQuestDefinition.build();
    }

    @Override
    public QuestDifficulty grpcQuestDifficultyToQuestDifficulty(com.mineplex.studio.dataplane.contracts.QuestDifficulty questDifficulty) {
        if (questDifficulty == null) {
            return null;
        }
        return switch (questDifficulty) {
            case com.mineplex.studio.dataplane.contracts.QuestDifficulty.UNRECOGNIZED -> throw new IllegalArgumentException("Unexpected enum constant: " + String.valueOf(questDifficulty));
            case com.mineplex.studio.dataplane.contracts.QuestDifficulty.EASY -> QuestDifficulty.EASY;
            case com.mineplex.studio.dataplane.contracts.QuestDifficulty.MEDIUM -> QuestDifficulty.MEDIUM;
            case com.mineplex.studio.dataplane.contracts.QuestDifficulty.HARD -> QuestDifficulty.HARD;
            case com.mineplex.studio.dataplane.contracts.QuestDifficulty.QUEST_DIFFICULTY_UNSPECIFIED -> null;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + String.valueOf(questDifficulty));
        };
    }

    @Override
    public QuestFrequency grpcQuestFrequencyToQuestFrequency(com.mineplex.studio.dataplane.contracts.QuestFrequency questFrequency) {
        if (questFrequency == null) {
            return null;
        }
        return switch (questFrequency) {
            case com.mineplex.studio.dataplane.contracts.QuestFrequency.UNRECOGNIZED -> throw new IllegalArgumentException("Unexpected enum constant: " + String.valueOf(questFrequency));
            case com.mineplex.studio.dataplane.contracts.QuestFrequency.SEASON -> throw new IllegalArgumentException("Unexpected enum constant: " + String.valueOf(questFrequency));
            case com.mineplex.studio.dataplane.contracts.QuestFrequency.DAILY -> QuestFrequency.DAILY;
            case com.mineplex.studio.dataplane.contracts.QuestFrequency.WEEKLY -> QuestFrequency.WEEKLY;
            case com.mineplex.studio.dataplane.contracts.QuestFrequency.QUEST_FREQUENCY_UNSPECIFIED -> null;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + String.valueOf(questFrequency));
        };
    }

    @Override
    public PlayerQuestProgress grpcPlayerQuestProgressToPlayerQuestProgress(QuestTicket questTicket) {
        if (questTicket == null) {
            return null;
        }
        PlayerQuestProgress.PlayerQuestProgressBuilder playerQuestProgress = PlayerQuestProgress.builder();
        if (questTicket.getIdentifier() != null) {
            playerQuestProgress.ticketIdentifier(UUID.fromString(questTicket.getIdentifier()));
        }
        playerQuestProgress.questProjectIdentifier(questTicket.getProjectId());
        if (questTicket.hasTotalDuration()) {
            playerQuestProgress.questDuration(this.commonGrpcMapper.grpcDurationToDuration(questTicket.getTotalDuration()));
        }
        playerQuestProgress.progressMade(questTicket.getCurrentProgress());
        if (questTicket.hasAcceptedTimestamp()) {
            playerQuestProgress.collectedTimestamp(this.commonGrpcMapper.grpcTimestampToInstant(questTicket.getAcceptedTimestamp()));
        }
        if (questTicket.hasPlayerId()) {
            playerQuestProgress.assignedPlayerIdentifier(UUID.fromString(questTicket.getPlayerId()));
        }
        playerQuestProgress.questKey(questTicket.getQuestKey());
        playerQuestProgress.rewards(this.questRewardListToQuestRewardList(questTicket.getRewardsList()));
        playerQuestProgress.totalRequired(questTicket.getTotalRequired());
        return playerQuestProgress.build();
    }

    @Override
    public Quest grpcQuestTicketToQuest(QuestTicket questTicket) {
        if (questTicket == null) {
            return null;
        }
        Quest.QuestBuilder quest = Quest.builder();
        if (questTicket.hasUpdatedTimestamp()) {
            quest.updated(this.commonGrpcMapper.grpcTimestampToInstant(questTicket.getUpdatedTimestamp()));
        }
        quest.id(questTicket.getIdentifier());
        if (questTicket.hasGeneratedTimestamp()) {
            quest.generated(this.commonGrpcMapper.grpcTimestampToInstant(questTicket.getGeneratedTimestamp()));
        }
        if (questTicket.hasTotalDuration()) {
            quest.duration(this.commonGrpcMapper.grpcDurationToDuration(questTicket.getTotalDuration()));
        }
        if (questTicket.hasAcceptedTimestamp()) {
            quest.accepted(this.commonGrpcMapper.grpcTimestampToInstant(questTicket.getAcceptedTimestamp()));
        }
        if (questTicket.hasPlayerId()) {
            quest.playerId(UUID.fromString(questTicket.getPlayerId()));
        }
        quest.projectId(questTicket.getProjectId());
        quest.questKey(questTicket.getQuestKey());
        quest.totalRequired(questTicket.getTotalRequired());
        quest.currentProgress(questTicket.getCurrentProgress());
        quest.completed(questTicket.getCompleted());
        quest.invalid(questTicket.getInvalid());
        quest.rewards(this.questRewardListToQuestRewardList(questTicket.getRewardsList()));
        return quest.build();
    }

    @Override
    public QuestTicket questToGrpcQuestTicket(Quest quest) {
        if (quest == null) {
            return null;
        }
        QuestTicket.Builder questTicket = QuestTicket.newBuilder();
        if (quest.hasAccepted()) {
            questTicket.setAcceptedTimestamp(this.commonGrpcMapper.optionalInstantToGrpcTimestamp(quest.getAccepted()));
        }
        questTicket.setGeneratedTimestamp(this.commonGrpcMapper.instantToGrpcTimestamp(quest.getGenerated()));
        questTicket.setIdentifier(quest.getId());
        questTicket.setUpdatedTimestamp(this.commonGrpcMapper.instantToGrpcTimestamp(quest.getUpdated()));
        questTicket.setTotalDuration(this.commonGrpcMapper.durationToGrpcDuration(quest.getDuration()));
        if (quest.hasPlayerId()) {
            questTicket.setPlayerId(this.commonMapper.unwrapOptional(quest.getPlayerId()).toString());
        }
        questTicket.setProjectId(quest.getProjectId());
        questTicket.setQuestKey(quest.getQuestKey());
        questTicket.setTotalRequired(quest.getTotalRequired());
        questTicket.setCurrentProgress(quest.getCurrentProgress());
        questTicket.setCompleted(quest.isCompleted());
        questTicket.setInvalid(quest.isInvalid());
        if (quest.getRewards() != null) {
            for (QuestReward reward : quest.getRewards()) {
                questTicket.addRewards(this.questRewardGrpcMapper.questRewardToGrpcQuestReward(reward));
            }
        }
        return questTicket.build();
    }

    @Override
    public QuestDefinition questDefinitionToGrpcQuestDefinition(MineplexQuestDefinition questDefinition) {
        if (questDefinition == null) {
            return null;
        }
        QuestDefinition.Builder questDefinition1 = QuestDefinition.newBuilder();
        if (questDefinition.getObjective() != null) {
            for (String objective : questDefinition.getObjective()) {
                questDefinition1.addObjectiveDescription(objective);
            }
        }
        questDefinition1.setKey(questDefinition.getKey());
        questDefinition1.setProjectId(questDefinition.getProjectId());
        questDefinition1.setDisplayName(questDefinition.getDisplayName());
        questDefinition1.setDifficulty(this.questDifficultyToQuestDifficulty(questDefinition.getDifficulty()));
        questDefinition1.setFrequency(this.questFrequencyToQuestFrequency(questDefinition.getFrequency()));
        questDefinition1.setRequiredProgress(questDefinition.getRequiredProgress());
        if (questDefinition.getStudioRewards() != null) {
            for (String studioReward : questDefinition.getStudioRewards()) {
                questDefinition1.addStudioRewards(studioReward);
            }
        }
        return questDefinition1.build();
    }

    @Override
    public QuestTicket playerQuestProgressToGrpcQuestTicket(PlayerQuestProgress playerQuestProgress) {
        if (playerQuestProgress == null) {
            return null;
        }
        QuestTicket.Builder questTicket = QuestTicket.newBuilder();
        questTicket.setAcceptedTimestamp(this.commonGrpcMapper.instantToGrpcTimestamp(playerQuestProgress.getCollectedTimestamp()));
        questTicket.setTotalDuration(this.commonGrpcMapper.durationToGrpcDuration(playerQuestProgress.getQuestDuration()));
        questTicket.setProjectId(playerQuestProgress.getQuestProjectIdentifier());
        if (playerQuestProgress.getAssignedPlayerIdentifier() != null) {
            questTicket.setPlayerId(playerQuestProgress.getAssignedPlayerIdentifier().toString());
        }
        if (playerQuestProgress.getTicketIdentifier() != null) {
            questTicket.setIdentifier(playerQuestProgress.getTicketIdentifier().toString());
        }
        questTicket.setCurrentProgress(playerQuestProgress.getProgressMade());
        questTicket.setQuestKey(playerQuestProgress.getQuestKey());
        questTicket.setTotalRequired(playerQuestProgress.getTotalRequired());
        if (playerQuestProgress.getRewards() != null) {
            for (QuestReward reward : playerQuestProgress.getRewards()) {
                questTicket.addRewards(this.questRewardGrpcMapper.questRewardToGrpcQuestReward(reward));
            }
        }
        return questTicket.build();
    }

    protected List<QuestReward> questRewardListToQuestRewardList(List<com.mineplex.studio.dataplane.contracts.QuestReward> list) {
        if (list == null) {
            return null;
        }
        ArrayList<QuestReward> list1 = new ArrayList<QuestReward>(list.size());
        for (com.mineplex.studio.dataplane.contracts.QuestReward questReward : list) {
            list1.add(this.questRewardGrpcMapper.grpcQuestRewardToQuestReward(questReward));
        }
        return list1;
    }

    protected com.mineplex.studio.dataplane.contracts.QuestDifficulty questDifficultyToQuestDifficulty(QuestDifficulty questDifficulty) {
        if (questDifficulty == null) {
            return com.mineplex.studio.dataplane.contracts.QuestDifficulty.QUEST_DIFFICULTY_UNSPECIFIED;
        }
        return switch (questDifficulty) {
            case QuestDifficulty.EASY -> com.mineplex.studio.dataplane.contracts.QuestDifficulty.EASY;
            case QuestDifficulty.MEDIUM -> com.mineplex.studio.dataplane.contracts.QuestDifficulty.MEDIUM;
            case QuestDifficulty.HARD -> com.mineplex.studio.dataplane.contracts.QuestDifficulty.HARD;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + String.valueOf((Object)questDifficulty));
        };
    }

    protected com.mineplex.studio.dataplane.contracts.QuestFrequency questFrequencyToQuestFrequency(QuestFrequency questFrequency) {
        if (questFrequency == null) {
            return com.mineplex.studio.dataplane.contracts.QuestFrequency.QUEST_FREQUENCY_UNSPECIFIED;
        }
        return switch (questFrequency) {
            case QuestFrequency.DAILY -> com.mineplex.studio.dataplane.contracts.QuestFrequency.DAILY;
            case QuestFrequency.WEEKLY -> com.mineplex.studio.dataplane.contracts.QuestFrequency.WEEKLY;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + String.valueOf((Object)questFrequency));
        };
    }
}

