/*
 * Decompiled with CFR 0.152.
 */
package com.mineplex.studio.dataplane.common.quest.message;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.mineplex.studio.dataplane.common.profile.model.PlayerIdentity;
import com.mineplex.studio.dataplane.common.quest.model.PlayerQuestProgress;
import lombok.Generated;
import lombok.NonNull;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=QuestPlayerProgressUpdateMessageBuilder.class)
public final class QuestPlayerProgressUpdateMessage {
    public static final String MESSAGE_CHANNEL = "quest_player_progress_update";
    @NonNull
    private final PlayerIdentity player;
    @NonNull
    private final PlayerQuestProgress quest;
    private final int previousProgress;

    public int getProgress() {
        return this.quest.getProgressMade();
    }

    @Generated
    QuestPlayerProgressUpdateMessage(@NonNull PlayerIdentity player, @NonNull PlayerQuestProgress quest, int previousProgress) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (quest == null) {
            throw new NullPointerException("quest is marked non-null but is null");
        }
        this.player = player;
        this.quest = quest;
        this.previousProgress = previousProgress;
    }

    @Generated
    public static QuestPlayerProgressUpdateMessageBuilder builder() {
        return new QuestPlayerProgressUpdateMessageBuilder();
    }

    @NonNull
    @Generated
    public PlayerIdentity getPlayer() {
        return this.player;
    }

    @NonNull
    @Generated
    public PlayerQuestProgress getQuest() {
        return this.quest;
    }

    @Generated
    public int getPreviousProgress() {
        return this.previousProgress;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QuestPlayerProgressUpdateMessage)) {
            return false;
        }
        QuestPlayerProgressUpdateMessage other = (QuestPlayerProgressUpdateMessage)o;
        if (this.getPreviousProgress() != other.getPreviousProgress()) {
            return false;
        }
        PlayerIdentity this$player = this.getPlayer();
        PlayerIdentity other$player = other.getPlayer();
        if (this$player == null ? other$player != null : !((Object)this$player).equals(other$player)) {
            return false;
        }
        PlayerQuestProgress this$quest = this.getQuest();
        PlayerQuestProgress other$quest = other.getQuest();
        return !(this$quest == null ? other$quest != null : !((Object)this$quest).equals(other$quest));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPreviousProgress();
        PlayerIdentity $player = this.getPlayer();
        result = result * 59 + ($player == null ? 43 : ((Object)$player).hashCode());
        PlayerQuestProgress $quest = this.getQuest();
        result = result * 59 + ($quest == null ? 43 : ((Object)$quest).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "QuestPlayerProgressUpdateMessage(player=" + String.valueOf(this.getPlayer()) + ", quest=" + String.valueOf(this.getQuest()) + ", previousProgress=" + this.getPreviousProgress() + ")";
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    public static class QuestPlayerProgressUpdateMessageBuilder {
        @Generated
        private PlayerIdentity player;
        @Generated
        private PlayerQuestProgress quest;
        @Generated
        private int previousProgress;

        @Generated
        QuestPlayerProgressUpdateMessageBuilder() {
        }

        @Generated
        public QuestPlayerProgressUpdateMessageBuilder player(@NonNull PlayerIdentity player) {
            if (player == null) {
                throw new NullPointerException("player is marked non-null but is null");
            }
            this.player = player;
            return this;
        }

        @Generated
        public QuestPlayerProgressUpdateMessageBuilder quest(@NonNull PlayerQuestProgress quest) {
            if (quest == null) {
                throw new NullPointerException("quest is marked non-null but is null");
            }
            this.quest = quest;
            return this;
        }

        @Generated
        public QuestPlayerProgressUpdateMessageBuilder previousProgress(int previousProgress) {
            this.previousProgress = previousProgress;
            return this;
        }

        @Generated
        public QuestPlayerProgressUpdateMessage build() {
            return new QuestPlayerProgressUpdateMessage(this.player, this.quest, this.previousProgress);
        }

        @Generated
        public String toString() {
            return "QuestPlayerProgressUpdateMessage.QuestPlayerProgressUpdateMessageBuilder(player=" + String.valueOf(this.player) + ", quest=" + String.valueOf(this.quest) + ", previousProgress=" + this.previousProgress + ")";
        }
    }
}

