/*
 * Decompiled with CFR 0.152.
 */
package com.mineplex.studio.dataplane.common.quest.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.mineplex.studio.dataplane.common.quest.model.reward.QuestReward;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=PlayerQuestProgressBuilder.class)
public final class PlayerQuestProgress {
    @NonNull
    private final UUID ticketIdentifier;
    @NonNull
    private final UUID assignedPlayerIdentifier;
    @NonNull
    private final String questKey;
    @NonNull
    private final List<QuestReward> rewards;
    @NonNull
    private final String questProjectIdentifier;
    @NonNull
    private final Instant collectedTimestamp;
    @NonNull
    private final Duration questDuration;
    private final int totalRequired;
    private final int progressMade;

    @NonNull
    public Instant getExpiryTimestamp() {
        return this.collectedTimestamp.plus(this.questDuration);
    }

    public boolean hasExpired() {
        return this.getExpiryTimestamp().isBefore(Instant.now());
    }

    public boolean isComplete() {
        return this.progressMade >= this.totalRequired;
    }

    public double getProgressPercentage() {
        if (this.totalRequired <= 0 || this.progressMade <= 0) {
            return 0.0;
        }
        return (double)this.progressMade / (double)this.totalRequired * 100.0;
    }

    @Generated
    PlayerQuestProgress(@NonNull UUID ticketIdentifier, @NonNull UUID assignedPlayerIdentifier, @NonNull String questKey, @NonNull List<QuestReward> rewards, @NonNull String questProjectIdentifier, @NonNull Instant collectedTimestamp, @NonNull Duration questDuration, int totalRequired, int progressMade) {
        if (ticketIdentifier == null) {
            throw new NullPointerException("ticketIdentifier is marked non-null but is null");
        }
        if (assignedPlayerIdentifier == null) {
            throw new NullPointerException("assignedPlayerIdentifier is marked non-null but is null");
        }
        if (questKey == null) {
            throw new NullPointerException("questKey is marked non-null but is null");
        }
        if (rewards == null) {
            throw new NullPointerException("rewards is marked non-null but is null");
        }
        if (questProjectIdentifier == null) {
            throw new NullPointerException("questProjectIdentifier is marked non-null but is null");
        }
        if (collectedTimestamp == null) {
            throw new NullPointerException("collectedTimestamp is marked non-null but is null");
        }
        if (questDuration == null) {
            throw new NullPointerException("questDuration is marked non-null but is null");
        }
        this.ticketIdentifier = ticketIdentifier;
        this.assignedPlayerIdentifier = assignedPlayerIdentifier;
        this.questKey = questKey;
        this.rewards = rewards;
        this.questProjectIdentifier = questProjectIdentifier;
        this.collectedTimestamp = collectedTimestamp;
        this.questDuration = questDuration;
        this.totalRequired = totalRequired;
        this.progressMade = progressMade;
    }

    @Generated
    public static PlayerQuestProgressBuilder builder() {
        return new PlayerQuestProgressBuilder();
    }

    @Generated
    public PlayerQuestProgressBuilder toBuilder() {
        return new PlayerQuestProgressBuilder().ticketIdentifier(this.ticketIdentifier).assignedPlayerIdentifier(this.assignedPlayerIdentifier).questKey(this.questKey).rewards(this.rewards).questProjectIdentifier(this.questProjectIdentifier).collectedTimestamp(this.collectedTimestamp).questDuration(this.questDuration).totalRequired(this.totalRequired).progressMade(this.progressMade);
    }

    @NonNull
    @Generated
    public UUID getTicketIdentifier() {
        return this.ticketIdentifier;
    }

    @NonNull
    @Generated
    public UUID getAssignedPlayerIdentifier() {
        return this.assignedPlayerIdentifier;
    }

    @NonNull
    @Generated
    public String getQuestKey() {
        return this.questKey;
    }

    @NonNull
    @Generated
    public List<QuestReward> getRewards() {
        return this.rewards;
    }

    @NonNull
    @Generated
    public String getQuestProjectIdentifier() {
        return this.questProjectIdentifier;
    }

    @NonNull
    @Generated
    public Instant getCollectedTimestamp() {
        return this.collectedTimestamp;
    }

    @NonNull
    @Generated
    public Duration getQuestDuration() {
        return this.questDuration;
    }

    @Generated
    public int getTotalRequired() {
        return this.totalRequired;
    }

    @Generated
    public int getProgressMade() {
        return this.progressMade;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PlayerQuestProgress)) {
            return false;
        }
        PlayerQuestProgress other = (PlayerQuestProgress)o;
        if (this.getTotalRequired() != other.getTotalRequired()) {
            return false;
        }
        if (this.getProgressMade() != other.getProgressMade()) {
            return false;
        }
        UUID this$ticketIdentifier = this.getTicketIdentifier();
        UUID other$ticketIdentifier = other.getTicketIdentifier();
        if (this$ticketIdentifier == null ? other$ticketIdentifier != null : !((Object)this$ticketIdentifier).equals(other$ticketIdentifier)) {
            return false;
        }
        UUID this$assignedPlayerIdentifier = this.getAssignedPlayerIdentifier();
        UUID other$assignedPlayerIdentifier = other.getAssignedPlayerIdentifier();
        if (this$assignedPlayerIdentifier == null ? other$assignedPlayerIdentifier != null : !((Object)this$assignedPlayerIdentifier).equals(other$assignedPlayerIdentifier)) {
            return false;
        }
        String this$questKey = this.getQuestKey();
        String other$questKey = other.getQuestKey();
        if (this$questKey == null ? other$questKey != null : !this$questKey.equals(other$questKey)) {
            return false;
        }
        List<QuestReward> this$rewards = this.getRewards();
        List<QuestReward> other$rewards = other.getRewards();
        if (this$rewards == null ? other$rewards != null : !((Object)this$rewards).equals(other$rewards)) {
            return false;
        }
        String this$questProjectIdentifier = this.getQuestProjectIdentifier();
        String other$questProjectIdentifier = other.getQuestProjectIdentifier();
        if (this$questProjectIdentifier == null ? other$questProjectIdentifier != null : !this$questProjectIdentifier.equals(other$questProjectIdentifier)) {
            return false;
        }
        Instant this$collectedTimestamp = this.getCollectedTimestamp();
        Instant other$collectedTimestamp = other.getCollectedTimestamp();
        if (this$collectedTimestamp == null ? other$collectedTimestamp != null : !((Object)this$collectedTimestamp).equals(other$collectedTimestamp)) {
            return false;
        }
        Duration this$questDuration = this.getQuestDuration();
        Duration other$questDuration = other.getQuestDuration();
        return !(this$questDuration == null ? other$questDuration != null : !((Object)this$questDuration).equals(other$questDuration));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTotalRequired();
        result = result * 59 + this.getProgressMade();
        UUID $ticketIdentifier = this.getTicketIdentifier();
        result = result * 59 + ($ticketIdentifier == null ? 43 : ((Object)$ticketIdentifier).hashCode());
        UUID $assignedPlayerIdentifier = this.getAssignedPlayerIdentifier();
        result = result * 59 + ($assignedPlayerIdentifier == null ? 43 : ((Object)$assignedPlayerIdentifier).hashCode());
        String $questKey = this.getQuestKey();
        result = result * 59 + ($questKey == null ? 43 : $questKey.hashCode());
        List<QuestReward> $rewards = this.getRewards();
        result = result * 59 + ($rewards == null ? 43 : ((Object)$rewards).hashCode());
        String $questProjectIdentifier = this.getQuestProjectIdentifier();
        result = result * 59 + ($questProjectIdentifier == null ? 43 : $questProjectIdentifier.hashCode());
        Instant $collectedTimestamp = this.getCollectedTimestamp();
        result = result * 59 + ($collectedTimestamp == null ? 43 : ((Object)$collectedTimestamp).hashCode());
        Duration $questDuration = this.getQuestDuration();
        result = result * 59 + ($questDuration == null ? 43 : ((Object)$questDuration).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PlayerQuestProgress(ticketIdentifier=" + String.valueOf(this.getTicketIdentifier()) + ", assignedPlayerIdentifier=" + String.valueOf(this.getAssignedPlayerIdentifier()) + ", questKey=" + this.getQuestKey() + ", rewards=" + String.valueOf(this.getRewards()) + ", questProjectIdentifier=" + this.getQuestProjectIdentifier() + ", collectedTimestamp=" + String.valueOf(this.getCollectedTimestamp()) + ", questDuration=" + String.valueOf(this.getQuestDuration()) + ", totalRequired=" + this.getTotalRequired() + ", progressMade=" + this.getProgressMade() + ")";
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    public static class PlayerQuestProgressBuilder {
        @Generated
        private UUID ticketIdentifier;
        @Generated
        private UUID assignedPlayerIdentifier;
        @Generated
        private String questKey;
        @Generated
        private List<QuestReward> rewards;
        @Generated
        private String questProjectIdentifier;
        @Generated
        private Instant collectedTimestamp;
        @Generated
        private Duration questDuration;
        @Generated
        private int totalRequired;
        @Generated
        private int progressMade;

        @Generated
        PlayerQuestProgressBuilder() {
        }

        @Generated
        public PlayerQuestProgressBuilder ticketIdentifier(@NonNull UUID ticketIdentifier) {
            if (ticketIdentifier == null) {
                throw new NullPointerException("ticketIdentifier is marked non-null but is null");
            }
            this.ticketIdentifier = ticketIdentifier;
            return this;
        }

        @Generated
        public PlayerQuestProgressBuilder assignedPlayerIdentifier(@NonNull UUID assignedPlayerIdentifier) {
            if (assignedPlayerIdentifier == null) {
                throw new NullPointerException("assignedPlayerIdentifier is marked non-null but is null");
            }
            this.assignedPlayerIdentifier = assignedPlayerIdentifier;
            return this;
        }

        @Generated
        public PlayerQuestProgressBuilder questKey(@NonNull String questKey) {
            if (questKey == null) {
                throw new NullPointerException("questKey is marked non-null but is null");
            }
            this.questKey = questKey;
            return this;
        }

        @Generated
        public PlayerQuestProgressBuilder rewards(@NonNull List<QuestReward> rewards) {
            if (rewards == null) {
                throw new NullPointerException("rewards is marked non-null but is null");
            }
            this.rewards = rewards;
            return this;
        }

        @Generated
        public PlayerQuestProgressBuilder questProjectIdentifier(@NonNull String questProjectIdentifier) {
            if (questProjectIdentifier == null) {
                throw new NullPointerException("questProjectIdentifier is marked non-null but is null");
            }
            this.questProjectIdentifier = questProjectIdentifier;
            return this;
        }

        @Generated
        public PlayerQuestProgressBuilder collectedTimestamp(@NonNull Instant collectedTimestamp) {
            if (collectedTimestamp == null) {
                throw new NullPointerException("collectedTimestamp is marked non-null but is null");
            }
            this.collectedTimestamp = collectedTimestamp;
            return this;
        }

        @Generated
        public PlayerQuestProgressBuilder questDuration(@NonNull Duration questDuration) {
            if (questDuration == null) {
                throw new NullPointerException("questDuration is marked non-null but is null");
            }
            this.questDuration = questDuration;
            return this;
        }

        @Generated
        public PlayerQuestProgressBuilder totalRequired(int totalRequired) {
            this.totalRequired = totalRequired;
            return this;
        }

        @Generated
        public PlayerQuestProgressBuilder progressMade(int progressMade) {
            this.progressMade = progressMade;
            return this;
        }

        @Generated
        public PlayerQuestProgress build() {
            return new PlayerQuestProgress(this.ticketIdentifier, this.assignedPlayerIdentifier, this.questKey, this.rewards, this.questProjectIdentifier, this.collectedTimestamp, this.questDuration, this.totalRequired, this.progressMade);
        }

        @Generated
        public String toString() {
            return "PlayerQuestProgress.PlayerQuestProgressBuilder(ticketIdentifier=" + String.valueOf(this.ticketIdentifier) + ", assignedPlayerIdentifier=" + String.valueOf(this.assignedPlayerIdentifier) + ", questKey=" + this.questKey + ", rewards=" + String.valueOf(this.rewards) + ", questProjectIdentifier=" + this.questProjectIdentifier + ", collectedTimestamp=" + String.valueOf(this.collectedTimestamp) + ", questDuration=" + String.valueOf(this.questDuration) + ", totalRequired=" + this.totalRequired + ", progressMade=" + this.progressMade + ")";
        }
    }
}

