/*
 * Decompiled with CFR 0.152.
 */
package com.mineplex.studio.dataplane.common.quest.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.mineplex.studio.dataplane.common.quest.model.reward.QuestReward;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import lombok.Generated;
import lombok.NonNull;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=QuestBuilder.class)
public final class Quest {
    @NonNull
    private final String id;
    @Nullable
    private final UUID playerId;
    @Nullable
    private final Instant accepted;
    @NonNull
    private final Instant updated;
    @NonNull
    private final Instant generated;
    @NonNull
    private final Duration duration;
    @NonNull
    private final String projectId;
    @NonNull
    private final String questKey;
    private final int totalRequired;
    private final int currentProgress;
    private final boolean completed;
    private final boolean invalid;
    @NonNull
    private final List<QuestReward> rewards;

    public boolean hasPlayerId() {
        return this.playerId != null;
    }

    public Optional<UUID> getPlayerId() {
        return Optional.ofNullable(this.playerId);
    }

    public boolean hasAccepted() {
        return this.accepted != null;
    }

    public Optional<Instant> getAccepted() {
        return Optional.ofNullable(this.accepted);
    }

    @Generated
    Quest(@NonNull String id, @Nullable UUID playerId, @Nullable Instant accepted, @NonNull Instant updated, @NonNull Instant generated, @NonNull Duration duration, @NonNull String projectId, @NonNull String questKey, int totalRequired, int currentProgress, boolean completed, boolean invalid, @NonNull List<QuestReward> rewards) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (updated == null) {
            throw new NullPointerException("updated is marked non-null but is null");
        }
        if (generated == null) {
            throw new NullPointerException("generated is marked non-null but is null");
        }
        if (duration == null) {
            throw new NullPointerException("duration is marked non-null but is null");
        }
        if (projectId == null) {
            throw new NullPointerException("projectId is marked non-null but is null");
        }
        if (questKey == null) {
            throw new NullPointerException("questKey is marked non-null but is null");
        }
        if (rewards == null) {
            throw new NullPointerException("rewards is marked non-null but is null");
        }
        this.id = id;
        this.playerId = playerId;
        this.accepted = accepted;
        this.updated = updated;
        this.generated = generated;
        this.duration = duration;
        this.projectId = projectId;
        this.questKey = questKey;
        this.totalRequired = totalRequired;
        this.currentProgress = currentProgress;
        this.completed = completed;
        this.invalid = invalid;
        this.rewards = rewards;
    }

    @Generated
    public static QuestBuilder builder() {
        return new QuestBuilder();
    }

    @Generated
    public QuestBuilder toBuilder() {
        return new QuestBuilder().id(this.id).playerId(this.playerId).accepted(this.accepted).updated(this.updated).generated(this.generated).duration(this.duration).projectId(this.projectId).questKey(this.questKey).totalRequired(this.totalRequired).currentProgress(this.currentProgress).completed(this.completed).invalid(this.invalid).rewards(this.rewards);
    }

    @NonNull
    @Generated
    public String getId() {
        return this.id;
    }

    @NonNull
    @Generated
    public Instant getUpdated() {
        return this.updated;
    }

    @NonNull
    @Generated
    public Instant getGenerated() {
        return this.generated;
    }

    @NonNull
    @Generated
    public Duration getDuration() {
        return this.duration;
    }

    @NonNull
    @Generated
    public String getProjectId() {
        return this.projectId;
    }

    @NonNull
    @Generated
    public String getQuestKey() {
        return this.questKey;
    }

    @Generated
    public int getTotalRequired() {
        return this.totalRequired;
    }

    @Generated
    public int getCurrentProgress() {
        return this.currentProgress;
    }

    @Generated
    public boolean isCompleted() {
        return this.completed;
    }

    @Generated
    public boolean isInvalid() {
        return this.invalid;
    }

    @NonNull
    @Generated
    public List<QuestReward> getRewards() {
        return this.rewards;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Quest)) {
            return false;
        }
        Quest other = (Quest)o;
        if (this.getTotalRequired() != other.getTotalRequired()) {
            return false;
        }
        if (this.getCurrentProgress() != other.getCurrentProgress()) {
            return false;
        }
        if (this.isCompleted() != other.isCompleted()) {
            return false;
        }
        if (this.isInvalid() != other.isInvalid()) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Optional<UUID> this$playerId = this.getPlayerId();
        Optional<UUID> other$playerId = other.getPlayerId();
        if (this$playerId == null ? other$playerId != null : !((Object)this$playerId).equals(other$playerId)) {
            return false;
        }
        Optional<Instant> this$accepted = this.getAccepted();
        Optional<Instant> other$accepted = other.getAccepted();
        if (this$accepted == null ? other$accepted != null : !((Object)this$accepted).equals(other$accepted)) {
            return false;
        }
        Instant this$updated = this.getUpdated();
        Instant other$updated = other.getUpdated();
        if (this$updated == null ? other$updated != null : !((Object)this$updated).equals(other$updated)) {
            return false;
        }
        Instant this$generated = this.getGenerated();
        Instant other$generated = other.getGenerated();
        if (this$generated == null ? other$generated != null : !((Object)this$generated).equals(other$generated)) {
            return false;
        }
        Duration this$duration = this.getDuration();
        Duration other$duration = other.getDuration();
        if (this$duration == null ? other$duration != null : !((Object)this$duration).equals(other$duration)) {
            return false;
        }
        String this$projectId = this.getProjectId();
        String other$projectId = other.getProjectId();
        if (this$projectId == null ? other$projectId != null : !this$projectId.equals(other$projectId)) {
            return false;
        }
        String this$questKey = this.getQuestKey();
        String other$questKey = other.getQuestKey();
        if (this$questKey == null ? other$questKey != null : !this$questKey.equals(other$questKey)) {
            return false;
        }
        List<QuestReward> this$rewards = this.getRewards();
        List<QuestReward> other$rewards = other.getRewards();
        return !(this$rewards == null ? other$rewards != null : !((Object)this$rewards).equals(other$rewards));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTotalRequired();
        result = result * 59 + this.getCurrentProgress();
        result = result * 59 + (this.isCompleted() ? 79 : 97);
        result = result * 59 + (this.isInvalid() ? 79 : 97);
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Optional<UUID> $playerId = this.getPlayerId();
        result = result * 59 + ($playerId == null ? 43 : ((Object)$playerId).hashCode());
        Optional<Instant> $accepted = this.getAccepted();
        result = result * 59 + ($accepted == null ? 43 : ((Object)$accepted).hashCode());
        Instant $updated = this.getUpdated();
        result = result * 59 + ($updated == null ? 43 : ((Object)$updated).hashCode());
        Instant $generated = this.getGenerated();
        result = result * 59 + ($generated == null ? 43 : ((Object)$generated).hashCode());
        Duration $duration = this.getDuration();
        result = result * 59 + ($duration == null ? 43 : ((Object)$duration).hashCode());
        String $projectId = this.getProjectId();
        result = result * 59 + ($projectId == null ? 43 : $projectId.hashCode());
        String $questKey = this.getQuestKey();
        result = result * 59 + ($questKey == null ? 43 : $questKey.hashCode());
        List<QuestReward> $rewards = this.getRewards();
        result = result * 59 + ($rewards == null ? 43 : ((Object)$rewards).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Quest(id=" + this.getId() + ", playerId=" + String.valueOf(this.getPlayerId()) + ", accepted=" + String.valueOf(this.getAccepted()) + ", updated=" + String.valueOf(this.getUpdated()) + ", generated=" + String.valueOf(this.getGenerated()) + ", duration=" + String.valueOf(this.getDuration()) + ", projectId=" + this.getProjectId() + ", questKey=" + this.getQuestKey() + ", totalRequired=" + this.getTotalRequired() + ", currentProgress=" + this.getCurrentProgress() + ", completed=" + this.isCompleted() + ", invalid=" + this.isInvalid() + ", rewards=" + String.valueOf(this.getRewards()) + ")";
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    public static class QuestBuilder {
        @Generated
        private String id;
        @Generated
        private UUID playerId;
        @Generated
        private Instant accepted;
        @Generated
        private Instant updated;
        @Generated
        private Instant generated;
        @Generated
        private Duration duration;
        @Generated
        private String projectId;
        @Generated
        private String questKey;
        @Generated
        private int totalRequired;
        @Generated
        private int currentProgress;
        @Generated
        private boolean completed;
        @Generated
        private boolean invalid;
        @Generated
        private List<QuestReward> rewards;

        @Generated
        QuestBuilder() {
        }

        @Generated
        public QuestBuilder id(@NonNull String id) {
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            this.id = id;
            return this;
        }

        @Generated
        public QuestBuilder playerId(@Nullable UUID playerId) {
            this.playerId = playerId;
            return this;
        }

        @Generated
        public QuestBuilder accepted(@Nullable Instant accepted) {
            this.accepted = accepted;
            return this;
        }

        @Generated
        public QuestBuilder updated(@NonNull Instant updated) {
            if (updated == null) {
                throw new NullPointerException("updated is marked non-null but is null");
            }
            this.updated = updated;
            return this;
        }

        @Generated
        public QuestBuilder generated(@NonNull Instant generated) {
            if (generated == null) {
                throw new NullPointerException("generated is marked non-null but is null");
            }
            this.generated = generated;
            return this;
        }

        @Generated
        public QuestBuilder duration(@NonNull Duration duration) {
            if (duration == null) {
                throw new NullPointerException("duration is marked non-null but is null");
            }
            this.duration = duration;
            return this;
        }

        @Generated
        public QuestBuilder projectId(@NonNull String projectId) {
            if (projectId == null) {
                throw new NullPointerException("projectId is marked non-null but is null");
            }
            this.projectId = projectId;
            return this;
        }

        @Generated
        public QuestBuilder questKey(@NonNull String questKey) {
            if (questKey == null) {
                throw new NullPointerException("questKey is marked non-null but is null");
            }
            this.questKey = questKey;
            return this;
        }

        @Generated
        public QuestBuilder totalRequired(int totalRequired) {
            this.totalRequired = totalRequired;
            return this;
        }

        @Generated
        public QuestBuilder currentProgress(int currentProgress) {
            this.currentProgress = currentProgress;
            return this;
        }

        @Generated
        public QuestBuilder completed(boolean completed) {
            this.completed = completed;
            return this;
        }

        @Generated
        public QuestBuilder invalid(boolean invalid) {
            this.invalid = invalid;
            return this;
        }

        @Generated
        public QuestBuilder rewards(@NonNull List<QuestReward> rewards) {
            if (rewards == null) {
                throw new NullPointerException("rewards is marked non-null but is null");
            }
            this.rewards = rewards;
            return this;
        }

        @Generated
        public Quest build() {
            return new Quest(this.id, this.playerId, this.accepted, this.updated, this.generated, this.duration, this.projectId, this.questKey, this.totalRequired, this.currentProgress, this.completed, this.invalid, this.rewards);
        }

        @Generated
        public String toString() {
            return "Quest.QuestBuilder(id=" + this.id + ", playerId=" + String.valueOf(this.playerId) + ", accepted=" + String.valueOf(this.accepted) + ", updated=" + String.valueOf(this.updated) + ", generated=" + String.valueOf(this.generated) + ", duration=" + String.valueOf(this.duration) + ", projectId=" + this.projectId + ", questKey=" + this.questKey + ", totalRequired=" + this.totalRequired + ", currentProgress=" + this.currentProgress + ", completed=" + this.completed + ", invalid=" + this.invalid + ", rewards=" + String.valueOf(this.rewards) + ")";
        }
    }
}

