/*
 * Decompiled with CFR 0.152.
 */
package com.mineplex.studio.dataplane.common.report;

import com.mineplex.studio.dataplane.common.CommonGrpcMapper;
import com.mineplex.studio.dataplane.common.CommonMapper;
import com.mineplex.studio.dataplane.common.report.PlayerReportGrpcMapper;
import com.mineplex.studio.dataplane.common.report.model.AssignedPlayerReport;
import com.mineplex.studio.dataplane.common.report.model.CreatePlayerReportRequest;
import com.mineplex.studio.dataplane.common.report.model.PlayerReport;
import com.mineplex.studio.dataplane.common.report.model.PlayerReportAssignment;
import com.mineplex.studio.dataplane.common.report.model.PlayerReportReason;
import com.mineplex.studio.dataplane.common.report.model.PlayerReportResolution;
import com.mineplex.studio.dataplane.common.report.model.PlayerReportTarget;
import com.mineplex.studio.dataplane.common.report.model.type.ChatPlayerReportType;
import com.mineplex.studio.dataplane.contracts.AssignedPlayerReport;
import com.mineplex.studio.dataplane.contracts.ChatPlayerReportType;
import com.mineplex.studio.dataplane.contracts.CreatePlayerReportRequest;
import com.mineplex.studio.dataplane.contracts.PlayerReport;
import com.mineplex.studio.dataplane.contracts.PlayerReportAssignment;
import com.mineplex.studio.dataplane.contracts.PlayerReportReason;
import com.mineplex.studio.dataplane.contracts.PlayerReportResolution;

public class PlayerReportGrpcMapperImpl
implements PlayerReportGrpcMapper {
    private final CommonMapper commonMapper = CommonMapper.INSTANCE;
    private final CommonGrpcMapper commonGrpcMapper = CommonGrpcMapper.INSTANCE;

    @Override
    public CreatePlayerReportRequest grpcCreatePlayerReportRequestToCreatePlayerReportRequest(com.mineplex.studio.dataplane.contracts.CreatePlayerReportRequest grpcCreatePlayerReportRequest) {
        if (grpcCreatePlayerReportRequest == null) {
            return null;
        }
        CreatePlayerReportRequest.CreatePlayerReportRequestBuilder createPlayerReportRequest = CreatePlayerReportRequest.builder();
        createPlayerReportRequest.reportingPlayerId(grpcCreatePlayerReportRequest.getReportingPlayerId());
        if (grpcCreatePlayerReportRequest.hasProjectId()) {
            createPlayerReportRequest.projectId(grpcCreatePlayerReportRequest.getProjectId());
        }
        createPlayerReportRequest.reportedPlayerId(grpcCreatePlayerReportRequest.getReportedPlayerId());
        if (grpcCreatePlayerReportRequest.hasReason()) {
            createPlayerReportRequest.reason(this.grpcPlayerReportReasonToPlayerReportReason(grpcCreatePlayerReportRequest.getReason()));
        }
        if (grpcCreatePlayerReportRequest.hasNotes()) {
            createPlayerReportRequest.notes(grpcCreatePlayerReportRequest.getNotes());
        }
        createPlayerReportRequest.target(this.grpcPlayerReportTargetToPlayerReportTarget(grpcCreatePlayerReportRequest.getTarget()));
        return createPlayerReportRequest.build();
    }

    @Override
    public com.mineplex.studio.dataplane.contracts.CreatePlayerReportRequest createPlayerReportRequestToGrpcCreatePlayerReportRequest(CreatePlayerReportRequest createPlayerReportRequest) {
        if (createPlayerReportRequest == null) {
            return null;
        }
        CreatePlayerReportRequest.Builder createPlayerReportRequest1 = com.mineplex.studio.dataplane.contracts.CreatePlayerReportRequest.newBuilder();
        if (createPlayerReportRequest.hasProjectId()) {
            createPlayerReportRequest1.setProjectId(this.commonMapper.unwrapOptional(createPlayerReportRequest.getProjectId()));
        }
        if (createPlayerReportRequest.hasNotes()) {
            createPlayerReportRequest1.setNotes(this.commonMapper.unwrapOptional(createPlayerReportRequest.getNotes()));
        }
        createPlayerReportRequest1.setReportingPlayerId(createPlayerReportRequest.getReportingPlayerId());
        createPlayerReportRequest1.setReportedPlayerId(createPlayerReportRequest.getReportedPlayerId());
        createPlayerReportRequest1.setReason(this.playerReportReasonToGrpcPlayerReportReason(createPlayerReportRequest.getReason()));
        createPlayerReportRequest1.setTarget(this.playerReportTargetToGrpcPlayerReportTarget(createPlayerReportRequest.getTarget()));
        return createPlayerReportRequest1.build();
    }

    @Override
    public PlayerReportTarget grpcPlayerReportTargetToPlayerReportTarget(com.mineplex.studio.dataplane.contracts.PlayerReportTarget grpcPlayerReportTarget) {
        if (grpcPlayerReportTarget == null) {
            return null;
        }
        return switch (grpcPlayerReportTarget) {
            case com.mineplex.studio.dataplane.contracts.PlayerReportTarget.UNRECOGNIZED -> throw new IllegalArgumentException("Unexpected enum constant: " + String.valueOf(grpcPlayerReportTarget));
            case com.mineplex.studio.dataplane.contracts.PlayerReportTarget.STUDIO -> PlayerReportTarget.STUDIO;
            case com.mineplex.studio.dataplane.contracts.PlayerReportTarget.MINEPLEX -> PlayerReportTarget.MINEPLEX;
            case com.mineplex.studio.dataplane.contracts.PlayerReportTarget.PLAYER_REPORT_TARGET_UNSPECIFIED -> null;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + String.valueOf(grpcPlayerReportTarget));
        };
    }

    @Override
    public com.mineplex.studio.dataplane.contracts.PlayerReportTarget playerReportTargetToGrpcPlayerReportTarget(PlayerReportTarget playerReportTarget) {
        if (playerReportTarget == null) {
            return com.mineplex.studio.dataplane.contracts.PlayerReportTarget.PLAYER_REPORT_TARGET_UNSPECIFIED;
        }
        return switch (playerReportTarget) {
            case PlayerReportTarget.STUDIO -> com.mineplex.studio.dataplane.contracts.PlayerReportTarget.STUDIO;
            case PlayerReportTarget.MINEPLEX -> com.mineplex.studio.dataplane.contracts.PlayerReportTarget.MINEPLEX;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + String.valueOf((Object)playerReportTarget));
        };
    }

    @Override
    public PlayerReport grpcPlayerReportToPlayerReport(com.mineplex.studio.dataplane.contracts.PlayerReport grpcPlayerReport) {
        if (grpcPlayerReport == null) {
            return null;
        }
        PlayerReport.PlayerReportBuilder playerReport = PlayerReport.builder();
        if (grpcPlayerReport.hasReportTime()) {
            playerReport.reportTime(this.commonGrpcMapper.grpcTimestampToInstant(grpcPlayerReport.getReportTime()));
        }
        playerReport.id(grpcPlayerReport.getId());
        playerReport.reportingPlayerId(grpcPlayerReport.getReportingPlayerId());
        playerReport.projectId(grpcPlayerReport.getProjectId());
        playerReport.reportedPlayerId(grpcPlayerReport.getReportedPlayerId());
        if (grpcPlayerReport.hasReason()) {
            playerReport.reason(this.grpcPlayerReportReasonToPlayerReportReason(grpcPlayerReport.getReason()));
        }
        if (grpcPlayerReport.hasNotes()) {
            playerReport.notes(grpcPlayerReport.getNotes());
        }
        playerReport.target(this.grpcPlayerReportTargetToPlayerReportTarget(grpcPlayerReport.getTarget()));
        if (grpcPlayerReport.hasResolution()) {
            playerReport.resolution(this.grpcPlayerReportResolutionToPlayerReportResolution(grpcPlayerReport.getResolution()));
        }
        return playerReport.build();
    }

    @Override
    public PlayerReportAssignment grpcPlayerReportAssignmentToPlayerReportAssignment(com.mineplex.studio.dataplane.contracts.PlayerReportAssignment grpcPlayerReportAssignment) {
        if (grpcPlayerReportAssignment == null) {
            return null;
        }
        PlayerReportAssignment.PlayerReportAssignmentBuilder playerReportAssignment = PlayerReportAssignment.builder();
        if (grpcPlayerReportAssignment.hasAssignedTime()) {
            playerReportAssignment.assignedTime(this.commonGrpcMapper.grpcTimestampToInstant(grpcPlayerReportAssignment.getAssignedTime()));
        }
        playerReportAssignment.id(grpcPlayerReportAssignment.getId());
        playerReportAssignment.reportId(grpcPlayerReportAssignment.getReportId());
        playerReportAssignment.assignedPlayerId(grpcPlayerReportAssignment.getAssignedPlayerId());
        playerReportAssignment.target(this.grpcPlayerReportTargetToPlayerReportTarget(grpcPlayerReportAssignment.getTarget()));
        return playerReportAssignment.build();
    }

    @Override
    public com.mineplex.studio.dataplane.contracts.PlayerReportAssignment playerReportAssignmentToGrpcPlayerReportAssignment(PlayerReportAssignment playerReportAssignment) {
        if (playerReportAssignment == null) {
            return null;
        }
        PlayerReportAssignment.Builder playerReportAssignment1 = com.mineplex.studio.dataplane.contracts.PlayerReportAssignment.newBuilder();
        playerReportAssignment1.setAssignedTime(this.commonGrpcMapper.instantToGrpcTimestamp(playerReportAssignment.getAssignedTime()));
        playerReportAssignment1.setId(playerReportAssignment.getId());
        playerReportAssignment1.setReportId(playerReportAssignment.getReportId());
        playerReportAssignment1.setAssignedPlayerId(playerReportAssignment.getAssignedPlayerId());
        playerReportAssignment1.setTarget(this.playerReportTargetToGrpcPlayerReportTarget(playerReportAssignment.getTarget()));
        return playerReportAssignment1.build();
    }

    @Override
    public PlayerReportReason grpcPlayerReportReasonToPlayerReportReason(com.mineplex.studio.dataplane.contracts.PlayerReportReason grpcPlayerReportReason) {
        if (grpcPlayerReportReason == null) {
            return null;
        }
        PlayerReportReason.PlayerReportReasonBuilder playerReportReason = PlayerReportReason.builder();
        if (grpcPlayerReportReason.hasType()) {
            playerReportReason.type(this.grpcPlayerReportTypeToPlayerReportType(grpcPlayerReportReason.getType()));
        }
        playerReportReason.id(grpcPlayerReportReason.getId());
        playerReportReason.displayName(grpcPlayerReportReason.getDisplayName());
        return playerReportReason.build();
    }

    @Override
    public AssignedPlayerReport grpcAssignedPlayerReportToAssignedPlayerReport(com.mineplex.studio.dataplane.contracts.AssignedPlayerReport grpcAssignedPlayerReport) {
        if (grpcAssignedPlayerReport == null) {
            return null;
        }
        AssignedPlayerReport.AssignedPlayerReportBuilder assignedPlayerReport = AssignedPlayerReport.builder();
        if (grpcAssignedPlayerReport.hasReport()) {
            assignedPlayerReport.report(this.grpcPlayerReportToPlayerReport(grpcAssignedPlayerReport.getReport()));
        }
        if (grpcAssignedPlayerReport.hasAssignment()) {
            assignedPlayerReport.assignment(this.grpcPlayerReportAssignmentToPlayerReportAssignment(grpcAssignedPlayerReport.getAssignment()));
        }
        return assignedPlayerReport.build();
    }

    @Override
    public com.mineplex.studio.dataplane.contracts.AssignedPlayerReport assignedPlayerReportToGrpcAssignedPlayerReport(AssignedPlayerReport assignedPlayerReport) {
        if (assignedPlayerReport == null) {
            return null;
        }
        AssignedPlayerReport.Builder assignedPlayerReport1 = com.mineplex.studio.dataplane.contracts.AssignedPlayerReport.newBuilder();
        assignedPlayerReport1.setReport(this.playerReportToGrpcPlayerReport(assignedPlayerReport.getReport()));
        assignedPlayerReport1.setAssignment(this.playerReportAssignmentToGrpcPlayerReportAssignment(assignedPlayerReport.getAssignment()));
        return assignedPlayerReport1.build();
    }

    @Override
    public ChatPlayerReportType grpcChatPlayerReportTypeToChatPlayerReportType(com.mineplex.studio.dataplane.contracts.ChatPlayerReportType grpcChatPlayerReportType) {
        if (grpcChatPlayerReportType == null) {
            return null;
        }
        ChatPlayerReportType.ChatPlayerReportTypeBuilder chatPlayerReportType = ChatPlayerReportType.builder();
        chatPlayerReportType.chatSnapshotId(grpcChatPlayerReportType.getChatSnapshotId());
        return chatPlayerReportType.build();
    }

    @Override
    public PlayerReportResolution grpcPlayerReportResolutionToPlayerReportResolution(com.mineplex.studio.dataplane.contracts.PlayerReportResolution grpcPlayerReportResolution) {
        if (grpcPlayerReportResolution == null) {
            return null;
        }
        PlayerReportResolution.PlayerReportResolutionBuilder playerReportResolution = PlayerReportResolution.builder();
        if (grpcPlayerReportResolution.hasResolvedTime()) {
            playerReportResolution.resolvedTime(this.commonGrpcMapper.grpcTimestampToInstant(grpcPlayerReportResolution.getResolvedTime()));
        }
        playerReportResolution.resolvedByPlayerId(grpcPlayerReportResolution.getResolvedByPlayerId());
        if (grpcPlayerReportResolution.hasNotes()) {
            playerReportResolution.notes(grpcPlayerReportResolution.getNotes());
        }
        playerReportResolution.approved(grpcPlayerReportResolution.getApproved());
        return playerReportResolution.build();
    }

    @Override
    public com.mineplex.studio.dataplane.contracts.PlayerReport playerReportToGrpcPlayerReport(PlayerReport playerReport) {
        if (playerReport == null) {
            return null;
        }
        PlayerReport.Builder playerReport1 = com.mineplex.studio.dataplane.contracts.PlayerReport.newBuilder();
        if (playerReport.hasResolution()) {
            playerReport1.setResolution(this.playerReportResolutionToGrpcPlayerReportResolution(this.commonMapper.unwrapOptional(playerReport.getResolution())));
        }
        if (playerReport.hasNotes()) {
            playerReport1.setNotes(this.commonMapper.unwrapOptional(playerReport.getNotes()));
        }
        playerReport1.setReportTime(this.commonGrpcMapper.instantToGrpcTimestamp(playerReport.getReportTime()));
        playerReport1.setId(playerReport.getId());
        playerReport1.setReportingPlayerId(playerReport.getReportingPlayerId());
        playerReport1.setProjectId(playerReport.getProjectId());
        playerReport1.setReportedPlayerId(playerReport.getReportedPlayerId());
        playerReport1.setReason(this.playerReportReasonToGrpcPlayerReportReason(playerReport.getReason()));
        playerReport1.setTarget(this.playerReportTargetToGrpcPlayerReportTarget(playerReport.getTarget()));
        return playerReport1.build();
    }

    @Override
    public com.mineplex.studio.dataplane.contracts.PlayerReportReason playerReportReasonToGrpcPlayerReportReason(PlayerReportReason playerReportReason) {
        if (playerReportReason == null) {
            return null;
        }
        PlayerReportReason.Builder playerReportReason1 = com.mineplex.studio.dataplane.contracts.PlayerReportReason.newBuilder();
        playerReportReason1.setType(this.playerReportTypeToGrpcPlayerReportType(playerReportReason.getType()));
        playerReportReason1.setId(playerReportReason.getId());
        playerReportReason1.setDisplayName(playerReportReason.getDisplayName());
        return playerReportReason1.build();
    }

    @Override
    public com.mineplex.studio.dataplane.contracts.PlayerReportResolution playerReportResolutionToGrpcPlayerReportResolution(PlayerReportResolution playerReportResolution) {
        if (playerReportResolution == null) {
            return null;
        }
        PlayerReportResolution.Builder playerReportResolution1 = com.mineplex.studio.dataplane.contracts.PlayerReportResolution.newBuilder();
        playerReportResolution1.setResolvedTime(this.commonGrpcMapper.instantToGrpcTimestamp(playerReportResolution.getResolvedTime()));
        if (playerReportResolution.hasNotes()) {
            playerReportResolution1.setNotes(this.commonMapper.unwrapOptional(playerReportResolution.getNotes()));
        }
        playerReportResolution1.setResolvedByPlayerId(playerReportResolution.getResolvedByPlayerId());
        playerReportResolution1.setApproved(playerReportResolution.isApproved());
        return playerReportResolution1.build();
    }

    @Override
    public com.mineplex.studio.dataplane.contracts.ChatPlayerReportType chatPlayerReportTypeToGrpcChatPlayerReportType(ChatPlayerReportType chatPlayerReportType) {
        if (chatPlayerReportType == null) {
            return null;
        }
        ChatPlayerReportType.Builder chatPlayerReportType1 = com.mineplex.studio.dataplane.contracts.ChatPlayerReportType.newBuilder();
        chatPlayerReportType1.setChatSnapshotId(chatPlayerReportType.getChatSnapshotId());
        return chatPlayerReportType1.build();
    }
}

