/*
 * Decompiled with CFR 0.152.
 */
package com.mineplex.studio.dataplane.common.report.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.mineplex.studio.dataplane.common.report.model.PlayerReportReason;
import com.mineplex.studio.dataplane.common.report.model.PlayerReportResolution;
import com.mineplex.studio.dataplane.common.report.model.PlayerReportTarget;
import java.time.Instant;
import java.util.Optional;
import javax.annotation.Nullable;
import lombok.Generated;
import lombok.NonNull;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=PlayerReportBuilder.class)
public final class PlayerReport {
    @NonNull
    private final String id;
    @NonNull
    private final String reportingPlayerId;
    @NonNull
    private final String projectId;
    @NonNull
    private final Instant reportTime;
    @NonNull
    private final String reportedPlayerId;
    @NonNull
    private final PlayerReportReason reason;
    @Nullable
    private final String notes;
    @NonNull
    private final PlayerReportTarget target;
    @Nullable
    private final PlayerReportResolution resolution;

    public boolean hasNotes() {
        return this.notes != null;
    }

    public Optional<String> getNotes() {
        return Optional.ofNullable(this.notes);
    }

    public boolean hasResolution() {
        return this.resolution != null;
    }

    public Optional<PlayerReportResolution> getResolution() {
        return Optional.ofNullable(this.resolution);
    }

    @Generated
    PlayerReport(@NonNull String id, @NonNull String reportingPlayerId, @NonNull String projectId, @NonNull Instant reportTime, @NonNull String reportedPlayerId, @NonNull PlayerReportReason reason, @Nullable String notes, @NonNull PlayerReportTarget target, @Nullable PlayerReportResolution resolution) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (reportingPlayerId == null) {
            throw new NullPointerException("reportingPlayerId is marked non-null but is null");
        }
        if (projectId == null) {
            throw new NullPointerException("projectId is marked non-null but is null");
        }
        if (reportTime == null) {
            throw new NullPointerException("reportTime is marked non-null but is null");
        }
        if (reportedPlayerId == null) {
            throw new NullPointerException("reportedPlayerId is marked non-null but is null");
        }
        if (reason == null) {
            throw new NullPointerException("reason is marked non-null but is null");
        }
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        this.id = id;
        this.reportingPlayerId = reportingPlayerId;
        this.projectId = projectId;
        this.reportTime = reportTime;
        this.reportedPlayerId = reportedPlayerId;
        this.reason = reason;
        this.notes = notes;
        this.target = target;
        this.resolution = resolution;
    }

    @Generated
    public static PlayerReportBuilder builder() {
        return new PlayerReportBuilder();
    }

    @Generated
    public PlayerReportBuilder toBuilder() {
        return new PlayerReportBuilder().id(this.id).reportingPlayerId(this.reportingPlayerId).projectId(this.projectId).reportTime(this.reportTime).reportedPlayerId(this.reportedPlayerId).reason(this.reason).notes(this.notes).target(this.target).resolution(this.resolution);
    }

    @NonNull
    @Generated
    public String getId() {
        return this.id;
    }

    @NonNull
    @Generated
    public String getReportingPlayerId() {
        return this.reportingPlayerId;
    }

    @NonNull
    @Generated
    public String getProjectId() {
        return this.projectId;
    }

    @NonNull
    @Generated
    public Instant getReportTime() {
        return this.reportTime;
    }

    @NonNull
    @Generated
    public String getReportedPlayerId() {
        return this.reportedPlayerId;
    }

    @NonNull
    @Generated
    public PlayerReportReason getReason() {
        return this.reason;
    }

    @NonNull
    @Generated
    public PlayerReportTarget getTarget() {
        return this.target;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PlayerReport)) {
            return false;
        }
        PlayerReport other = (PlayerReport)o;
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$reportingPlayerId = this.getReportingPlayerId();
        String other$reportingPlayerId = other.getReportingPlayerId();
        if (this$reportingPlayerId == null ? other$reportingPlayerId != null : !this$reportingPlayerId.equals(other$reportingPlayerId)) {
            return false;
        }
        String this$projectId = this.getProjectId();
        String other$projectId = other.getProjectId();
        if (this$projectId == null ? other$projectId != null : !this$projectId.equals(other$projectId)) {
            return false;
        }
        Instant this$reportTime = this.getReportTime();
        Instant other$reportTime = other.getReportTime();
        if (this$reportTime == null ? other$reportTime != null : !((Object)this$reportTime).equals(other$reportTime)) {
            return false;
        }
        String this$reportedPlayerId = this.getReportedPlayerId();
        String other$reportedPlayerId = other.getReportedPlayerId();
        if (this$reportedPlayerId == null ? other$reportedPlayerId != null : !this$reportedPlayerId.equals(other$reportedPlayerId)) {
            return false;
        }
        PlayerReportReason this$reason = this.getReason();
        PlayerReportReason other$reason = other.getReason();
        if (this$reason == null ? other$reason != null : !((Object)this$reason).equals(other$reason)) {
            return false;
        }
        Optional<String> this$notes = this.getNotes();
        Optional<String> other$notes = other.getNotes();
        if (this$notes == null ? other$notes != null : !((Object)this$notes).equals(other$notes)) {
            return false;
        }
        PlayerReportTarget this$target = this.getTarget();
        PlayerReportTarget other$target = other.getTarget();
        if (this$target == null ? other$target != null : !((Object)((Object)this$target)).equals((Object)other$target)) {
            return false;
        }
        Optional<PlayerReportResolution> this$resolution = this.getResolution();
        Optional<PlayerReportResolution> other$resolution = other.getResolution();
        return !(this$resolution == null ? other$resolution != null : !((Object)this$resolution).equals(other$resolution));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $reportingPlayerId = this.getReportingPlayerId();
        result = result * 59 + ($reportingPlayerId == null ? 43 : $reportingPlayerId.hashCode());
        String $projectId = this.getProjectId();
        result = result * 59 + ($projectId == null ? 43 : $projectId.hashCode());
        Instant $reportTime = this.getReportTime();
        result = result * 59 + ($reportTime == null ? 43 : ((Object)$reportTime).hashCode());
        String $reportedPlayerId = this.getReportedPlayerId();
        result = result * 59 + ($reportedPlayerId == null ? 43 : $reportedPlayerId.hashCode());
        PlayerReportReason $reason = this.getReason();
        result = result * 59 + ($reason == null ? 43 : ((Object)$reason).hashCode());
        Optional<String> $notes = this.getNotes();
        result = result * 59 + ($notes == null ? 43 : ((Object)$notes).hashCode());
        PlayerReportTarget $target = this.getTarget();
        result = result * 59 + ($target == null ? 43 : ((Object)((Object)$target)).hashCode());
        Optional<PlayerReportResolution> $resolution = this.getResolution();
        result = result * 59 + ($resolution == null ? 43 : ((Object)$resolution).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PlayerReport(id=" + this.getId() + ", reportingPlayerId=" + this.getReportingPlayerId() + ", projectId=" + this.getProjectId() + ", reportTime=" + String.valueOf(this.getReportTime()) + ", reportedPlayerId=" + this.getReportedPlayerId() + ", reason=" + String.valueOf(this.getReason()) + ", notes=" + String.valueOf(this.getNotes()) + ", target=" + String.valueOf((Object)this.getTarget()) + ", resolution=" + String.valueOf(this.getResolution()) + ")";
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    public static class PlayerReportBuilder {
        @Generated
        private String id;
        @Generated
        private String reportingPlayerId;
        @Generated
        private String projectId;
        @Generated
        private Instant reportTime;
        @Generated
        private String reportedPlayerId;
        @Generated
        private PlayerReportReason reason;
        @Generated
        private String notes;
        @Generated
        private PlayerReportTarget target;
        @Generated
        private PlayerReportResolution resolution;

        @Generated
        PlayerReportBuilder() {
        }

        @Generated
        public PlayerReportBuilder id(@NonNull String id) {
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            this.id = id;
            return this;
        }

        @Generated
        public PlayerReportBuilder reportingPlayerId(@NonNull String reportingPlayerId) {
            if (reportingPlayerId == null) {
                throw new NullPointerException("reportingPlayerId is marked non-null but is null");
            }
            this.reportingPlayerId = reportingPlayerId;
            return this;
        }

        @Generated
        public PlayerReportBuilder projectId(@NonNull String projectId) {
            if (projectId == null) {
                throw new NullPointerException("projectId is marked non-null but is null");
            }
            this.projectId = projectId;
            return this;
        }

        @Generated
        public PlayerReportBuilder reportTime(@NonNull Instant reportTime) {
            if (reportTime == null) {
                throw new NullPointerException("reportTime is marked non-null but is null");
            }
            this.reportTime = reportTime;
            return this;
        }

        @Generated
        public PlayerReportBuilder reportedPlayerId(@NonNull String reportedPlayerId) {
            if (reportedPlayerId == null) {
                throw new NullPointerException("reportedPlayerId is marked non-null but is null");
            }
            this.reportedPlayerId = reportedPlayerId;
            return this;
        }

        @Generated
        public PlayerReportBuilder reason(@NonNull PlayerReportReason reason) {
            if (reason == null) {
                throw new NullPointerException("reason is marked non-null but is null");
            }
            this.reason = reason;
            return this;
        }

        @Generated
        public PlayerReportBuilder notes(@Nullable String notes) {
            this.notes = notes;
            return this;
        }

        @Generated
        public PlayerReportBuilder target(@NonNull PlayerReportTarget target) {
            if (target == null) {
                throw new NullPointerException("target is marked non-null but is null");
            }
            this.target = target;
            return this;
        }

        @Generated
        public PlayerReportBuilder resolution(@Nullable PlayerReportResolution resolution) {
            this.resolution = resolution;
            return this;
        }

        @Generated
        public PlayerReport build() {
            return new PlayerReport(this.id, this.reportingPlayerId, this.projectId, this.reportTime, this.reportedPlayerId, this.reason, this.notes, this.target, this.resolution);
        }

        @Generated
        public String toString() {
            return "PlayerReport.PlayerReportBuilder(id=" + this.id + ", reportingPlayerId=" + this.reportingPlayerId + ", projectId=" + this.projectId + ", reportTime=" + String.valueOf(this.reportTime) + ", reportedPlayerId=" + this.reportedPlayerId + ", reason=" + String.valueOf(this.reason) + ", notes=" + this.notes + ", target=" + String.valueOf((Object)this.target) + ", resolution=" + String.valueOf(this.resolution) + ")";
        }
    }
}

