/*
 * Decompiled with CFR 0.152.
 */
package com.mineplex.studio.dataplane.common.report.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.time.Instant;
import java.util.Optional;
import javax.annotation.Nullable;
import lombok.Generated;
import lombok.NonNull;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=PlayerReportResolutionBuilder.class)
public final class PlayerReportResolution {
    @NonNull
    private final String resolvedByPlayerId;
    @NonNull
    private final Instant resolvedTime;
    @Nullable
    private final String notes;
    private final boolean approved;

    public boolean hasNotes() {
        return this.notes != null;
    }

    public Optional<String> getNotes() {
        return Optional.ofNullable(this.notes);
    }

    @Generated
    PlayerReportResolution(@NonNull String resolvedByPlayerId, @NonNull Instant resolvedTime, @Nullable String notes, boolean approved) {
        if (resolvedByPlayerId == null) {
            throw new NullPointerException("resolvedByPlayerId is marked non-null but is null");
        }
        if (resolvedTime == null) {
            throw new NullPointerException("resolvedTime is marked non-null but is null");
        }
        this.resolvedByPlayerId = resolvedByPlayerId;
        this.resolvedTime = resolvedTime;
        this.notes = notes;
        this.approved = approved;
    }

    @Generated
    public static PlayerReportResolutionBuilder builder() {
        return new PlayerReportResolutionBuilder();
    }

    @Generated
    public PlayerReportResolutionBuilder toBuilder() {
        return new PlayerReportResolutionBuilder().resolvedByPlayerId(this.resolvedByPlayerId).resolvedTime(this.resolvedTime).notes(this.notes).approved(this.approved);
    }

    @NonNull
    @Generated
    public String getResolvedByPlayerId() {
        return this.resolvedByPlayerId;
    }

    @NonNull
    @Generated
    public Instant getResolvedTime() {
        return this.resolvedTime;
    }

    @Generated
    public boolean isApproved() {
        return this.approved;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PlayerReportResolution)) {
            return false;
        }
        PlayerReportResolution other = (PlayerReportResolution)o;
        if (this.isApproved() != other.isApproved()) {
            return false;
        }
        String this$resolvedByPlayerId = this.getResolvedByPlayerId();
        String other$resolvedByPlayerId = other.getResolvedByPlayerId();
        if (this$resolvedByPlayerId == null ? other$resolvedByPlayerId != null : !this$resolvedByPlayerId.equals(other$resolvedByPlayerId)) {
            return false;
        }
        Instant this$resolvedTime = this.getResolvedTime();
        Instant other$resolvedTime = other.getResolvedTime();
        if (this$resolvedTime == null ? other$resolvedTime != null : !((Object)this$resolvedTime).equals(other$resolvedTime)) {
            return false;
        }
        Optional<String> this$notes = this.getNotes();
        Optional<String> other$notes = other.getNotes();
        return !(this$notes == null ? other$notes != null : !((Object)this$notes).equals(other$notes));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isApproved() ? 79 : 97);
        String $resolvedByPlayerId = this.getResolvedByPlayerId();
        result = result * 59 + ($resolvedByPlayerId == null ? 43 : $resolvedByPlayerId.hashCode());
        Instant $resolvedTime = this.getResolvedTime();
        result = result * 59 + ($resolvedTime == null ? 43 : ((Object)$resolvedTime).hashCode());
        Optional<String> $notes = this.getNotes();
        result = result * 59 + ($notes == null ? 43 : ((Object)$notes).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PlayerReportResolution(resolvedByPlayerId=" + this.getResolvedByPlayerId() + ", resolvedTime=" + String.valueOf(this.getResolvedTime()) + ", notes=" + String.valueOf(this.getNotes()) + ", approved=" + this.isApproved() + ")";
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    public static class PlayerReportResolutionBuilder {
        @Generated
        private String resolvedByPlayerId;
        @Generated
        private Instant resolvedTime;
        @Generated
        private String notes;
        @Generated
        private boolean approved;

        @Generated
        PlayerReportResolutionBuilder() {
        }

        @Generated
        public PlayerReportResolutionBuilder resolvedByPlayerId(@NonNull String resolvedByPlayerId) {
            if (resolvedByPlayerId == null) {
                throw new NullPointerException("resolvedByPlayerId is marked non-null but is null");
            }
            this.resolvedByPlayerId = resolvedByPlayerId;
            return this;
        }

        @Generated
        public PlayerReportResolutionBuilder resolvedTime(@NonNull Instant resolvedTime) {
            if (resolvedTime == null) {
                throw new NullPointerException("resolvedTime is marked non-null but is null");
            }
            this.resolvedTime = resolvedTime;
            return this;
        }

        @Generated
        public PlayerReportResolutionBuilder notes(@Nullable String notes) {
            this.notes = notes;
            return this;
        }

        @Generated
        public PlayerReportResolutionBuilder approved(boolean approved) {
            this.approved = approved;
            return this;
        }

        @Generated
        public PlayerReportResolution build() {
            return new PlayerReportResolution(this.resolvedByPlayerId, this.resolvedTime, this.notes, this.approved);
        }

        @Generated
        public String toString() {
            return "PlayerReportResolution.PlayerReportResolutionBuilder(resolvedByPlayerId=" + this.resolvedByPlayerId + ", resolvedTime=" + String.valueOf(this.resolvedTime) + ", notes=" + this.notes + ", approved=" + this.approved + ")";
        }
    }
}

