/*
 * Decompiled with CFR 0.152.
 */
package com.mineplex.studio.deps.com.hubspot.jackson.datatype.protobuf;

import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.google.common.base.CaseFormat;
import com.mineplex.studio.deps.com.google.protobuf.Message;

public class PropertyNamingStrategyWrapper {
    private static final PropertyNamingStrategies.NamingBase SNAKE_TO_CAMEL = new SnakeToCamelNamingStrategy();
    private final PropertyNamingStrategies.NamingBase delegate;

    public PropertyNamingStrategyWrapper(Class<? extends Message> messageType, MapperConfig<?> mapperConfig) {
        this.delegate = mapperConfig.getPropertyNamingStrategy() instanceof PropertyNamingStrategies.NamingBase ? (PropertyNamingStrategies.NamingBase)mapperConfig.getPropertyNamingStrategy() : SNAKE_TO_CAMEL;
    }

    public String translate(String fieldName) {
        return this.delegate.translate(fieldName);
    }

    private static class SnakeToCamelNamingStrategy
    extends PropertyNamingStrategies.NamingBase {
        private SnakeToCamelNamingStrategy() {
        }

        public String translate(String fieldName) {
            return CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, fieldName);
        }
    }
}

