/*
 * Decompiled with CFR 0.152.
 */
package com.mineplex.studio.deps.com.hubspot.jackson.datatype.protobuf;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.mineplex.studio.deps.com.google.protobuf.ByteString;
import com.mineplex.studio.deps.com.google.protobuf.Descriptors;
import com.mineplex.studio.deps.com.google.protobuf.Message;
import com.mineplex.studio.deps.com.google.protobuf.MessageOrBuilder;
import com.mineplex.studio.deps.com.google.protobuf.NullValue;
import com.mineplex.studio.deps.com.hubspot.jackson.datatype.protobuf.ProtobufJacksonConfig;
import com.mineplex.studio.deps.com.hubspot.jackson.datatype.protobuf.internal.Types;
import java.io.IOException;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class ProtobufSerializer<T extends MessageOrBuilder>
extends StdSerializer<T> {
    private static final String NULL_VALUE_FULL_NAME = NullValue.getDescriptor().getFullName();
    private final ProtobufJacksonConfig config;
    private final Map<Class<?>, JsonSerializer<Object>> serializerCache;

    @Deprecated
    public ProtobufSerializer(Class<T> protobufType) {
        this(protobufType, ProtobufJacksonConfig.getDefaultInstance());
    }

    public ProtobufSerializer(Class<T> protobufType, ProtobufJacksonConfig config) {
        super(protobufType);
        this.config = config;
        this.serializerCache = new ConcurrentHashMap();
    }

    public abstract void acceptJsonFormatVisitor(JsonFormatVisitorWrapper var1, JavaType var2) throws JsonMappingException;

    protected void writeMap(Descriptors.FieldDescriptor field, Object entries, JsonGenerator generator, SerializerProvider serializerProvider) throws IOException {
        Descriptors.Descriptor entryDescriptor = field.getMessageType();
        Descriptors.FieldDescriptor keyDescriptor = entryDescriptor.findFieldByName("key");
        Descriptors.FieldDescriptor valueDescriptor = entryDescriptor.findFieldByName("value");
        generator.writeStartObject();
        for (Message entry : (List)entries) {
            generator.writeFieldName(entry.getField(keyDescriptor).toString());
            Object value = entry.getField(valueDescriptor);
            this.writeValue(valueDescriptor, value, generator, serializerProvider);
        }
        generator.writeEndObject();
    }

    protected ProtobufJacksonConfig getConfig() {
        return this.config;
    }

    protected void writeValue(Descriptors.FieldDescriptor field, Object value, JsonGenerator generator, SerializerProvider serializerProvider) throws IOException {
        switch (field.getJavaType()) {
            case INT: {
                this.writeInt(field, (Integer)value, generator);
                break;
            }
            case LONG: {
                this.writeLong(field, (Long)value, generator);
                break;
            }
            case FLOAT: {
                generator.writeNumber(((Float)value).floatValue());
                break;
            }
            case DOUBLE: {
                generator.writeNumber(((Double)value).doubleValue());
                break;
            }
            case BOOLEAN: {
                generator.writeBoolean(((Boolean)value).booleanValue());
                break;
            }
            case STRING: {
                generator.writeString((String)value);
                break;
            }
            case ENUM: {
                Descriptors.EnumValueDescriptor enumDescriptor = (Descriptors.EnumValueDescriptor)value;
                if (NULL_VALUE_FULL_NAME.equals(enumDescriptor.getType().getFullName())) {
                    generator.writeNull();
                    break;
                }
                if (ProtobufSerializer.writeEnumsUsingIndex(serializerProvider)) {
                    generator.writeNumber(enumDescriptor.getNumber());
                    break;
                }
                generator.writeString(enumDescriptor.getName());
                break;
            }
            case BYTE_STRING: {
                generator.writeString(serializerProvider.getConfig().getBase64Variant().encode(((ByteString)value).toByteArray()));
                break;
            }
            case MESSAGE: {
                Class<?> subType = value.getClass();
                JsonSerializer serializer = this.serializerCache.get(subType);
                if (serializer == null) {
                    serializer = serializerProvider.findValueSerializer(value.getClass(), null);
                    this.serializerCache.put(subType, (JsonSerializer<Object>)serializer);
                }
                serializer.serialize(value, generator, serializerProvider);
                break;
            }
            default: {
                throw ProtobufSerializer.unrecognizedType(field, generator);
            }
        }
    }

    private void writeInt(Descriptors.FieldDescriptor field, int value, JsonGenerator generator) throws IOException {
        if (value < 0 && this.config.properUnsignedNumberSerialization() && Types.isUnsigned(field.getType())) {
            long unsignedValue = (long)value & 0xFFFFFFFFL;
            generator.writeNumber(unsignedValue);
        } else {
            generator.writeNumber(value);
        }
    }

    private void writeLong(Descriptors.FieldDescriptor field, long value, JsonGenerator generator) throws IOException {
        if (value < 0L && this.config.properUnsignedNumberSerialization() && Types.isUnsigned(field.getType())) {
            BigInteger unsignedValue = BigInteger.valueOf(value & Long.MAX_VALUE).setBit(63);
            if (this.config.serializeLongsAsString()) {
                generator.writeString(unsignedValue.toString());
            } else {
                generator.writeNumber(unsignedValue);
            }
        } else if (this.config.serializeLongsAsString()) {
            generator.writeString(Long.toString(value));
        } else {
            generator.writeNumber(value);
        }
    }

    private static boolean writeEnumsUsingIndex(SerializerProvider config) {
        return config.isEnabled(SerializationFeature.WRITE_ENUMS_USING_INDEX);
    }

    private static IOException unrecognizedType(Descriptors.FieldDescriptor field, JsonGenerator generator) throws IOException {
        String error = String.format("Unrecognized java type '%s' for field %s", new Object[]{field.getJavaType(), field.getFullName()});
        throw new JsonGenerationException(error, generator);
    }
}

