/*
 * Decompiled with CFR 0.152.
 */
package com.mineplex.studio.deps.com.hubspot.jackson.datatype.protobuf.builtin.deserializers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.mineplex.studio.deps.com.google.protobuf.Descriptors;
import com.mineplex.studio.deps.com.google.protobuf.NullValue;
import com.mineplex.studio.deps.com.google.protobuf.Value;
import com.mineplex.studio.deps.com.hubspot.jackson.datatype.protobuf.ProtobufDeserializer;
import java.io.IOException;

public class ValueDeserializer
extends ProtobufDeserializer<Value, Value.Builder> {
    private static final Descriptors.FieldDescriptor STRUCT_FIELD = Value.getDescriptor().findFieldByName("struct_value");
    private static final Descriptors.FieldDescriptor LIST_FIELD = Value.getDescriptor().findFieldByName("list_value");

    public ValueDeserializer() {
        super(Value.class);
    }

    @Override
    protected void populate(Value.Builder builder, JsonParser parser, DeserializationContext context) throws IOException {
        switch (parser.getCurrentToken()) {
            case START_OBJECT: {
                Object structValue = this.readValue(builder, STRUCT_FIELD, null, parser, context);
                builder.setField(STRUCT_FIELD, structValue);
                return;
            }
            case START_ARRAY: {
                Object listValue = this.readValue(builder, LIST_FIELD, null, parser, context);
                builder.setField(LIST_FIELD, listValue);
                return;
            }
            case VALUE_STRING: {
                builder.setStringValue(parser.getText());
                return;
            }
            case VALUE_NUMBER_INT: 
            case VALUE_NUMBER_FLOAT: {
                builder.setNumberValue(parser.getValueAsDouble());
                return;
            }
            case VALUE_TRUE: {
                builder.setBoolValue(true);
                return;
            }
            case VALUE_FALSE: {
                builder.setBoolValue(false);
                return;
            }
            case VALUE_NULL: {
                builder.setNullValue(NullValue.NULL_VALUE);
                return;
            }
        }
        String message = "Can not deserialize instance of com.google.protobuf.Value out of " + parser.currentToken() + " token";
        context.reportInputMismatch(Value.class, message, new Object[0]);
        throw new AssertionError();
    }

    public Value.Builder getNullValue(DeserializationContext ctxt) {
        return Value.newBuilder().setNullValue(NullValue.NULL_VALUE);
    }
}

