/*
 * Decompiled with CFR 0.152.
 */
package com.mineplex.studio.deps.com.hubspot.jackson.datatype.protobuf.internal;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitable;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.mineplex.studio.deps.com.google.protobuf.Descriptors;
import com.mineplex.studio.deps.com.google.protobuf.NullValue;
import com.mineplex.studio.deps.com.hubspot.jackson.datatype.protobuf.ProtobufJacksonConfig;
import com.mineplex.studio.deps.com.hubspot.jackson.datatype.protobuf.internal.Types;
import java.math.BigInteger;

public class FieldSchemaGenerator
extends StdSerializer<String>
implements JsonFormatVisitable {
    private final Descriptors.FieldDescriptor field;
    private final ProtobufJacksonConfig config;

    public FieldSchemaGenerator(Descriptors.FieldDescriptor field, ProtobufJacksonConfig config) {
        super(String.class);
        this.field = field;
        this.config = config;
    }

    public void serialize(String value, JsonGenerator gen, SerializerProvider provider) {
        throw new UnsupportedOperationException();
    }

    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        switch (this.field.getJavaType()) {
            case INT: {
                if (Types.isUnsigned(this.field.getType()) && this.config.properUnsignedNumberSerialization()) {
                    this.visitIntFormat(visitor, visitor.getProvider().constructType(Long.class), JsonParser.NumberType.LONG);
                    break;
                }
                this.visitIntFormat(visitor, typeHint, JsonParser.NumberType.INT);
                break;
            }
            case LONG: {
                if (this.config.serializeLongsAsString()) {
                    visitor.expectStringFormat(visitor.getProvider().constructType(String.class));
                    break;
                }
                if (Types.isUnsigned(this.field.getType()) && this.config.properUnsignedNumberSerialization()) {
                    this.visitIntFormat(visitor, visitor.getProvider().constructType(BigInteger.class), JsonParser.NumberType.BIG_INTEGER);
                    break;
                }
                this.visitIntFormat(visitor, typeHint, JsonParser.NumberType.LONG);
                break;
            }
            case FLOAT: {
                this.visitFloatFormat(visitor, typeHint, JsonParser.NumberType.FLOAT);
                break;
            }
            case DOUBLE: {
                this.visitFloatFormat(visitor, typeHint, JsonParser.NumberType.DOUBLE);
                break;
            }
            case BOOLEAN: {
                visitor.expectBooleanFormat(typeHint);
                break;
            }
            case STRING: 
            case BYTE_STRING: {
                visitor.expectStringFormat(typeHint);
                break;
            }
            case ENUM: {
                if (typeHint.getRawClass() == NullValue.class) {
                    visitor.expectNullFormat(typeHint);
                    break;
                }
                if (visitor.getProvider().isEnabled(SerializationFeature.WRITE_ENUMS_USING_INDEX)) {
                    visitor.expectIntegerFormat(typeHint);
                    break;
                }
                visitor.expectStringFormat(typeHint);
                break;
            }
            case MESSAGE: {
                JsonSerializer serializer = visitor.getProvider().findValueSerializer(typeHint.getRawClass(), null);
                serializer.acceptJsonFormatVisitor(visitor, typeHint);
            }
        }
    }
}

