/*
 * Decompiled with CFR 0.152.
 */
package com.mineplex.studio.deps.com.hubspot.jackson.datatype.protobuf.internal;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitable;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonMapFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonObjectFormatVisitor;
import com.fasterxml.jackson.databind.type.ArrayType;
import com.google.common.base.CaseFormat;
import com.mineplex.studio.deps.com.google.protobuf.Descriptors;
import com.mineplex.studio.deps.com.google.protobuf.ExtensionRegistry;
import com.mineplex.studio.deps.com.google.protobuf.Message;
import com.mineplex.studio.deps.com.google.protobuf.MessageLite;
import com.mineplex.studio.deps.com.hubspot.jackson.datatype.protobuf.ProtobufJacksonConfig;
import com.mineplex.studio.deps.com.hubspot.jackson.datatype.protobuf.internal.FieldSchemaGenerator;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.function.Function;

public class MessageSchemaGenerator
implements JsonFormatVisitable {
    private final Message defaultInstance;
    private final ProtobufJacksonConfig config;
    private final Function<Descriptors.FieldDescriptor, String> propertyNaming;

    public MessageSchemaGenerator(Message defaultInstance, ProtobufJacksonConfig config, Function<Descriptors.FieldDescriptor, String> propertyNaming) {
        this.defaultInstance = defaultInstance;
        this.config = config;
        this.propertyNaming = propertyNaming;
    }

    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        JsonObjectFormatVisitor objectVisitor = visitor.expectObjectFormat(typeHint);
        Descriptors.Descriptor descriptor = this.defaultInstance.getDescriptorForType();
        ArrayList<Descriptors.FieldDescriptor> fields = new ArrayList<Descriptors.FieldDescriptor>(descriptor.getFields());
        if (descriptor.isExtendable()) {
            for (ExtensionRegistry.ExtensionInfo extensionInfo : this.config.extensionRegistry().getExtensionsByDescriptor(descriptor)) {
                fields.add(extensionInfo.descriptor);
            }
        }
        for (Descriptors.FieldDescriptor field : fields) {
            String fieldName = this.propertyNaming.apply(field);
            JavaType fieldType = visitor.getProvider().constructType(this.fieldClass(this.defaultInstance, field));
            FieldSchemaGenerator fieldVisitable = new FieldSchemaGenerator(field, this.config);
            if (field.isMapField()) {
                JavaType mapType;
                MessageLite defaultMapEntry = this.defaultInstance.toBuilder().newBuilderForField(field).getDefaultInstanceForType();
                Descriptors.Descriptor entryDescriptor = defaultMapEntry.getDescriptorForType();
                Descriptors.FieldDescriptor keyDescriptor = entryDescriptor.findFieldByName("key");
                Descriptors.FieldDescriptor valueDescriptor = entryDescriptor.findFieldByName("value");
                try {
                    mapType = visitor.getProvider().constructType(this.defaultInstance.getClass().getMethod(MessageSchemaGenerator.getterName(field), new Class[0]).getGenericReturnType());
                }
                catch (ReflectiveOperationException e) {
                    throw new RuntimeException(e);
                }
                objectVisitor.optionalProperty(fieldName, (fieldVisitor, ignored) -> {
                    JsonMapFormatVisitor mapVisitor = fieldVisitor.expectMapFormat(mapType);
                    if (mapVisitor != null) {
                        mapVisitor.keyFormat((JsonFormatVisitable)new FieldSchemaGenerator(keyDescriptor, this.config), mapType.getKeyType());
                        mapVisitor.valueFormat((JsonFormatVisitable)new FieldSchemaGenerator(valueDescriptor, this.config), mapType.getContentType());
                    }
                }, mapType);
                continue;
            }
            if (field.isRepeated()) {
                ArrayType listType = visitor.getProvider().getTypeFactory().constructArrayType(fieldType);
                objectVisitor.optionalProperty(fieldName, (fieldVisitor, ignored) -> {
                    JsonArrayFormatVisitor arrayVisitor = fieldVisitor.expectArrayFormat((JavaType)listType);
                    if (arrayVisitor != null) {
                        arrayVisitor.itemsFormat(fieldVisitable, fieldType);
                    }
                }, (JavaType)listType);
                continue;
            }
            objectVisitor.optionalProperty(fieldName, (JsonFormatVisitable)fieldVisitable, fieldType);
        }
    }

    private Class<?> fieldClass(Message defaultInstance, Descriptors.FieldDescriptor field) {
        switch (field.getJavaType()) {
            case INT: {
                return Integer.class;
            }
            case LONG: {
                return Long.class;
            }
            case FLOAT: {
                return Float.class;
            }
            case DOUBLE: {
                return Double.class;
            }
            case BOOLEAN: {
                return Boolean.class;
            }
            case STRING: 
            case BYTE_STRING: {
                return String.class;
            }
            case ENUM: {
                try {
                    Method getterMethod = field.isRepeated() ? defaultInstance.getClass().getMethod(MessageSchemaGenerator.getterName(field), Integer.TYPE) : defaultInstance.getClass().getMethod(MessageSchemaGenerator.getterName(field), new Class[0]);
                    return getterMethod.getReturnType();
                }
                catch (ReflectiveOperationException e) {
                    throw new RuntimeException(e);
                }
            }
            case MESSAGE: {
                Message.Builder subBuilder = defaultInstance.toBuilder().newBuilderForField(field);
                return subBuilder.getDefaultInstanceForType().getClass();
            }
        }
        throw new IllegalArgumentException("Unknown field type: " + (Object)((Object)field.getJavaType()));
    }

    private static String getterName(Descriptors.FieldDescriptor field) {
        return "get" + CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, field.getName());
    }
}

