/*
 * Decompiled with CFR 0.152.
 */
package com.mineplex.studio.deps.io.grpc.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.mineplex.studio.deps.io.grpc.CallOptions;
import com.mineplex.studio.deps.io.grpc.ClientStreamTracer;
import com.mineplex.studio.deps.io.grpc.InternalChannelz;
import com.mineplex.studio.deps.io.grpc.InternalLogId;
import com.mineplex.studio.deps.io.grpc.Metadata;
import com.mineplex.studio.deps.io.grpc.MethodDescriptor;
import com.mineplex.studio.deps.io.grpc.Status;
import com.mineplex.studio.deps.io.grpc.internal.ClientStream;
import com.mineplex.studio.deps.io.grpc.internal.ClientStreamListener;
import com.mineplex.studio.deps.io.grpc.internal.ClientTransport;
import com.mineplex.studio.deps.io.grpc.internal.FailingClientStream;
import java.util.concurrent.Executor;

class FailingClientTransport
implements ClientTransport {
    @VisibleForTesting
    final Status error;
    private final ClientStreamListener.RpcProgress rpcProgress;

    FailingClientTransport(Status error, ClientStreamListener.RpcProgress rpcProgress) {
        Preconditions.checkArgument((!error.isOk() ? 1 : 0) != 0, (Object)"error must not be OK");
        this.error = error;
        this.rpcProgress = rpcProgress;
    }

    @Override
    public ClientStream newStream(MethodDescriptor<?, ?> method, Metadata headers, CallOptions callOptions, ClientStreamTracer[] tracers) {
        return new FailingClientStream(this.error, this.rpcProgress, tracers);
    }

    @Override
    public void ping(final ClientTransport.PingCallback callback, Executor executor) {
        executor.execute(new Runnable(){

            @Override
            public void run() {
                callback.onFailure(FailingClientTransport.this.error.asException());
            }
        });
    }

    @Override
    public ListenableFuture<InternalChannelz.SocketStats> getStats() {
        SettableFuture ret = SettableFuture.create();
        ret.set(null);
        return ret;
    }

    @Override
    public InternalLogId getLogId() {
        throw new UnsupportedOperationException("Not a real transport");
    }
}

