/*
 * Decompiled with CFR 0.152.
 */
package com.mineplex.studio.deps.io.grpc.okhttp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Supplier;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.mineplex.studio.deps.io.grpc.Attributes;
import com.mineplex.studio.deps.io.grpc.CallOptions;
import com.mineplex.studio.deps.io.grpc.ClientStreamTracer;
import com.mineplex.studio.deps.io.grpc.Grpc;
import com.mineplex.studio.deps.io.grpc.HttpConnectProxiedSocketAddress;
import com.mineplex.studio.deps.io.grpc.InternalChannelz;
import com.mineplex.studio.deps.io.grpc.InternalLogId;
import com.mineplex.studio.deps.io.grpc.Metadata;
import com.mineplex.studio.deps.io.grpc.MethodDescriptor;
import com.mineplex.studio.deps.io.grpc.SecurityLevel;
import com.mineplex.studio.deps.io.grpc.Status;
import com.mineplex.studio.deps.io.grpc.StatusException;
import com.mineplex.studio.deps.io.grpc.internal.ClientStreamListener;
import com.mineplex.studio.deps.io.grpc.internal.ClientTransport;
import com.mineplex.studio.deps.io.grpc.internal.ConnectionClientTransport;
import com.mineplex.studio.deps.io.grpc.internal.GrpcAttributes;
import com.mineplex.studio.deps.io.grpc.internal.GrpcUtil;
import com.mineplex.studio.deps.io.grpc.internal.Http2Ping;
import com.mineplex.studio.deps.io.grpc.internal.InUseStateAggregator;
import com.mineplex.studio.deps.io.grpc.internal.KeepAliveManager;
import com.mineplex.studio.deps.io.grpc.internal.ManagedClientTransport;
import com.mineplex.studio.deps.io.grpc.internal.SerializingExecutor;
import com.mineplex.studio.deps.io.grpc.internal.StatsTraceContext;
import com.mineplex.studio.deps.io.grpc.internal.TransportTracer;
import com.mineplex.studio.deps.io.grpc.okhttp.AsyncSink;
import com.mineplex.studio.deps.io.grpc.okhttp.ExceptionHandlingFrameWriter;
import com.mineplex.studio.deps.io.grpc.okhttp.OkHttpChannelBuilder;
import com.mineplex.studio.deps.io.grpc.okhttp.OkHttpClientStream;
import com.mineplex.studio.deps.io.grpc.okhttp.OkHttpFrameLogger;
import com.mineplex.studio.deps.io.grpc.okhttp.OkHttpSettingsUtil;
import com.mineplex.studio.deps.io.grpc.okhttp.OkHttpTlsUpgrader;
import com.mineplex.studio.deps.io.grpc.okhttp.OutboundFlowController;
import com.mineplex.studio.deps.io.grpc.okhttp.Utils;
import com.mineplex.studio.deps.io.grpc.okhttp.internal.ConnectionSpec;
import com.mineplex.studio.deps.io.grpc.okhttp.internal.Credentials;
import com.mineplex.studio.deps.io.grpc.okhttp.internal.StatusLine;
import com.mineplex.studio.deps.io.grpc.okhttp.internal.framed.ErrorCode;
import com.mineplex.studio.deps.io.grpc.okhttp.internal.framed.FrameReader;
import com.mineplex.studio.deps.io.grpc.okhttp.internal.framed.FrameWriter;
import com.mineplex.studio.deps.io.grpc.okhttp.internal.framed.Header;
import com.mineplex.studio.deps.io.grpc.okhttp.internal.framed.HeadersMode;
import com.mineplex.studio.deps.io.grpc.okhttp.internal.framed.Http2;
import com.mineplex.studio.deps.io.grpc.okhttp.internal.framed.Settings;
import com.mineplex.studio.deps.io.grpc.okhttp.internal.framed.Variant;
import com.mineplex.studio.deps.io.grpc.okhttp.internal.proxy.HttpUrl;
import com.mineplex.studio.deps.io.grpc.okhttp.internal.proxy.Request;
import com.mineplex.studio.deps.io.perfmark.PerfMark;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.util.Collections;
import java.util.Deque;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.net.SocketFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ByteString;
import okio.Okio;
import okio.Sink;
import okio.Source;
import okio.Timeout;

class OkHttpClientTransport
implements ConnectionClientTransport,
ExceptionHandlingFrameWriter.TransportExceptionHandler,
OutboundFlowController.Transport {
    private static final Map<ErrorCode, Status> ERROR_CODE_TO_STATUS = OkHttpClientTransport.buildErrorCodeToStatusMap();
    private static final Logger log = Logger.getLogger(OkHttpClientTransport.class.getName());
    private final InetSocketAddress address;
    private final String defaultAuthority;
    private final String userAgent;
    private final Random random = new Random();
    private final Supplier<Stopwatch> stopwatchFactory;
    private final int initialWindowSize;
    private final Variant variant;
    private ManagedClientTransport.Listener listener;
    @GuardedBy(value="lock")
    private ExceptionHandlingFrameWriter frameWriter;
    private OutboundFlowController outboundFlow;
    private final Object lock = new Object();
    private final InternalLogId logId;
    @GuardedBy(value="lock")
    private int nextStreamId;
    @GuardedBy(value="lock")
    private final Map<Integer, OkHttpClientStream> streams = new HashMap<Integer, OkHttpClientStream>();
    private final Executor executor;
    private final SerializingExecutor serializingExecutor;
    private final ScheduledExecutorService scheduler;
    private final int maxMessageSize;
    private int connectionUnacknowledgedBytesRead;
    private ClientFrameHandler clientFrameHandler;
    private Attributes attributes;
    @GuardedBy(value="lock")
    private Status goAwayStatus;
    @GuardedBy(value="lock")
    private boolean goAwaySent;
    @GuardedBy(value="lock")
    private Http2Ping ping;
    @GuardedBy(value="lock")
    private boolean stopped;
    @GuardedBy(value="lock")
    private boolean hasStream;
    private final SocketFactory socketFactory;
    private SSLSocketFactory sslSocketFactory;
    private HostnameVerifier hostnameVerifier;
    private Socket socket;
    @GuardedBy(value="lock")
    private int maxConcurrentStreams = 0;
    @GuardedBy(value="lock")
    private final Deque<OkHttpClientStream> pendingStreams = new LinkedList<OkHttpClientStream>();
    private final ConnectionSpec connectionSpec;
    private KeepAliveManager keepAliveManager;
    private boolean enableKeepAlive;
    private long keepAliveTimeNanos;
    private long keepAliveTimeoutNanos;
    private boolean keepAliveWithoutCalls;
    private final Runnable tooManyPingsRunnable;
    private final int maxInboundMetadataSize;
    private final boolean useGetForSafeMethods;
    @GuardedBy(value="lock")
    private final TransportTracer transportTracer;
    @GuardedBy(value="lock")
    private final InUseStateAggregator<OkHttpClientStream> inUseState = new InUseStateAggregator<OkHttpClientStream>(){

        @Override
        protected void handleInUse() {
            OkHttpClientTransport.this.listener.transportInUse(true);
        }

        @Override
        protected void handleNotInUse() {
            OkHttpClientTransport.this.listener.transportInUse(false);
        }
    };
    @GuardedBy(value="lock")
    private InternalChannelz.Security securityInfo;
    @Nullable
    @VisibleForTesting
    final HttpConnectProxiedSocketAddress proxiedAddr;
    @VisibleForTesting
    int proxySocketTimeout = 30000;
    Runnable connectingCallback;
    SettableFuture<Void> connectedFuture;

    private static Map<ErrorCode, Status> buildErrorCodeToStatusMap() {
        EnumMap<ErrorCode, Status> errorToStatus = new EnumMap<ErrorCode, Status>(ErrorCode.class);
        errorToStatus.put(ErrorCode.NO_ERROR, Status.INTERNAL.withDescription("No error: A GRPC status of OK should have been sent"));
        errorToStatus.put(ErrorCode.PROTOCOL_ERROR, Status.INTERNAL.withDescription("Protocol error"));
        errorToStatus.put(ErrorCode.INTERNAL_ERROR, Status.INTERNAL.withDescription("Internal error"));
        errorToStatus.put(ErrorCode.FLOW_CONTROL_ERROR, Status.INTERNAL.withDescription("Flow control error"));
        errorToStatus.put(ErrorCode.STREAM_CLOSED, Status.INTERNAL.withDescription("Stream closed"));
        errorToStatus.put(ErrorCode.FRAME_TOO_LARGE, Status.INTERNAL.withDescription("Frame too large"));
        errorToStatus.put(ErrorCode.REFUSED_STREAM, Status.UNAVAILABLE.withDescription("Refused stream"));
        errorToStatus.put(ErrorCode.CANCEL, Status.CANCELLED.withDescription("Cancelled"));
        errorToStatus.put(ErrorCode.COMPRESSION_ERROR, Status.INTERNAL.withDescription("Compression error"));
        errorToStatus.put(ErrorCode.CONNECT_ERROR, Status.INTERNAL.withDescription("Connect error"));
        errorToStatus.put(ErrorCode.ENHANCE_YOUR_CALM, Status.RESOURCE_EXHAUSTED.withDescription("Enhance your calm"));
        errorToStatus.put(ErrorCode.INADEQUATE_SECURITY, Status.PERMISSION_DENIED.withDescription("Inadequate security"));
        return Collections.unmodifiableMap(errorToStatus);
    }

    public OkHttpClientTransport(OkHttpChannelBuilder.OkHttpTransportFactory transportFactory, InetSocketAddress address, String authority, @Nullable String userAgent, Attributes eagAttrs, @Nullable HttpConnectProxiedSocketAddress proxiedAddr, Runnable tooManyPingsRunnable) {
        this(transportFactory, address, authority, userAgent, eagAttrs, GrpcUtil.STOPWATCH_SUPPLIER, new Http2(), proxiedAddr, tooManyPingsRunnable);
    }

    private OkHttpClientTransport(OkHttpChannelBuilder.OkHttpTransportFactory transportFactory, InetSocketAddress address, String authority, @Nullable String userAgent, Attributes eagAttrs, Supplier<Stopwatch> stopwatchFactory, Variant variant, @Nullable HttpConnectProxiedSocketAddress proxiedAddr, Runnable tooManyPingsRunnable) {
        this.address = (InetSocketAddress)Preconditions.checkNotNull((Object)address, (Object)"address");
        this.defaultAuthority = authority;
        this.maxMessageSize = transportFactory.maxMessageSize;
        this.initialWindowSize = transportFactory.flowControlWindow;
        this.executor = (Executor)Preconditions.checkNotNull((Object)transportFactory.executor, (Object)"executor");
        this.serializingExecutor = new SerializingExecutor(transportFactory.executor);
        this.scheduler = (ScheduledExecutorService)Preconditions.checkNotNull((Object)transportFactory.scheduledExecutorService, (Object)"scheduledExecutorService");
        this.nextStreamId = 3;
        this.socketFactory = transportFactory.socketFactory == null ? SocketFactory.getDefault() : transportFactory.socketFactory;
        this.sslSocketFactory = transportFactory.sslSocketFactory;
        this.hostnameVerifier = transportFactory.hostnameVerifier;
        this.connectionSpec = (ConnectionSpec)Preconditions.checkNotNull((Object)transportFactory.connectionSpec, (Object)"connectionSpec");
        this.stopwatchFactory = (Supplier)Preconditions.checkNotNull(stopwatchFactory, (Object)"stopwatchFactory");
        this.variant = (Variant)Preconditions.checkNotNull((Object)variant, (Object)"variant");
        this.userAgent = GrpcUtil.getGrpcUserAgent("okhttp", userAgent);
        this.proxiedAddr = proxiedAddr;
        this.tooManyPingsRunnable = (Runnable)Preconditions.checkNotNull((Object)tooManyPingsRunnable, (Object)"tooManyPingsRunnable");
        this.maxInboundMetadataSize = transportFactory.maxInboundMetadataSize;
        this.transportTracer = transportFactory.transportTracerFactory.create();
        this.logId = InternalLogId.allocate(this.getClass(), address.toString());
        this.attributes = Attributes.newBuilder().set(GrpcAttributes.ATTR_CLIENT_EAG_ATTRS, eagAttrs).build();
        this.useGetForSafeMethods = transportFactory.useGetForSafeMethods;
        this.initTransportTracer();
    }

    @VisibleForTesting
    OkHttpClientTransport(OkHttpChannelBuilder.OkHttpTransportFactory transportFactory, String userAgent, Supplier<Stopwatch> stopwatchFactory, Variant variant, @Nullable Runnable connectingCallback, SettableFuture<Void> connectedFuture, Runnable tooManyPingsRunnable) {
        this(transportFactory, new InetSocketAddress("127.0.0.1", 80), "notarealauthority:80", userAgent, Attributes.EMPTY, stopwatchFactory, variant, null, tooManyPingsRunnable);
        this.connectingCallback = connectingCallback;
        this.connectedFuture = (SettableFuture)Preconditions.checkNotNull(connectedFuture, (Object)"connectedFuture");
    }

    boolean isUsingPlaintext() {
        return this.sslSocketFactory == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initTransportTracer() {
        Object object = this.lock;
        synchronized (object) {
            this.transportTracer.setFlowControlWindowReader(new TransportTracer.FlowControlReader(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public TransportTracer.FlowControlWindows read() {
                    Object object = OkHttpClientTransport.this.lock;
                    synchronized (object) {
                        long local = OkHttpClientTransport.this.outboundFlow == null ? -1L : (long)OkHttpClientTransport.this.outboundFlow.windowUpdate(null, 0);
                        long remote = (long)((float)OkHttpClientTransport.this.initialWindowSize * 0.5f);
                        return new TransportTracer.FlowControlWindows(local, remote);
                    }
                }
            });
        }
    }

    void enableKeepAlive(boolean enable, long keepAliveTimeNanos, long keepAliveTimeoutNanos, boolean keepAliveWithoutCalls) {
        this.enableKeepAlive = enable;
        this.keepAliveTimeNanos = keepAliveTimeNanos;
        this.keepAliveTimeoutNanos = keepAliveTimeoutNanos;
        this.keepAliveWithoutCalls = keepAliveWithoutCalls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ping(ClientTransport.PingCallback callback, Executor executor) {
        Http2Ping p;
        long data = 0L;
        Object object = this.lock;
        synchronized (object) {
            boolean writePing;
            Preconditions.checkState((this.frameWriter != null ? 1 : 0) != 0);
            if (this.stopped) {
                Http2Ping.notifyFailed(callback, executor, this.getPingFailure());
                return;
            }
            if (this.ping != null) {
                p = this.ping;
                writePing = false;
            } else {
                data = this.random.nextLong();
                Stopwatch stopwatch = (Stopwatch)this.stopwatchFactory.get();
                stopwatch.start();
                p = this.ping = new Http2Ping(data, stopwatch);
                writePing = true;
                this.transportTracer.reportKeepAliveSent();
            }
            if (writePing) {
                this.frameWriter.ping(false, (int)(data >>> 32), (int)data);
            }
        }
        p.addCallback(callback, executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OkHttpClientStream newStream(MethodDescriptor<?, ?> method, Metadata headers, CallOptions callOptions, ClientStreamTracer[] tracers) {
        Preconditions.checkNotNull(method, (Object)"method");
        Preconditions.checkNotNull((Object)headers, (Object)"headers");
        StatsTraceContext statsTraceContext = StatsTraceContext.newClientContext(tracers, this.getAttributes(), headers);
        Object object = this.lock;
        synchronized (object) {
            return new OkHttpClientStream(method, headers, this.frameWriter, this, this.outboundFlow, this.lock, this.maxMessageSize, this.initialWindowSize, this.defaultAuthority, this.userAgent, statsTraceContext, this.transportTracer, callOptions, this.useGetForSafeMethods);
        }
    }

    @GuardedBy(value="lock")
    void streamReadyToStart(OkHttpClientStream clientStream) {
        if (this.goAwayStatus != null) {
            clientStream.transportState().transportReportStatus(this.goAwayStatus, ClientStreamListener.RpcProgress.MISCARRIED, true, new Metadata());
        } else if (this.streams.size() >= this.maxConcurrentStreams) {
            this.pendingStreams.add(clientStream);
            this.setInUse(clientStream);
        } else {
            this.startStream(clientStream);
        }
    }

    @GuardedBy(value="lock")
    private void startStream(OkHttpClientStream stream) {
        Preconditions.checkState((stream.transportState().id() == -1 ? 1 : 0) != 0, (Object)"StreamId already assigned");
        this.streams.put(this.nextStreamId, stream);
        this.setInUse(stream);
        stream.transportState().start(this.nextStreamId);
        if (stream.getType() != MethodDescriptor.MethodType.UNARY && stream.getType() != MethodDescriptor.MethodType.SERVER_STREAMING || stream.useGet()) {
            this.frameWriter.flush();
        }
        if (this.nextStreamId >= 0x7FFFFFFD) {
            this.nextStreamId = Integer.MAX_VALUE;
            this.startGoAway(Integer.MAX_VALUE, ErrorCode.NO_ERROR, Status.UNAVAILABLE.withDescription("Stream ids exhausted"));
        } else {
            this.nextStreamId += 2;
        }
    }

    @GuardedBy(value="lock")
    private boolean startPendingStreams() {
        boolean hasStreamStarted = false;
        while (!this.pendingStreams.isEmpty() && this.streams.size() < this.maxConcurrentStreams) {
            OkHttpClientStream stream = this.pendingStreams.poll();
            this.startStream(stream);
            hasStreamStarted = true;
        }
        return hasStreamStarted;
    }

    @GuardedBy(value="lock")
    void removePendingStream(OkHttpClientStream pendingStream) {
        this.pendingStreams.remove(pendingStream);
        this.maybeClearInUse(pendingStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Runnable start(ManagedClientTransport.Listener listener) {
        this.listener = (ManagedClientTransport.Listener)Preconditions.checkNotNull((Object)listener, (Object)"listener");
        if (this.enableKeepAlive) {
            this.keepAliveManager = new KeepAliveManager(new KeepAliveManager.ClientKeepAlivePinger(this), this.scheduler, this.keepAliveTimeNanos, this.keepAliveTimeoutNanos, this.keepAliveWithoutCalls);
            this.keepAliveManager.onTransportStarted();
        }
        int maxQueuedControlFrames = 10000;
        final AsyncSink asyncSink = AsyncSink.sink(this.serializingExecutor, this, maxQueuedControlFrames);
        FrameWriter rawFrameWriter = asyncSink.limitControlFramesWriter(this.variant.newWriter(Okio.buffer((Sink)asyncSink), true));
        Object object = this.lock;
        synchronized (object) {
            this.frameWriter = new ExceptionHandlingFrameWriter(this, rawFrameWriter);
            this.outboundFlow = new OutboundFlowController(this, this.frameWriter);
        }
        final CountDownLatch latch = new CountDownLatch(1);
        this.serializingExecutor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Socket sock;
                try {
                    latch.await();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                BufferedSource source = Okio.buffer((Source)new Source(){

                    public long read(Buffer sink, long byteCount) {
                        return -1L;
                    }

                    public Timeout timeout() {
                        return Timeout.NONE;
                    }

                    public void close() {
                    }
                });
                SSLSession sslSession = null;
                try {
                    if (OkHttpClientTransport.this.proxiedAddr == null) {
                        sock = OkHttpClientTransport.this.socketFactory.createSocket(OkHttpClientTransport.this.address.getAddress(), OkHttpClientTransport.this.address.getPort());
                    } else if (OkHttpClientTransport.this.proxiedAddr.getProxyAddress() instanceof InetSocketAddress) {
                        sock = OkHttpClientTransport.this.createHttpProxySocket(OkHttpClientTransport.this.proxiedAddr.getTargetAddress(), (InetSocketAddress)OkHttpClientTransport.this.proxiedAddr.getProxyAddress(), OkHttpClientTransport.this.proxiedAddr.getUsername(), OkHttpClientTransport.this.proxiedAddr.getPassword());
                    } else {
                        throw Status.INTERNAL.withDescription("Unsupported SocketAddress implementation " + OkHttpClientTransport.this.proxiedAddr.getProxyAddress().getClass()).asException();
                    }
                    if (OkHttpClientTransport.this.sslSocketFactory != null) {
                        SSLSocket sslSocket = OkHttpTlsUpgrader.upgrade(OkHttpClientTransport.this.sslSocketFactory, OkHttpClientTransport.this.hostnameVerifier, sock, OkHttpClientTransport.this.getOverridenHost(), OkHttpClientTransport.this.getOverridenPort(), OkHttpClientTransport.this.connectionSpec);
                        sslSession = sslSocket.getSession();
                        sock = sslSocket;
                    }
                    sock.setTcpNoDelay(true);
                    source = Okio.buffer((Source)Okio.source((Socket)sock));
                    asyncSink.becomeConnected(Okio.sink((Socket)sock), sock);
                    OkHttpClientTransport.this.attributes = OkHttpClientTransport.this.attributes.toBuilder().set(Grpc.TRANSPORT_ATTR_REMOTE_ADDR, sock.getRemoteSocketAddress()).set(Grpc.TRANSPORT_ATTR_LOCAL_ADDR, sock.getLocalSocketAddress()).set(Grpc.TRANSPORT_ATTR_SSL_SESSION, sslSession).set(GrpcAttributes.ATTR_SECURITY_LEVEL, sslSession == null ? SecurityLevel.NONE : SecurityLevel.PRIVACY_AND_INTEGRITY).build();
                }
                catch (StatusException e) {
                    OkHttpClientTransport.this.startGoAway(0, ErrorCode.INTERNAL_ERROR, e.getStatus());
                    return;
                }
                catch (Exception e) {
                    OkHttpClientTransport.this.onException(e);
                    return;
                }
                finally {
                    OkHttpClientTransport.this.clientFrameHandler = new ClientFrameHandler(OkHttpClientTransport.this.variant.newReader(source, true));
                }
                Object object = OkHttpClientTransport.this.lock;
                synchronized (object) {
                    OkHttpClientTransport.this.socket = (Socket)Preconditions.checkNotNull((Object)sock, (Object)"socket");
                    if (sslSession != null) {
                        OkHttpClientTransport.this.securityInfo = new InternalChannelz.Security(new InternalChannelz.Tls(sslSession));
                    }
                }
            }
        });
        try {
            this.sendConnectionPrefaceAndSettings();
        }
        finally {
            latch.countDown();
        }
        this.serializingExecutor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (OkHttpClientTransport.this.connectingCallback != null) {
                    OkHttpClientTransport.this.connectingCallback.run();
                }
                OkHttpClientTransport.this.executor.execute(OkHttpClientTransport.this.clientFrameHandler);
                Object object = OkHttpClientTransport.this.lock;
                synchronized (object) {
                    OkHttpClientTransport.this.maxConcurrentStreams = Integer.MAX_VALUE;
                    OkHttpClientTransport.this.startPendingStreams();
                }
                if (OkHttpClientTransport.this.connectedFuture != null) {
                    OkHttpClientTransport.this.connectedFuture.set(null);
                }
            }
        });
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendConnectionPrefaceAndSettings() {
        Object object = this.lock;
        synchronized (object) {
            this.frameWriter.connectionPreface();
            Settings settings = new Settings();
            OkHttpSettingsUtil.set(settings, 7, this.initialWindowSize);
            this.frameWriter.settings(settings);
            if (this.initialWindowSize > 65535) {
                this.frameWriter.windowUpdate(0, this.initialWindowSize - 65535);
            }
        }
    }

    private Socket createHttpProxySocket(InetSocketAddress address, InetSocketAddress proxyAddress, String proxyUsername, String proxyPassword) throws StatusException {
        Socket sock = null;
        try {
            sock = proxyAddress.getAddress() != null ? this.socketFactory.createSocket(proxyAddress.getAddress(), proxyAddress.getPort()) : this.socketFactory.createSocket(proxyAddress.getHostName(), proxyAddress.getPort());
            sock.setTcpNoDelay(true);
            sock.setSoTimeout(this.proxySocketTimeout);
            Source source = Okio.source((Socket)sock);
            BufferedSink sink = Okio.buffer((Sink)Okio.sink((Socket)sock));
            Request proxyRequest = this.createHttpProxyRequest(address, proxyUsername, proxyPassword);
            HttpUrl url = proxyRequest.httpUrl();
            String requestLine = String.format(Locale.US, "CONNECT %s:%d HTTP/1.1", url.host(), url.port());
            sink.writeUtf8(requestLine).writeUtf8("\r\n");
            int size = proxyRequest.headers().size();
            for (int i = 0; i < size; ++i) {
                sink.writeUtf8(proxyRequest.headers().name(i)).writeUtf8(": ").writeUtf8(proxyRequest.headers().value(i)).writeUtf8("\r\n");
            }
            sink.writeUtf8("\r\n");
            sink.flush();
            StatusLine statusLine = StatusLine.parse(OkHttpClientTransport.readUtf8LineStrictUnbuffered(source));
            while (!OkHttpClientTransport.readUtf8LineStrictUnbuffered(source).equals("")) {
            }
            if (statusLine.code < 200 || statusLine.code >= 300) {
                Buffer body = new Buffer();
                try {
                    sock.shutdownOutput();
                    source.read(body, 1024L);
                }
                catch (IOException ex) {
                    body.writeUtf8("Unable to read body: " + ex.toString());
                }
                try {
                    sock.close();
                }
                catch (IOException ex) {
                    // empty catch block
                }
                String message = String.format(Locale.US, "Response returned from proxy was not successful (expected 2xx, got %d %s). Response body:\n%s", statusLine.code, statusLine.message, body.readUtf8());
                throw Status.UNAVAILABLE.withDescription(message).asException();
            }
            sock.setSoTimeout(0);
            return sock;
        }
        catch (IOException e) {
            if (sock != null) {
                GrpcUtil.closeQuietly(sock);
            }
            throw Status.UNAVAILABLE.withDescription("Failed trying to connect with proxy").withCause(e).asException();
        }
    }

    private Request createHttpProxyRequest(InetSocketAddress address, String proxyUsername, String proxyPassword) {
        HttpUrl tunnelUrl = new HttpUrl.Builder().scheme("https").host(address.getHostName()).port(address.getPort()).build();
        Request.Builder request = new Request.Builder().url(tunnelUrl).header("Host", tunnelUrl.host() + ":" + tunnelUrl.port()).header("User-Agent", this.userAgent);
        if (proxyUsername != null && proxyPassword != null) {
            request.header("Proxy-Authorization", Credentials.basic(proxyUsername, proxyPassword));
        }
        return request.build();
    }

    private static String readUtf8LineStrictUnbuffered(Source source) throws IOException {
        Buffer buffer = new Buffer();
        do {
            if (source.read(buffer, 1L) != -1L) continue;
            throw new EOFException("\\n not found: " + buffer.readByteString().hex());
        } while (buffer.getByte(buffer.size() - 1L) != 10);
        return buffer.readUtf8LineStrict();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("logId", this.logId.getId()).add("address", (Object)this.address).toString();
    }

    @Override
    public InternalLogId getLogId() {
        return this.logId;
    }

    @VisibleForTesting
    String getOverridenHost() {
        URI uri = GrpcUtil.authorityToUri(this.defaultAuthority);
        if (uri.getHost() != null) {
            return uri.getHost();
        }
        return this.defaultAuthority;
    }

    @VisibleForTesting
    int getOverridenPort() {
        URI uri = GrpcUtil.authorityToUri(this.defaultAuthority);
        if (uri.getPort() != -1) {
            return uri.getPort();
        }
        return this.address.getPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown(Status reason) {
        Object object = this.lock;
        synchronized (object) {
            if (this.goAwayStatus != null) {
                return;
            }
            this.goAwayStatus = reason;
            this.listener.transportShutdown(this.goAwayStatus);
            this.stopIfNecessary();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdownNow(Status reason) {
        this.shutdown(reason);
        Object object = this.lock;
        synchronized (object) {
            Iterator<Map.Entry<Integer, OkHttpClientStream>> it = this.streams.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Integer, OkHttpClientStream> entry = it.next();
                it.remove();
                entry.getValue().transportState().transportReportStatus(reason, false, new Metadata());
                this.maybeClearInUse(entry.getValue());
            }
            for (OkHttpClientStream stream : this.pendingStreams) {
                stream.transportState().transportReportStatus(reason, ClientStreamListener.RpcProgress.MISCARRIED, true, new Metadata());
                this.maybeClearInUse(stream);
            }
            this.pendingStreams.clear();
            this.stopIfNecessary();
        }
    }

    @Override
    public Attributes getAttributes() {
        return this.attributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutboundFlowController.StreamState[] getActiveStreams() {
        Object object = this.lock;
        synchronized (object) {
            OutboundFlowController.StreamState[] flowStreams = new OutboundFlowController.StreamState[this.streams.size()];
            int i = 0;
            for (OkHttpClientStream stream : this.streams.values()) {
                flowStreams[i++] = stream.transportState().getOutboundFlowState();
            }
            return flowStreams;
        }
    }

    @VisibleForTesting
    ClientFrameHandler getHandler() {
        return this.clientFrameHandler;
    }

    @VisibleForTesting
    SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    int getPendingStreamSize() {
        Object object = this.lock;
        synchronized (object) {
            return this.pendingStreams.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void setNextStreamId(int nextStreamId) {
        Object object = this.lock;
        synchronized (object) {
            this.nextStreamId = nextStreamId;
        }
    }

    @Override
    public void onException(Throwable failureCause) {
        Preconditions.checkNotNull((Object)failureCause, (Object)"failureCause");
        Status status = Status.UNAVAILABLE.withCause(failureCause);
        this.startGoAway(0, ErrorCode.INTERNAL_ERROR, status);
    }

    private void onError(ErrorCode errorCode, String moreDetail) {
        this.startGoAway(0, errorCode, OkHttpClientTransport.toGrpcStatus(errorCode).augmentDescription(moreDetail));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startGoAway(int lastKnownStreamId, ErrorCode errorCode, Status status) {
        Object object = this.lock;
        synchronized (object) {
            if (this.goAwayStatus == null) {
                this.goAwayStatus = status;
                this.listener.transportShutdown(status);
            }
            if (errorCode != null && !this.goAwaySent) {
                this.goAwaySent = true;
                this.frameWriter.goAway(0, errorCode, new byte[0]);
            }
            Iterator<Map.Entry<Integer, OkHttpClientStream>> it = this.streams.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Integer, OkHttpClientStream> entry = it.next();
                if (entry.getKey() <= lastKnownStreamId) continue;
                it.remove();
                entry.getValue().transportState().transportReportStatus(status, ClientStreamListener.RpcProgress.REFUSED, false, new Metadata());
                this.maybeClearInUse(entry.getValue());
            }
            for (OkHttpClientStream stream : this.pendingStreams) {
                stream.transportState().transportReportStatus(status, ClientStreamListener.RpcProgress.MISCARRIED, true, new Metadata());
                this.maybeClearInUse(stream);
            }
            this.pendingStreams.clear();
            this.stopIfNecessary();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finishStream(int streamId, @Nullable Status status, ClientStreamListener.RpcProgress rpcProgress, boolean stopDelivery, @Nullable ErrorCode errorCode, @Nullable Metadata trailers) {
        Object object = this.lock;
        synchronized (object) {
            OkHttpClientStream stream = this.streams.remove(streamId);
            if (stream != null) {
                if (errorCode != null) {
                    this.frameWriter.rstStream(streamId, ErrorCode.CANCEL);
                }
                if (status != null) {
                    stream.transportState().transportReportStatus(status, rpcProgress, stopDelivery, trailers != null ? trailers : new Metadata());
                }
                if (!this.startPendingStreams()) {
                    this.stopIfNecessary();
                }
                this.maybeClearInUse(stream);
            }
        }
    }

    @GuardedBy(value="lock")
    private void stopIfNecessary() {
        if (this.goAwayStatus == null || !this.streams.isEmpty() || !this.pendingStreams.isEmpty()) {
            return;
        }
        if (this.stopped) {
            return;
        }
        this.stopped = true;
        if (this.keepAliveManager != null) {
            this.keepAliveManager.onTransportTermination();
        }
        if (this.ping != null) {
            this.ping.failed(this.getPingFailure());
            this.ping = null;
        }
        if (!this.goAwaySent) {
            this.goAwaySent = true;
            this.frameWriter.goAway(0, ErrorCode.NO_ERROR, new byte[0]);
        }
        this.frameWriter.close();
    }

    @GuardedBy(value="lock")
    private void maybeClearInUse(OkHttpClientStream stream) {
        if (this.hasStream && this.pendingStreams.isEmpty() && this.streams.isEmpty()) {
            this.hasStream = false;
            if (this.keepAliveManager != null) {
                this.keepAliveManager.onTransportIdle();
            }
        }
        if (stream.shouldBeCountedForInUse()) {
            this.inUseState.updateObjectInUse(stream, false);
        }
    }

    @GuardedBy(value="lock")
    private void setInUse(OkHttpClientStream stream) {
        if (!this.hasStream) {
            this.hasStream = true;
            if (this.keepAliveManager != null) {
                this.keepAliveManager.onTransportActive();
            }
        }
        if (stream.shouldBeCountedForInUse()) {
            this.inUseState.updateObjectInUse(stream, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Throwable getPingFailure() {
        Object object = this.lock;
        synchronized (object) {
            if (this.goAwayStatus != null) {
                return this.goAwayStatus.asException();
            }
            return Status.UNAVAILABLE.withDescription("Connection closed").asException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean mayHaveCreatedStream(int streamId) {
        Object object = this.lock;
        synchronized (object) {
            return streamId < this.nextStreamId && (streamId & 1) == 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OkHttpClientStream getStream(int streamId) {
        Object object = this.lock;
        synchronized (object) {
            return this.streams.get(streamId);
        }
    }

    @VisibleForTesting
    static Status toGrpcStatus(ErrorCode code) {
        Status status = ERROR_CODE_TO_STATUS.get((Object)code);
        return status != null ? status : Status.UNKNOWN.withDescription("Unknown http2 error code: " + code.httpCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListenableFuture<InternalChannelz.SocketStats> getStats() {
        SettableFuture ret = SettableFuture.create();
        Object object = this.lock;
        synchronized (object) {
            if (this.socket == null) {
                ret.set((Object)new InternalChannelz.SocketStats(this.transportTracer.getStats(), null, null, new InternalChannelz.SocketOptions.Builder().build(), null));
            } else {
                ret.set((Object)new InternalChannelz.SocketStats(this.transportTracer.getStats(), this.socket.getLocalSocketAddress(), this.socket.getRemoteSocketAddress(), Utils.getSocketOptions(this.socket), this.securityInfo));
            }
            return ret;
        }
    }

    class ClientFrameHandler
    implements FrameReader.Handler,
    Runnable {
        private final OkHttpFrameLogger logger = new OkHttpFrameLogger(Level.FINE, OkHttpClientTransport.class);
        FrameReader frameReader;
        boolean firstSettings = true;

        ClientFrameHandler(FrameReader frameReader) {
            this.frameReader = frameReader;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String threadName = Thread.currentThread().getName();
            Thread.currentThread().setName("OkHttpClientTransport");
            try {
                Status status;
                while (this.frameReader.nextFrame(this)) {
                    if (OkHttpClientTransport.this.keepAliveManager == null) continue;
                    OkHttpClientTransport.this.keepAliveManager.onDataReceived();
                }
                Object object = OkHttpClientTransport.this.lock;
                synchronized (object) {
                    status = OkHttpClientTransport.this.goAwayStatus;
                }
                if (status == null) {
                    status = Status.UNAVAILABLE.withDescription("End of stream or IOException");
                }
                OkHttpClientTransport.this.startGoAway(0, ErrorCode.INTERNAL_ERROR, status);
            }
            catch (Throwable t) {
                OkHttpClientTransport.this.startGoAway(0, ErrorCode.PROTOCOL_ERROR, Status.INTERNAL.withDescription("error in frame handler").withCause(t));
            }
            finally {
                block20: {
                    try {
                        this.frameReader.close();
                    }
                    catch (IOException ex) {
                        log.log(Level.INFO, "Exception closing frame reader", ex);
                    }
                    catch (RuntimeException e) {
                        if ("bio == null".equals(e.getMessage())) break block20;
                        throw e;
                    }
                }
                OkHttpClientTransport.this.listener.transportTerminated();
                Thread.currentThread().setName(threadName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void data(boolean inFinished, int streamId, BufferedSource in, int length, int paddedLength) throws IOException {
            Object object;
            this.logger.logData(OkHttpFrameLogger.Direction.INBOUND, streamId, in.getBuffer(), length, inFinished);
            OkHttpClientStream stream = OkHttpClientTransport.this.getStream(streamId);
            if (stream == null) {
                if (!OkHttpClientTransport.this.mayHaveCreatedStream(streamId)) {
                    OkHttpClientTransport.this.onError(ErrorCode.PROTOCOL_ERROR, "Received data for unknown stream: " + streamId);
                    return;
                }
                object = OkHttpClientTransport.this.lock;
                synchronized (object) {
                    OkHttpClientTransport.this.frameWriter.rstStream(streamId, ErrorCode.STREAM_CLOSED);
                }
                in.skip((long)length);
            } else {
                in.require((long)length);
                Buffer buf = new Buffer();
                buf.write(in.getBuffer(), (long)length);
                PerfMark.event("OkHttpClientTransport$ClientFrameHandler.data", stream.transportState().tag());
                Object object2 = OkHttpClientTransport.this.lock;
                synchronized (object2) {
                    stream.transportState().transportDataReceived(buf, inFinished, paddedLength - length);
                }
            }
            OkHttpClientTransport.this.connectionUnacknowledgedBytesRead += paddedLength;
            if ((float)OkHttpClientTransport.this.connectionUnacknowledgedBytesRead >= (float)OkHttpClientTransport.this.initialWindowSize * 0.5f) {
                object = OkHttpClientTransport.this.lock;
                synchronized (object) {
                    OkHttpClientTransport.this.frameWriter.windowUpdate(0, OkHttpClientTransport.this.connectionUnacknowledgedBytesRead);
                }
                OkHttpClientTransport.this.connectionUnacknowledgedBytesRead = 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void headers(boolean outFinished, boolean inFinished, int streamId, int associatedStreamId, List<Header> headerBlock, HeadersMode headersMode) {
            int metadataSize;
            this.logger.logHeaders(OkHttpFrameLogger.Direction.INBOUND, streamId, headerBlock, inFinished);
            boolean unknownStream = false;
            Status failedStatus = null;
            if (OkHttpClientTransport.this.maxInboundMetadataSize != Integer.MAX_VALUE && (metadataSize = this.headerBlockSize(headerBlock)) > OkHttpClientTransport.this.maxInboundMetadataSize) {
                failedStatus = Status.RESOURCE_EXHAUSTED.withDescription(String.format(Locale.US, "Response %s metadata larger than %d: %d", inFinished ? "trailer" : "header", OkHttpClientTransport.this.maxInboundMetadataSize, metadataSize));
            }
            Object object = OkHttpClientTransport.this.lock;
            synchronized (object) {
                OkHttpClientStream stream = (OkHttpClientStream)OkHttpClientTransport.this.streams.get(streamId);
                if (stream == null) {
                    if (OkHttpClientTransport.this.mayHaveCreatedStream(streamId)) {
                        OkHttpClientTransport.this.frameWriter.rstStream(streamId, ErrorCode.STREAM_CLOSED);
                    } else {
                        unknownStream = true;
                    }
                } else if (failedStatus == null) {
                    PerfMark.event("OkHttpClientTransport$ClientFrameHandler.headers", stream.transportState().tag());
                    stream.transportState().transportHeadersReceived(headerBlock, inFinished);
                } else {
                    if (!inFinished) {
                        OkHttpClientTransport.this.frameWriter.rstStream(streamId, ErrorCode.CANCEL);
                    }
                    stream.transportState().transportReportStatus(failedStatus, false, new Metadata());
                }
            }
            if (unknownStream) {
                OkHttpClientTransport.this.onError(ErrorCode.PROTOCOL_ERROR, "Received header for unknown stream: " + streamId);
            }
        }

        private int headerBlockSize(List<Header> headerBlock) {
            long size = 0L;
            for (int i = 0; i < headerBlock.size(); ++i) {
                Header header = headerBlock.get(i);
                size += (long)(32 + header.name.size() + header.value.size());
            }
            size = Math.min(size, Integer.MAX_VALUE);
            return (int)size;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void rstStream(int streamId, ErrorCode errorCode) {
            this.logger.logRstStream(OkHttpFrameLogger.Direction.INBOUND, streamId, errorCode);
            Status status = OkHttpClientTransport.toGrpcStatus(errorCode).augmentDescription("Rst Stream");
            boolean stopDelivery = status.getCode() == Status.Code.CANCELLED || status.getCode() == Status.Code.DEADLINE_EXCEEDED;
            Object object = OkHttpClientTransport.this.lock;
            synchronized (object) {
                OkHttpClientStream stream = (OkHttpClientStream)OkHttpClientTransport.this.streams.get(streamId);
                if (stream != null) {
                    PerfMark.event("OkHttpClientTransport$ClientFrameHandler.rstStream", stream.transportState().tag());
                    OkHttpClientTransport.this.finishStream(streamId, status, errorCode == ErrorCode.REFUSED_STREAM ? ClientStreamListener.RpcProgress.REFUSED : ClientStreamListener.RpcProgress.PROCESSED, stopDelivery, null, null);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void settings(boolean clearPrevious, Settings settings) {
            this.logger.logSettings(OkHttpFrameLogger.Direction.INBOUND, settings);
            boolean outboundWindowSizeIncreased = false;
            Object object = OkHttpClientTransport.this.lock;
            synchronized (object) {
                if (OkHttpSettingsUtil.isSet(settings, 4)) {
                    int receivedMaxConcurrentStreams = OkHttpSettingsUtil.get(settings, 4);
                    OkHttpClientTransport.this.maxConcurrentStreams = receivedMaxConcurrentStreams;
                }
                if (OkHttpSettingsUtil.isSet(settings, 7)) {
                    int initialWindowSize = OkHttpSettingsUtil.get(settings, 7);
                    outboundWindowSizeIncreased = OkHttpClientTransport.this.outboundFlow.initialOutboundWindowSize(initialWindowSize);
                }
                if (this.firstSettings) {
                    OkHttpClientTransport.this.attributes = OkHttpClientTransport.this.listener.filterTransport(OkHttpClientTransport.this.attributes);
                    OkHttpClientTransport.this.listener.transportReady();
                    this.firstSettings = false;
                }
                OkHttpClientTransport.this.frameWriter.ackSettings(settings);
                if (outboundWindowSizeIncreased) {
                    OkHttpClientTransport.this.outboundFlow.writeStreams();
                }
                OkHttpClientTransport.this.startPendingStreams();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void ping(boolean ack, int payload1, int payload2) {
            long ackPayload = (long)payload1 << 32 | (long)payload2 & 0xFFFFFFFFL;
            this.logger.logPing(OkHttpFrameLogger.Direction.INBOUND, ackPayload);
            if (!ack) {
                Object object = OkHttpClientTransport.this.lock;
                synchronized (object) {
                    OkHttpClientTransport.this.frameWriter.ping(true, payload1, payload2);
                }
            }
            Http2Ping p = null;
            Object object = OkHttpClientTransport.this.lock;
            synchronized (object) {
                if (OkHttpClientTransport.this.ping != null) {
                    if (OkHttpClientTransport.this.ping.payload() == ackPayload) {
                        p = OkHttpClientTransport.this.ping;
                        OkHttpClientTransport.this.ping = null;
                    } else {
                        log.log(Level.WARNING, String.format(Locale.US, "Received unexpected ping ack. Expecting %d, got %d", OkHttpClientTransport.this.ping.payload(), ackPayload));
                    }
                } else {
                    log.warning("Received unexpected ping ack. No ping outstanding");
                }
            }
            if (p != null) {
                p.complete();
            }
        }

        @Override
        public void ackSettings() {
        }

        @Override
        public void goAway(int lastGoodStreamId, ErrorCode errorCode, ByteString debugData) {
            this.logger.logGoAway(OkHttpFrameLogger.Direction.INBOUND, lastGoodStreamId, errorCode, debugData);
            if (errorCode == ErrorCode.ENHANCE_YOUR_CALM) {
                String data = debugData.utf8();
                log.log(Level.WARNING, String.format("%s: Received GOAWAY with ENHANCE_YOUR_CALM. Debug data: %s", this, data));
                if ("too_many_pings".equals(data)) {
                    OkHttpClientTransport.this.tooManyPingsRunnable.run();
                }
            }
            Status status = GrpcUtil.Http2Error.statusForCode(errorCode.httpCode).augmentDescription("Received Goaway");
            if (debugData.size() > 0) {
                status = status.augmentDescription(debugData.utf8());
            }
            OkHttpClientTransport.this.startGoAway(lastGoodStreamId, null, status);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void pushPromise(int streamId, int promisedStreamId, List<Header> requestHeaders) throws IOException {
            this.logger.logPushPromise(OkHttpFrameLogger.Direction.INBOUND, streamId, promisedStreamId, requestHeaders);
            Object object = OkHttpClientTransport.this.lock;
            synchronized (object) {
                OkHttpClientTransport.this.frameWriter.rstStream(streamId, ErrorCode.PROTOCOL_ERROR);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void windowUpdate(int streamId, long delta) {
            this.logger.logWindowsUpdate(OkHttpFrameLogger.Direction.INBOUND, streamId, delta);
            if (delta == 0L) {
                String errorMsg = "Received 0 flow control window increment.";
                if (streamId == 0) {
                    OkHttpClientTransport.this.onError(ErrorCode.PROTOCOL_ERROR, errorMsg);
                } else {
                    OkHttpClientTransport.this.finishStream(streamId, Status.INTERNAL.withDescription(errorMsg), ClientStreamListener.RpcProgress.PROCESSED, false, ErrorCode.PROTOCOL_ERROR, null);
                }
                return;
            }
            boolean unknownStream = false;
            Object object = OkHttpClientTransport.this.lock;
            synchronized (object) {
                if (streamId == 0) {
                    OkHttpClientTransport.this.outboundFlow.windowUpdate(null, (int)delta);
                    return;
                }
                OkHttpClientStream stream = (OkHttpClientStream)OkHttpClientTransport.this.streams.get(streamId);
                if (stream != null) {
                    OkHttpClientTransport.this.outboundFlow.windowUpdate(stream.transportState().getOutboundFlowState(), (int)delta);
                } else if (!OkHttpClientTransport.this.mayHaveCreatedStream(streamId)) {
                    unknownStream = true;
                }
            }
            if (unknownStream) {
                OkHttpClientTransport.this.onError(ErrorCode.PROTOCOL_ERROR, "Received window_update for unknown stream: " + streamId);
            }
        }

        @Override
        public void priority(int streamId, int streamDependency, int weight, boolean exclusive) {
        }

        @Override
        public void alternateService(int streamId, String origin, ByteString protocol, String host, int port, long maxAge) {
        }
    }
}

