/*
 * Decompiled with CFR 0.152.
 */
package com.mineplex.studio.deps.io.grpc.okhttp;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.mineplex.studio.deps.io.grpc.Attributes;
import com.mineplex.studio.deps.io.grpc.InternalChannelz;
import com.mineplex.studio.deps.io.grpc.InternalLogId;
import com.mineplex.studio.deps.io.grpc.InternalStatus;
import com.mineplex.studio.deps.io.grpc.Metadata;
import com.mineplex.studio.deps.io.grpc.ServerStreamTracer;
import com.mineplex.studio.deps.io.grpc.Status;
import com.mineplex.studio.deps.io.grpc.internal.GrpcUtil;
import com.mineplex.studio.deps.io.grpc.internal.KeepAliveEnforcer;
import com.mineplex.studio.deps.io.grpc.internal.KeepAliveManager;
import com.mineplex.studio.deps.io.grpc.internal.LogExceptionRunnable;
import com.mineplex.studio.deps.io.grpc.internal.MaxConnectionIdleManager;
import com.mineplex.studio.deps.io.grpc.internal.ObjectPool;
import com.mineplex.studio.deps.io.grpc.internal.SerializingExecutor;
import com.mineplex.studio.deps.io.grpc.internal.ServerTransport;
import com.mineplex.studio.deps.io.grpc.internal.ServerTransportListener;
import com.mineplex.studio.deps.io.grpc.internal.StatsTraceContext;
import com.mineplex.studio.deps.io.grpc.internal.TransportTracer;
import com.mineplex.studio.deps.io.grpc.okhttp.AsyncSink;
import com.mineplex.studio.deps.io.grpc.okhttp.ExceptionHandlingFrameWriter;
import com.mineplex.studio.deps.io.grpc.okhttp.ForwardingFrameWriter;
import com.mineplex.studio.deps.io.grpc.okhttp.HandshakerSocketFactory;
import com.mineplex.studio.deps.io.grpc.okhttp.Headers;
import com.mineplex.studio.deps.io.grpc.okhttp.OkHttpFrameLogger;
import com.mineplex.studio.deps.io.grpc.okhttp.OkHttpServerBuilder;
import com.mineplex.studio.deps.io.grpc.okhttp.OkHttpServerStream;
import com.mineplex.studio.deps.io.grpc.okhttp.OkHttpSettingsUtil;
import com.mineplex.studio.deps.io.grpc.okhttp.OutboundFlowController;
import com.mineplex.studio.deps.io.grpc.okhttp.Utils;
import com.mineplex.studio.deps.io.grpc.okhttp.internal.framed.ErrorCode;
import com.mineplex.studio.deps.io.grpc.okhttp.internal.framed.FrameReader;
import com.mineplex.studio.deps.io.grpc.okhttp.internal.framed.FrameWriter;
import com.mineplex.studio.deps.io.grpc.okhttp.internal.framed.Header;
import com.mineplex.studio.deps.io.grpc.okhttp.internal.framed.HeadersMode;
import com.mineplex.studio.deps.io.grpc.okhttp.internal.framed.Http2;
import com.mineplex.studio.deps.io.grpc.okhttp.internal.framed.Settings;
import com.mineplex.studio.deps.io.grpc.okhttp.internal.framed.Variant;
import java.io.IOException;
import java.net.Socket;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import okio.Buffer;
import okio.BufferedSource;
import okio.ByteString;
import okio.Okio;
import okio.Sink;
import okio.Source;

final class OkHttpServerTransport
implements ServerTransport,
ExceptionHandlingFrameWriter.TransportExceptionHandler,
OutboundFlowController.Transport {
    private static final Logger log = Logger.getLogger(OkHttpServerTransport.class.getName());
    private static final int GRACEFUL_SHUTDOWN_PING = 4369;
    private static final long GRACEFUL_SHUTDOWN_PING_TIMEOUT_NANOS = TimeUnit.SECONDS.toNanos(1L);
    private static final int KEEPALIVE_PING = 57005;
    private static final ByteString HTTP_METHOD = ByteString.encodeUtf8((String)":method");
    private static final ByteString CONNECT_METHOD = ByteString.encodeUtf8((String)"CONNECT");
    private static final ByteString POST_METHOD = ByteString.encodeUtf8((String)"POST");
    private static final ByteString SCHEME = ByteString.encodeUtf8((String)":scheme");
    private static final ByteString PATH = ByteString.encodeUtf8((String)":path");
    private static final ByteString AUTHORITY = ByteString.encodeUtf8((String)":authority");
    private static final ByteString CONNECTION = ByteString.encodeUtf8((String)"connection");
    private static final ByteString HOST = ByteString.encodeUtf8((String)"host");
    private static final ByteString TE = ByteString.encodeUtf8((String)"te");
    private static final ByteString TE_TRAILERS = ByteString.encodeUtf8((String)"trailers");
    private static final ByteString CONTENT_TYPE = ByteString.encodeUtf8((String)"content-type");
    private static final ByteString CONTENT_LENGTH = ByteString.encodeUtf8((String)"content-length");
    private final Config config;
    private final Variant variant = new Http2();
    private final TransportTracer tracer;
    private final InternalLogId logId;
    private Socket socket;
    private ServerTransportListener listener;
    private Executor transportExecutor;
    private ScheduledExecutorService scheduledExecutorService;
    private Attributes attributes;
    private KeepAliveManager keepAliveManager;
    private MaxConnectionIdleManager maxConnectionIdleManager;
    private ScheduledFuture<?> maxConnectionAgeMonitor;
    private final KeepAliveEnforcer keepAliveEnforcer;
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private boolean abruptShutdown;
    @GuardedBy(value="lock")
    private boolean gracefulShutdown;
    @GuardedBy(value="lock")
    private boolean handshakeShutdown;
    @GuardedBy(value="lock")
    private InternalChannelz.Security securityInfo;
    @GuardedBy(value="lock")
    private ExceptionHandlingFrameWriter frameWriter;
    @GuardedBy(value="lock")
    private OutboundFlowController outboundFlow;
    @GuardedBy(value="lock")
    private final Map<Integer, StreamState> streams = new TreeMap<Integer, StreamState>();
    @GuardedBy(value="lock")
    private int lastStreamId;
    @GuardedBy(value="lock")
    private int goAwayStreamId = Integer.MAX_VALUE;
    @GuardedBy(value="lock")
    private Status goAwayStatus;
    @GuardedBy(value="lock")
    private ScheduledFuture<?> secondGoawayTimer;
    @GuardedBy(value="lock")
    private ScheduledFuture<?> forcefulCloseTimer;
    @GuardedBy(value="lock")
    private Long gracefulShutdownPeriod = null;

    public OkHttpServerTransport(Config config, Socket bareSocket) {
        this.config = (Config)Preconditions.checkNotNull((Object)config, (Object)"config");
        this.socket = (Socket)Preconditions.checkNotNull((Object)bareSocket, (Object)"bareSocket");
        this.tracer = config.transportTracerFactory.create();
        this.tracer.setFlowControlWindowReader(this::readFlowControlWindow);
        this.logId = InternalLogId.allocate(this.getClass(), this.socket.getRemoteSocketAddress().toString());
        this.transportExecutor = config.transportExecutorPool.getObject();
        this.scheduledExecutorService = config.scheduledExecutorServicePool.getObject();
        this.keepAliveEnforcer = new KeepAliveEnforcer(config.permitKeepAliveWithoutCalls, config.permitKeepAliveTimeInNanos, TimeUnit.NANOSECONDS);
    }

    public void start(ServerTransportListener listener) {
        this.listener = (ServerTransportListener)Preconditions.checkNotNull((Object)listener, (Object)"listener");
        SerializingExecutor serializingExecutor = new SerializingExecutor(this.transportExecutor);
        serializingExecutor.execute(() -> this.startIo(serializingExecutor));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startIo(SerializingExecutor serializingExecutor) {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.socket.setTcpNoDelay(true);
            }
            HandshakerSocketFactory.HandshakeResult result = this.config.handshakerSocketFactory.handshake(this.socket, Attributes.EMPTY);
            Object object2 = this.lock;
            synchronized (object2) {
                this.socket = result.socket;
            }
            this.attributes = result.attributes;
            int maxQueuedControlFrames = 10000;
            AsyncSink asyncSink = AsyncSink.sink(serializingExecutor, this, maxQueuedControlFrames);
            asyncSink.becomeConnected(Okio.sink((Socket)this.socket), this.socket);
            FrameWriter rawFrameWriter = asyncSink.limitControlFramesWriter(this.variant.newWriter(Okio.buffer((Sink)asyncSink), false));
            ForwardingFrameWriter writeMonitoringFrameWriter = new ForwardingFrameWriter(rawFrameWriter){

                @Override
                public void synReply(boolean outFinished, int streamId, List<Header> headerBlock) throws IOException {
                    OkHttpServerTransport.this.keepAliveEnforcer.resetCounters();
                    super.synReply(outFinished, streamId, headerBlock);
                }

                @Override
                public void headers(int streamId, List<Header> headerBlock) throws IOException {
                    OkHttpServerTransport.this.keepAliveEnforcer.resetCounters();
                    super.headers(streamId, headerBlock);
                }

                @Override
                public void data(boolean outFinished, int streamId, Buffer source, int byteCount) throws IOException {
                    OkHttpServerTransport.this.keepAliveEnforcer.resetCounters();
                    super.data(outFinished, streamId, source, byteCount);
                }
            };
            Object object3 = this.lock;
            synchronized (object3) {
                this.securityInfo = result.securityInfo;
                this.frameWriter = new ExceptionHandlingFrameWriter(this, writeMonitoringFrameWriter);
                this.outboundFlow = new OutboundFlowController(this, this.frameWriter);
                this.frameWriter.connectionPreface();
                Settings settings = new Settings();
                OkHttpSettingsUtil.set(settings, 7, this.config.flowControlWindow);
                OkHttpSettingsUtil.set(settings, 6, this.config.maxInboundMetadataSize);
                this.frameWriter.settings(settings);
                if (this.config.flowControlWindow > 65535) {
                    this.frameWriter.windowUpdate(0, this.config.flowControlWindow - 65535);
                }
                this.frameWriter.flush();
            }
            if (this.config.keepAliveTimeNanos != Long.MAX_VALUE) {
                this.keepAliveManager = new KeepAliveManager(new KeepAlivePinger(), this.scheduledExecutorService, this.config.keepAliveTimeNanos, this.config.keepAliveTimeoutNanos, true);
                this.keepAliveManager.onTransportStarted();
            }
            if (this.config.maxConnectionIdleNanos != Long.MAX_VALUE) {
                this.maxConnectionIdleManager = new MaxConnectionIdleManager(this.config.maxConnectionIdleNanos);
                this.maxConnectionIdleManager.start(this::shutdown, this.scheduledExecutorService);
            }
            if (this.config.maxConnectionAgeInNanos != Long.MAX_VALUE) {
                long maxConnectionAgeInNanos = (long)((0.9 + Math.random() * 0.2) * (double)this.config.maxConnectionAgeInNanos);
                this.maxConnectionAgeMonitor = this.scheduledExecutorService.schedule(new LogExceptionRunnable(() -> this.shutdown(this.config.maxConnectionAgeGraceInNanos)), maxConnectionAgeInNanos, TimeUnit.NANOSECONDS);
            }
            this.transportExecutor.execute(new FrameHandler(this.variant.newReader(Okio.buffer((Source)Okio.source((Socket)this.socket)), false)));
        }
        catch (IOException | Error | RuntimeException ex) {
            Object object = this.lock;
            synchronized (object) {
                if (!this.handshakeShutdown) {
                    log.log(Level.INFO, "Socket failed to handshake", ex);
                }
            }
            GrpcUtil.closeQuietly(this.socket);
            this.terminated();
        }
    }

    @Override
    public void shutdown() {
        this.shutdown(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdown(@Nullable Long gracefulShutdownPeriod) {
        Object object = this.lock;
        synchronized (object) {
            if (this.gracefulShutdown || this.abruptShutdown) {
                return;
            }
            this.gracefulShutdown = true;
            this.gracefulShutdownPeriod = gracefulShutdownPeriod;
            if (this.frameWriter == null) {
                this.handshakeShutdown = true;
                GrpcUtil.closeQuietly(this.socket);
            } else {
                this.secondGoawayTimer = this.scheduledExecutorService.schedule(this::triggerGracefulSecondGoaway, GRACEFUL_SHUTDOWN_PING_TIMEOUT_NANOS, TimeUnit.NANOSECONDS);
                this.frameWriter.goAway(Integer.MAX_VALUE, ErrorCode.NO_ERROR, new byte[0]);
                this.frameWriter.ping(false, 0, 4369);
                this.frameWriter.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void triggerGracefulSecondGoaway() {
        Object object = this.lock;
        synchronized (object) {
            if (this.secondGoawayTimer == null) {
                return;
            }
            this.secondGoawayTimer.cancel(false);
            this.secondGoawayTimer = null;
            this.frameWriter.goAway(this.lastStreamId, ErrorCode.NO_ERROR, new byte[0]);
            this.goAwayStreamId = this.lastStreamId;
            if (this.streams.isEmpty()) {
                this.frameWriter.close();
            } else {
                this.frameWriter.flush();
            }
            if (this.gracefulShutdownPeriod != null) {
                this.forcefulCloseTimer = this.scheduledExecutorService.schedule(this::triggerForcefulClose, (long)this.gracefulShutdownPeriod, TimeUnit.NANOSECONDS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdownNow(Status reason) {
        Object object = this.lock;
        synchronized (object) {
            if (this.frameWriter == null) {
                this.handshakeShutdown = true;
                GrpcUtil.closeQuietly(this.socket);
                return;
            }
        }
        this.abruptShutdown(ErrorCode.NO_ERROR, "", reason, true);
    }

    @Override
    public void onException(Throwable failureCause) {
        Preconditions.checkNotNull((Object)failureCause, (Object)"failureCause");
        Status status = Status.UNAVAILABLE.withCause(failureCause);
        this.abruptShutdown(ErrorCode.INTERNAL_ERROR, "I/O failure", status, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void abruptShutdown(ErrorCode errorCode, String moreDetail, Status reason, boolean rstStreams) {
        Object object = this.lock;
        synchronized (object) {
            if (this.abruptShutdown) {
                return;
            }
            this.abruptShutdown = true;
            this.goAwayStatus = reason;
            if (this.secondGoawayTimer != null) {
                this.secondGoawayTimer.cancel(false);
                this.secondGoawayTimer = null;
            }
            for (Map.Entry<Integer, StreamState> entry : this.streams.entrySet()) {
                if (rstStreams) {
                    this.frameWriter.rstStream(entry.getKey(), ErrorCode.CANCEL);
                }
                entry.getValue().transportReportStatus(reason);
            }
            this.streams.clear();
            this.frameWriter.goAway(this.lastStreamId, errorCode, moreDetail.getBytes(GrpcUtil.US_ASCII));
            this.goAwayStreamId = this.lastStreamId;
            this.frameWriter.close();
            this.forcefulCloseTimer = this.scheduledExecutorService.schedule(this::triggerForcefulClose, 1L, TimeUnit.SECONDS);
        }
    }

    private void triggerForcefulClose() {
        GrpcUtil.closeQuietly(this.socket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void terminated() {
        Object object = this.lock;
        synchronized (object) {
            if (this.forcefulCloseTimer != null) {
                this.forcefulCloseTimer.cancel(false);
                this.forcefulCloseTimer = null;
            }
        }
        if (this.keepAliveManager != null) {
            this.keepAliveManager.onTransportTermination();
        }
        if (this.maxConnectionIdleManager != null) {
            this.maxConnectionIdleManager.onTransportTermination();
        }
        if (this.maxConnectionAgeMonitor != null) {
            this.maxConnectionAgeMonitor.cancel(false);
        }
        this.transportExecutor = this.config.transportExecutorPool.returnObject(this.transportExecutor);
        this.scheduledExecutorService = this.config.scheduledExecutorServicePool.returnObject(this.scheduledExecutorService);
        this.listener.transportTerminated();
    }

    @Override
    public ScheduledExecutorService getScheduledExecutorService() {
        return this.scheduledExecutorService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListenableFuture<InternalChannelz.SocketStats> getStats() {
        Object object = this.lock;
        synchronized (object) {
            return Futures.immediateFuture((Object)new InternalChannelz.SocketStats(this.tracer.getStats(), this.socket.getLocalSocketAddress(), this.socket.getRemoteSocketAddress(), Utils.getSocketOptions(this.socket), this.securityInfo));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TransportTracer.FlowControlWindows readFlowControlWindow() {
        Object object = this.lock;
        synchronized (object) {
            long local = this.outboundFlow == null ? -1L : (long)this.outboundFlow.windowUpdate(null, 0);
            long remote = (long)((float)this.config.flowControlWindow * 0.5f);
            return new TransportTracer.FlowControlWindows(local, remote);
        }
    }

    @Override
    public InternalLogId getLogId() {
        return this.logId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutboundFlowController.StreamState[] getActiveStreams() {
        Object object = this.lock;
        synchronized (object) {
            OutboundFlowController.StreamState[] flowStreams = new OutboundFlowController.StreamState[this.streams.size()];
            int i = 0;
            for (StreamState stream : this.streams.values()) {
                flowStreams[i++] = stream.getOutboundFlowState();
            }
            return flowStreams;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void streamClosed(int streamId, boolean flush) {
        Object object = this.lock;
        synchronized (object) {
            this.streams.remove(streamId);
            if (this.streams.isEmpty()) {
                this.keepAliveEnforcer.onTransportIdle();
                if (this.maxConnectionIdleManager != null) {
                    this.maxConnectionIdleManager.onTransportIdle();
                }
            }
            if (this.gracefulShutdown && this.streams.isEmpty()) {
                this.frameWriter.close();
            } else if (flush) {
                this.frameWriter.flush();
            }
        }
    }

    private static String asciiString(ByteString value) {
        for (int i = 0; i < value.size(); ++i) {
            if (value.getByte(i) >= 0) continue;
            return value.string(GrpcUtil.US_ASCII);
        }
        return value.utf8();
    }

    private static int headerFind(List<Header> header, ByteString key, int startIndex) {
        for (int i = startIndex; i < header.size(); ++i) {
            if (!header.get((int)i).name.equals((Object)key)) continue;
            return i;
        }
        return -1;
    }

    private static boolean headerContains(List<Header> header, ByteString key) {
        return OkHttpServerTransport.headerFind(header, key, 0) != -1;
    }

    private static void headerRemove(List<Header> header, ByteString key) {
        int i = 0;
        while ((i = OkHttpServerTransport.headerFind(header, key, i)) != -1) {
            header.remove(i);
        }
    }

    private static ByteString headerGetRequiredSingle(List<Header> header, ByteString key) {
        int i = OkHttpServerTransport.headerFind(header, key, 0);
        if (i == -1) {
            return null;
        }
        if (OkHttpServerTransport.headerFind(header, key, i + 1) != -1) {
            return null;
        }
        return header.get((int)i).value;
    }

    static class Http2ErrorStreamState
    implements StreamState,
    OutboundFlowController.Stream {
        private final int streamId;
        private final Object lock;
        private final OutboundFlowController.StreamState outboundFlowState;
        @GuardedBy(value="lock")
        private int window;
        @GuardedBy(value="lock")
        private boolean receivedEndOfStream;

        Http2ErrorStreamState(int streamId, Object lock, OutboundFlowController outboundFlow, int initialWindowSize) {
            this.streamId = streamId;
            this.lock = lock;
            this.outboundFlowState = outboundFlow.createState(this, streamId);
            this.window = initialWindowSize;
        }

        @Override
        public void onSentBytes(int frameBytes) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void inboundDataReceived(Buffer frame, int dataLength, int paddingLength, boolean endOfStream) {
            Object object = this.lock;
            synchronized (object) {
                if (endOfStream) {
                    this.receivedEndOfStream = true;
                }
                this.window -= dataLength + paddingLength;
                try {
                    frame.skip(frame.size());
                }
                catch (IOException ex) {
                    throw new AssertionError((Object)ex);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasReceivedEndOfStream() {
            Object object = this.lock;
            synchronized (object) {
                return this.receivedEndOfStream;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int inboundWindowAvailable() {
            Object object = this.lock;
            synchronized (object) {
                return this.window;
            }
        }

        @Override
        public void transportReportStatus(Status status) {
        }

        @Override
        public void inboundRstReceived(Status status) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public OutboundFlowController.StreamState getOutboundFlowState() {
            Object object = this.lock;
            synchronized (object) {
                return this.outboundFlowState;
            }
        }
    }

    static interface StreamState {
        public void inboundDataReceived(Buffer var1, int var2, int var3, boolean var4);

        public boolean hasReceivedEndOfStream();

        public int inboundWindowAvailable();

        public void transportReportStatus(Status var1);

        public void inboundRstReceived(Status var1);

        public OutboundFlowController.StreamState getOutboundFlowState();
    }

    private final class KeepAlivePinger
    implements KeepAliveManager.KeepAlivePinger {
        private KeepAlivePinger() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void ping() {
            Object object = OkHttpServerTransport.this.lock;
            synchronized (object) {
                OkHttpServerTransport.this.frameWriter.ping(false, 0, 57005);
                OkHttpServerTransport.this.frameWriter.flush();
            }
            OkHttpServerTransport.this.tracer.reportKeepAliveSent();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPingTimeout() {
            Object object = OkHttpServerTransport.this.lock;
            synchronized (object) {
                OkHttpServerTransport.this.goAwayStatus = Status.UNAVAILABLE.withDescription("Keepalive failed. Considering connection dead");
                GrpcUtil.closeQuietly(OkHttpServerTransport.this.socket);
            }
        }
    }

    class FrameHandler
    implements FrameReader.Handler,
    Runnable {
        private final OkHttpFrameLogger frameLogger = new OkHttpFrameLogger(Level.FINE, OkHttpServerTransport.class);
        private final FrameReader frameReader;
        private boolean receivedSettings;
        private int connectionUnacknowledgedBytesRead;

        public FrameHandler(FrameReader frameReader) {
            this.frameReader = frameReader;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String threadName = Thread.currentThread().getName();
            Thread.currentThread().setName("OkHttpServerTransport");
            try {
                Status status;
                this.frameReader.readConnectionPreface();
                if (!this.frameReader.nextFrame(this)) {
                    this.connectionError(ErrorCode.INTERNAL_ERROR, "Failed to read initial SETTINGS");
                    return;
                }
                if (!this.receivedSettings) {
                    this.connectionError(ErrorCode.PROTOCOL_ERROR, "First HTTP/2 frame must be SETTINGS. RFC7540 section 3.5");
                    return;
                }
                while (this.frameReader.nextFrame(this)) {
                    if (OkHttpServerTransport.this.keepAliveManager == null) continue;
                    OkHttpServerTransport.this.keepAliveManager.onDataReceived();
                }
                Object object = OkHttpServerTransport.this.lock;
                synchronized (object) {
                    status = OkHttpServerTransport.this.goAwayStatus;
                }
                if (status == null) {
                    status = Status.UNAVAILABLE.withDescription("TCP connection closed or IOException");
                }
                OkHttpServerTransport.this.abruptShutdown(ErrorCode.INTERNAL_ERROR, "I/O failure", status, false);
            }
            catch (Throwable t) {
                log.log(Level.WARNING, "Error decoding HTTP/2 frames", t);
                OkHttpServerTransport.this.abruptShutdown(ErrorCode.INTERNAL_ERROR, "Error in frame decoder", Status.INTERNAL.withDescription("Error decoding HTTP/2 frames").withCause(t), false);
            }
            finally {
                try {
                    GrpcUtil.exhaust(OkHttpServerTransport.this.socket.getInputStream());
                }
                catch (IOException iOException) {}
                GrpcUtil.closeQuietly(OkHttpServerTransport.this.socket);
                OkHttpServerTransport.this.terminated();
                Thread.currentThread().setName(threadName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void headers(boolean outFinished, boolean inFinished, int streamId, int associatedStreamId, List<Header> headerBlock, HeadersMode headersMode) {
            int i2;
            boolean newStream;
            this.frameLogger.logHeaders(OkHttpFrameLogger.Direction.INBOUND, streamId, headerBlock, inFinished);
            if ((streamId & 1) == 0) {
                this.connectionError(ErrorCode.PROTOCOL_ERROR, "Clients cannot open even numbered streams. RFC7540 section 5.1.1");
                return;
            }
            Object object = OkHttpServerTransport.this.lock;
            synchronized (object) {
                if (streamId > OkHttpServerTransport.this.goAwayStreamId) {
                    return;
                }
                boolean bl = newStream = streamId > OkHttpServerTransport.this.lastStreamId;
                if (newStream) {
                    OkHttpServerTransport.this.lastStreamId = streamId;
                }
            }
            int metadataSize = this.headerBlockSize(headerBlock);
            if (metadataSize > ((OkHttpServerTransport)OkHttpServerTransport.this).config.maxInboundMetadataSize) {
                this.respondWithHttpError(streamId, inFinished, 431, Status.Code.RESOURCE_EXHAUSTED, String.format(Locale.US, "Request metadata larger than %d: %d", ((OkHttpServerTransport)OkHttpServerTransport.this).config.maxInboundMetadataSize, metadataSize));
                return;
            }
            OkHttpServerTransport.headerRemove(headerBlock, ByteString.EMPTY);
            ByteString httpMethod = null;
            ByteString scheme = null;
            ByteString path = null;
            ByteString authority = null;
            while (headerBlock.size() > 0 && headerBlock.get((int)0).name.getByte(0) == 58) {
                Header header = headerBlock.remove(0);
                if (HTTP_METHOD.equals((Object)header.name) && httpMethod == null) {
                    httpMethod = header.value;
                    continue;
                }
                if (SCHEME.equals((Object)header.name) && scheme == null) {
                    scheme = header.value;
                    continue;
                }
                if (PATH.equals((Object)header.name) && path == null) {
                    path = header.value;
                    continue;
                }
                if (AUTHORITY.equals((Object)header.name) && authority == null) {
                    authority = header.value;
                    continue;
                }
                this.streamError(streamId, ErrorCode.PROTOCOL_ERROR, "Unexpected pseudo header. RFC7540 section 8.1.2.1");
                return;
            }
            for (i2 = 0; i2 < headerBlock.size(); ++i2) {
                if (headerBlock.get((int)i2).name.getByte(0) != 58) continue;
                this.streamError(streamId, ErrorCode.PROTOCOL_ERROR, "Pseudo header not before regular headers. RFC7540 section 8.1.2.1");
                return;
            }
            if (!CONNECT_METHOD.equals(httpMethod) && newStream && (httpMethod == null || scheme == null || path == null)) {
                this.streamError(streamId, ErrorCode.PROTOCOL_ERROR, "Missing required pseudo header. RFC7540 section 8.1.2.3");
                return;
            }
            if (OkHttpServerTransport.headerContains(headerBlock, CONNECTION)) {
                this.streamError(streamId, ErrorCode.PROTOCOL_ERROR, "Connection-specific headers not permitted. RFC7540 section 8.1.2.2");
                return;
            }
            if (!newStream) {
                if (inFinished) {
                    Object i2 = OkHttpServerTransport.this.lock;
                    synchronized (i2) {
                        StreamState stream = (StreamState)OkHttpServerTransport.this.streams.get(streamId);
                        if (stream == null) {
                            this.streamError(streamId, ErrorCode.STREAM_CLOSED, "Received headers for closed stream");
                            return;
                        }
                        if (stream.hasReceivedEndOfStream()) {
                            this.streamError(streamId, ErrorCode.STREAM_CLOSED, "Received HEADERS for half-closed (remote) stream. RFC7540 section 5.1");
                            return;
                        }
                        stream.inboundDataReceived(new Buffer(), 0, 0, true);
                        return;
                    }
                }
                this.streamError(streamId, ErrorCode.PROTOCOL_ERROR, "Headers disallowed in the middle of the stream. RFC7540 section 8.1");
                return;
            }
            if (authority == null && (i2 = OkHttpServerTransport.headerFind(headerBlock, HOST, 0)) != -1) {
                if (OkHttpServerTransport.headerFind(headerBlock, HOST, i2 + 1) != -1) {
                    this.respondWithHttpError(streamId, inFinished, 400, Status.Code.INTERNAL, "Multiple host headers disallowed. RFC7230 section 5.4");
                    return;
                }
                authority = headerBlock.get((int)i2).value;
            }
            OkHttpServerTransport.headerRemove(headerBlock, HOST);
            if (path.size() == 0 || path.getByte(0) != 47) {
                this.respondWithHttpError(streamId, inFinished, 404, Status.Code.UNIMPLEMENTED, "Expected path to start with /: " + OkHttpServerTransport.asciiString(path));
                return;
            }
            String method = OkHttpServerTransport.asciiString(path).substring(1);
            ByteString contentType = OkHttpServerTransport.headerGetRequiredSingle(headerBlock, CONTENT_TYPE);
            if (contentType == null) {
                this.respondWithHttpError(streamId, inFinished, 415, Status.Code.INTERNAL, "Content-Type is missing or duplicated");
                return;
            }
            String contentTypeString = OkHttpServerTransport.asciiString(contentType);
            if (!GrpcUtil.isGrpcContentType(contentTypeString)) {
                this.respondWithHttpError(streamId, inFinished, 415, Status.Code.INTERNAL, "Content-Type is not supported: " + contentTypeString);
                return;
            }
            if (!POST_METHOD.equals((Object)httpMethod)) {
                this.respondWithHttpError(streamId, inFinished, 405, Status.Code.INTERNAL, "HTTP Method is not supported: " + OkHttpServerTransport.asciiString(httpMethod));
                return;
            }
            ByteString te = OkHttpServerTransport.headerGetRequiredSingle(headerBlock, TE);
            if (!TE_TRAILERS.equals((Object)te)) {
                this.respondWithGrpcError(streamId, inFinished, Status.Code.INTERNAL, String.format("Expected header TE: %s, but %s is received. Some intermediate proxy may not support trailers", OkHttpServerTransport.asciiString(TE_TRAILERS), te == null ? "<missing>" : OkHttpServerTransport.asciiString(te)));
                return;
            }
            OkHttpServerTransport.headerRemove(headerBlock, CONTENT_LENGTH);
            Metadata metadata = Utils.convertHeaders(headerBlock);
            StatsTraceContext statsTraceCtx = StatsTraceContext.newServerContext(((OkHttpServerTransport)OkHttpServerTransport.this).config.streamTracerFactories, method, metadata);
            Object object2 = OkHttpServerTransport.this.lock;
            synchronized (object2) {
                OkHttpServerStream.TransportState stream = new OkHttpServerStream.TransportState(OkHttpServerTransport.this, streamId, ((OkHttpServerTransport)OkHttpServerTransport.this).config.maxInboundMessageSize, statsTraceCtx, OkHttpServerTransport.this.lock, OkHttpServerTransport.this.frameWriter, OkHttpServerTransport.this.outboundFlow, ((OkHttpServerTransport)OkHttpServerTransport.this).config.flowControlWindow, OkHttpServerTransport.this.tracer, method);
                OkHttpServerStream streamForApp = new OkHttpServerStream(stream, OkHttpServerTransport.this.attributes, authority == null ? null : OkHttpServerTransport.asciiString(authority), statsTraceCtx, OkHttpServerTransport.this.tracer);
                if (OkHttpServerTransport.this.streams.isEmpty()) {
                    OkHttpServerTransport.this.keepAliveEnforcer.onTransportActive();
                    if (OkHttpServerTransport.this.maxConnectionIdleManager != null) {
                        OkHttpServerTransport.this.maxConnectionIdleManager.onTransportActive();
                    }
                }
                OkHttpServerTransport.this.streams.put(streamId, stream);
                OkHttpServerTransport.this.listener.streamCreated(streamForApp, method, metadata);
                stream.onStreamAllocated();
                if (inFinished) {
                    stream.inboundDataReceived(new Buffer(), 0, 0, inFinished);
                }
            }
        }

        private int headerBlockSize(List<Header> headerBlock) {
            long size = 0L;
            for (int i = 0; i < headerBlock.size(); ++i) {
                Header header = headerBlock.get(i);
                size += (long)(32 + header.name.size() + header.value.size());
            }
            size = Math.min(size, Integer.MAX_VALUE);
            return (int)size;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void data(boolean inFinished, int streamId, BufferedSource in, int length, int paddedLength) throws IOException {
            this.frameLogger.logData(OkHttpFrameLogger.Direction.INBOUND, streamId, in.getBuffer(), length, inFinished);
            if (streamId == 0) {
                this.connectionError(ErrorCode.PROTOCOL_ERROR, "Stream 0 is reserved for control messages. RFC7540 section 5.1.1");
                return;
            }
            if ((streamId & 1) == 0) {
                this.connectionError(ErrorCode.PROTOCOL_ERROR, "Clients cannot open even numbered streams. RFC7540 section 5.1.1");
                return;
            }
            in.require((long)length);
            Object object = OkHttpServerTransport.this.lock;
            synchronized (object) {
                StreamState stream = (StreamState)OkHttpServerTransport.this.streams.get(streamId);
                if (stream == null) {
                    in.skip((long)length);
                    this.streamError(streamId, ErrorCode.STREAM_CLOSED, "Received data for closed stream");
                    return;
                }
                if (stream.hasReceivedEndOfStream()) {
                    in.skip((long)length);
                    this.streamError(streamId, ErrorCode.STREAM_CLOSED, "Received DATA for half-closed (remote) stream. RFC7540 section 5.1");
                    return;
                }
                if (stream.inboundWindowAvailable() < paddedLength) {
                    in.skip((long)length);
                    this.streamError(streamId, ErrorCode.FLOW_CONTROL_ERROR, "Received DATA size exceeded window size. RFC7540 section 6.9");
                    return;
                }
                Buffer buf = new Buffer();
                buf.write(in.getBuffer(), (long)length);
                stream.inboundDataReceived(buf, length, paddedLength - length, inFinished);
            }
            this.connectionUnacknowledgedBytesRead += paddedLength;
            if ((float)this.connectionUnacknowledgedBytesRead >= (float)((OkHttpServerTransport)OkHttpServerTransport.this).config.flowControlWindow * 0.5f) {
                object = OkHttpServerTransport.this.lock;
                synchronized (object) {
                    OkHttpServerTransport.this.frameWriter.windowUpdate(0, this.connectionUnacknowledgedBytesRead);
                    OkHttpServerTransport.this.frameWriter.flush();
                }
                this.connectionUnacknowledgedBytesRead = 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void rstStream(int streamId, ErrorCode errorCode) {
            this.frameLogger.logRstStream(OkHttpFrameLogger.Direction.INBOUND, streamId, errorCode);
            if (!(ErrorCode.NO_ERROR.equals((Object)errorCode) || ErrorCode.CANCEL.equals((Object)errorCode) || ErrorCode.STREAM_CLOSED.equals((Object)errorCode))) {
                log.log(Level.INFO, "Received RST_STREAM: " + (Object)((Object)errorCode));
            }
            Status status = GrpcUtil.Http2Error.statusForCode(errorCode.httpCode).withDescription("RST_STREAM");
            Object object = OkHttpServerTransport.this.lock;
            synchronized (object) {
                StreamState stream = (StreamState)OkHttpServerTransport.this.streams.get(streamId);
                if (stream != null) {
                    stream.inboundRstReceived(status);
                    OkHttpServerTransport.this.streamClosed(streamId, false);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void settings(boolean clearPrevious, Settings settings) {
            this.frameLogger.logSettings(OkHttpFrameLogger.Direction.INBOUND, settings);
            Object object = OkHttpServerTransport.this.lock;
            synchronized (object) {
                boolean outboundWindowSizeIncreased = false;
                if (OkHttpSettingsUtil.isSet(settings, 7)) {
                    int initialWindowSize = OkHttpSettingsUtil.get(settings, 7);
                    outboundWindowSizeIncreased = OkHttpServerTransport.this.outboundFlow.initialOutboundWindowSize(initialWindowSize);
                }
                OkHttpServerTransport.this.frameWriter.ackSettings(settings);
                OkHttpServerTransport.this.frameWriter.flush();
                if (!this.receivedSettings) {
                    this.receivedSettings = true;
                    OkHttpServerTransport.this.attributes = OkHttpServerTransport.this.listener.transportReady(OkHttpServerTransport.this.attributes);
                }
                if (outboundWindowSizeIncreased) {
                    OkHttpServerTransport.this.outboundFlow.writeStreams();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void ping(boolean ack, int payload1, int payload2) {
            if (!OkHttpServerTransport.this.keepAliveEnforcer.pingAcceptable()) {
                OkHttpServerTransport.this.abruptShutdown(ErrorCode.ENHANCE_YOUR_CALM, "too_many_pings", Status.RESOURCE_EXHAUSTED.withDescription("Too many pings from client"), false);
                return;
            }
            long payload = (long)payload1 << 32 | (long)payload2 & 0xFFFFFFFFL;
            if (!ack) {
                this.frameLogger.logPing(OkHttpFrameLogger.Direction.INBOUND, payload);
                Object object = OkHttpServerTransport.this.lock;
                synchronized (object) {
                    OkHttpServerTransport.this.frameWriter.ping(true, payload1, payload2);
                    OkHttpServerTransport.this.frameWriter.flush();
                }
            } else {
                this.frameLogger.logPingAck(OkHttpFrameLogger.Direction.INBOUND, payload);
                if (57005L == payload) {
                    return;
                }
                if (4369L == payload) {
                    OkHttpServerTransport.this.triggerGracefulSecondGoaway();
                    return;
                }
                log.log(Level.INFO, "Received unexpected ping ack: " + payload);
            }
        }

        @Override
        public void ackSettings() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void goAway(int lastGoodStreamId, ErrorCode errorCode, ByteString debugData) {
            this.frameLogger.logGoAway(OkHttpFrameLogger.Direction.INBOUND, lastGoodStreamId, errorCode, debugData);
            String description = String.format("Received GOAWAY: %s '%s'", new Object[]{errorCode, debugData.utf8()});
            Status status = GrpcUtil.Http2Error.statusForCode(errorCode.httpCode).withDescription(description);
            if (!ErrorCode.NO_ERROR.equals((Object)errorCode)) {
                log.log(Level.WARNING, "Received GOAWAY: {0} {1}", new Object[]{errorCode, debugData.utf8()});
            }
            Object object = OkHttpServerTransport.this.lock;
            synchronized (object) {
                OkHttpServerTransport.this.goAwayStatus = status;
            }
        }

        @Override
        public void pushPromise(int streamId, int promisedStreamId, List<Header> requestHeaders) throws IOException {
            this.frameLogger.logPushPromise(OkHttpFrameLogger.Direction.INBOUND, streamId, promisedStreamId, requestHeaders);
            this.connectionError(ErrorCode.PROTOCOL_ERROR, "PUSH_PROMISE only allowed on peer-initiated streams. RFC7540 section 6.6");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void windowUpdate(int streamId, long delta) {
            this.frameLogger.logWindowsUpdate(OkHttpFrameLogger.Direction.INBOUND, streamId, delta);
            Object object = OkHttpServerTransport.this.lock;
            synchronized (object) {
                if (streamId == 0) {
                    OkHttpServerTransport.this.outboundFlow.windowUpdate(null, (int)delta);
                } else {
                    StreamState stream = (StreamState)OkHttpServerTransport.this.streams.get(streamId);
                    if (stream != null) {
                        OkHttpServerTransport.this.outboundFlow.windowUpdate(stream.getOutboundFlowState(), (int)delta);
                    }
                }
            }
        }

        @Override
        public void priority(int streamId, int streamDependency, int weight, boolean exclusive) {
            this.frameLogger.logPriority(OkHttpFrameLogger.Direction.INBOUND, streamId, streamDependency, weight, exclusive);
        }

        @Override
        public void alternateService(int streamId, String origin, ByteString protocol, String host, int port, long maxAge) {
        }

        private void connectionError(ErrorCode errorCode, String moreDetail) {
            Status status = GrpcUtil.Http2Error.statusForCode(errorCode.httpCode).withDescription(String.format("HTTP2 connection error: %s '%s'", new Object[]{errorCode, moreDetail}));
            OkHttpServerTransport.this.abruptShutdown(errorCode, moreDetail, status, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void streamError(int streamId, ErrorCode errorCode, String reason) {
            if (errorCode == ErrorCode.PROTOCOL_ERROR) {
                log.log(Level.FINE, "Responding with RST_STREAM {0}: {1}", new Object[]{errorCode, reason});
            }
            Object object = OkHttpServerTransport.this.lock;
            synchronized (object) {
                OkHttpServerTransport.this.frameWriter.rstStream(streamId, errorCode);
                OkHttpServerTransport.this.frameWriter.flush();
                StreamState stream = (StreamState)OkHttpServerTransport.this.streams.get(streamId);
                if (stream != null) {
                    stream.transportReportStatus(Status.INTERNAL.withDescription(String.format("Responded with RST_STREAM %s: %s", new Object[]{errorCode, reason})));
                    OkHttpServerTransport.this.streamClosed(streamId, false);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void respondWithHttpError(int streamId, boolean inFinished, int httpCode, Status.Code statusCode, String msg) {
            Metadata metadata = new Metadata();
            metadata.put(InternalStatus.CODE_KEY, statusCode.toStatus());
            metadata.put(InternalStatus.MESSAGE_KEY, msg);
            List<Header> headers = Headers.createHttpResponseHeaders(httpCode, "text/plain; charset=utf-8", metadata);
            Buffer data = new Buffer().writeUtf8(msg);
            Object object = OkHttpServerTransport.this.lock;
            synchronized (object) {
                Http2ErrorStreamState stream = new Http2ErrorStreamState(streamId, OkHttpServerTransport.this.lock, OkHttpServerTransport.this.outboundFlow, ((OkHttpServerTransport)OkHttpServerTransport.this).config.flowControlWindow);
                if (OkHttpServerTransport.this.streams.isEmpty()) {
                    OkHttpServerTransport.this.keepAliveEnforcer.onTransportActive();
                    if (OkHttpServerTransport.this.maxConnectionIdleManager != null) {
                        OkHttpServerTransport.this.maxConnectionIdleManager.onTransportActive();
                    }
                }
                OkHttpServerTransport.this.streams.put(streamId, stream);
                if (inFinished) {
                    stream.inboundDataReceived(new Buffer(), 0, 0, true);
                }
                OkHttpServerTransport.this.frameWriter.headers(streamId, headers);
                OkHttpServerTransport.this.outboundFlow.data(true, stream.getOutboundFlowState(), data, true);
                OkHttpServerTransport.this.outboundFlow.notifyWhenNoPendingData(stream.getOutboundFlowState(), () -> this.rstOkAtEndOfHttpError(stream));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void rstOkAtEndOfHttpError(Http2ErrorStreamState stream) {
            Object object = OkHttpServerTransport.this.lock;
            synchronized (object) {
                if (!stream.hasReceivedEndOfStream()) {
                    OkHttpServerTransport.this.frameWriter.rstStream(stream.streamId, ErrorCode.NO_ERROR);
                }
                OkHttpServerTransport.this.streamClosed(stream.streamId, true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void respondWithGrpcError(int streamId, boolean inFinished, Status.Code statusCode, String msg) {
            Metadata metadata = new Metadata();
            metadata.put(InternalStatus.CODE_KEY, statusCode.toStatus());
            metadata.put(InternalStatus.MESSAGE_KEY, msg);
            List<Header> headers = Headers.createResponseTrailers(metadata, false);
            Object object = OkHttpServerTransport.this.lock;
            synchronized (object) {
                OkHttpServerTransport.this.frameWriter.synReply(true, streamId, headers);
                if (!inFinished) {
                    OkHttpServerTransport.this.frameWriter.rstStream(streamId, ErrorCode.NO_ERROR);
                }
                OkHttpServerTransport.this.frameWriter.flush();
            }
        }
    }

    static final class Config {
        final List<? extends ServerStreamTracer.Factory> streamTracerFactories;
        final ObjectPool<Executor> transportExecutorPool;
        final ObjectPool<ScheduledExecutorService> scheduledExecutorServicePool;
        final TransportTracer.Factory transportTracerFactory;
        final HandshakerSocketFactory handshakerSocketFactory;
        final long keepAliveTimeNanos;
        final long keepAliveTimeoutNanos;
        final int flowControlWindow;
        final int maxInboundMessageSize;
        final int maxInboundMetadataSize;
        final long maxConnectionIdleNanos;
        final boolean permitKeepAliveWithoutCalls;
        final long permitKeepAliveTimeInNanos;
        final long maxConnectionAgeInNanos;
        final long maxConnectionAgeGraceInNanos;

        public Config(OkHttpServerBuilder builder, List<? extends ServerStreamTracer.Factory> streamTracerFactories) {
            this.streamTracerFactories = (List)Preconditions.checkNotNull(streamTracerFactories, (Object)"streamTracerFactories");
            this.transportExecutorPool = (ObjectPool)Preconditions.checkNotNull(builder.transportExecutorPool, (Object)"transportExecutorPool");
            this.scheduledExecutorServicePool = (ObjectPool)Preconditions.checkNotNull(builder.scheduledExecutorServicePool, (Object)"scheduledExecutorServicePool");
            this.transportTracerFactory = (TransportTracer.Factory)Preconditions.checkNotNull((Object)builder.transportTracerFactory, (Object)"transportTracerFactory");
            this.handshakerSocketFactory = (HandshakerSocketFactory)Preconditions.checkNotNull((Object)builder.handshakerSocketFactory, (Object)"handshakerSocketFactory");
            this.keepAliveTimeNanos = builder.keepAliveTimeNanos;
            this.keepAliveTimeoutNanos = builder.keepAliveTimeoutNanos;
            this.flowControlWindow = builder.flowControlWindow;
            this.maxInboundMessageSize = builder.maxInboundMessageSize;
            this.maxInboundMetadataSize = builder.maxInboundMetadataSize;
            this.maxConnectionIdleNanos = builder.maxConnectionIdleInNanos;
            this.permitKeepAliveWithoutCalls = builder.permitKeepAliveWithoutCalls;
            this.permitKeepAliveTimeInNanos = builder.permitKeepAliveTimeInNanos;
            this.maxConnectionAgeInNanos = builder.maxConnectionAgeInNanos;
            this.maxConnectionAgeGraceInNanos = builder.maxConnectionAgeGraceInNanos;
        }
    }
}

