/*
 * Decompiled with CFR 0.152.
 */
package com.mineplex.studio.deps.io.grpc.okhttp;

import com.google.common.base.Preconditions;
import com.mineplex.studio.deps.io.grpc.okhttp.internal.framed.FrameWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import javax.annotation.Nullable;
import okio.Buffer;

class OutboundFlowController {
    private final Transport transport;
    private final FrameWriter frameWriter;
    private int initialWindowSize;
    private final StreamState connectionState;

    public OutboundFlowController(Transport transport, FrameWriter frameWriter) {
        this.transport = (Transport)Preconditions.checkNotNull((Object)transport, (Object)"transport");
        this.frameWriter = (FrameWriter)Preconditions.checkNotNull((Object)frameWriter, (Object)"frameWriter");
        this.initialWindowSize = 65535;
        this.connectionState = new StreamState(0, 65535, null);
    }

    public boolean initialOutboundWindowSize(int newWindowSize) {
        if (newWindowSize < 0) {
            throw new IllegalArgumentException("Invalid initial window size: " + newWindowSize);
        }
        int delta = newWindowSize - this.initialWindowSize;
        this.initialWindowSize = newWindowSize;
        for (StreamState state : this.transport.getActiveStreams()) {
            state.incrementStreamWindow(delta);
        }
        return delta > 0;
    }

    public int windowUpdate(@Nullable StreamState state, int delta) {
        int updatedWindow;
        if (state == null) {
            updatedWindow = this.connectionState.incrementStreamWindow(delta);
            this.writeStreams();
        } else {
            updatedWindow = state.incrementStreamWindow(delta);
            WriteStatus writeStatus = new WriteStatus();
            state.writeBytes(state.writableWindow(), writeStatus);
            if (writeStatus.hasWritten()) {
                this.flush();
            }
        }
        return updatedWindow;
    }

    public void data(boolean outFinished, StreamState state, Buffer source, boolean flush) {
        Preconditions.checkNotNull((Object)source, (Object)"source");
        int window = state.writableWindow();
        boolean framesAlreadyQueued = state.hasPendingData();
        int size = (int)source.size();
        if (!framesAlreadyQueued && window >= size) {
            state.write(source, size, outFinished);
        } else {
            if (!framesAlreadyQueued && window > 0) {
                state.write(source, window, false);
            }
            state.enqueueData(source, (int)source.size(), outFinished);
        }
        if (flush) {
            this.flush();
        }
    }

    public void notifyWhenNoPendingData(StreamState state, Runnable noPendingDataRunnable) {
        Preconditions.checkNotNull((Object)noPendingDataRunnable, (Object)"noPendingDataRunnable");
        if (state.hasPendingData()) {
            state.notifyWhenNoPendingData(noPendingDataRunnable);
        } else {
            noPendingDataRunnable.run();
        }
    }

    public void flush() {
        try {
            this.frameWriter.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public StreamState createState(Stream stream, int streamId) {
        return new StreamState(streamId, this.initialWindowSize, (Stream)Preconditions.checkNotNull((Object)stream, (Object)"stream"));
    }

    public void writeStreams() {
        StreamState[] states = this.transport.getActiveStreams();
        Collections.shuffle(Arrays.asList(states));
        int connectionWindow = this.connectionState.window();
        int numStreams = states.length;
        while (numStreams > 0 && connectionWindow > 0) {
            int nextNumStreams = 0;
            int windowSlice = (int)Math.ceil((float)connectionWindow / (float)numStreams);
            for (int index = 0; index < numStreams && connectionWindow > 0; ++index) {
                StreamState state = states[index];
                int bytesForStream = Math.min(connectionWindow, Math.min(state.unallocatedBytes(), windowSlice));
                if (bytesForStream > 0) {
                    state.allocateBytes(bytesForStream);
                    connectionWindow -= bytesForStream;
                }
                if (state.unallocatedBytes() <= 0) continue;
                states[nextNumStreams++] = state;
            }
            numStreams = nextNumStreams;
        }
        WriteStatus writeStatus = new WriteStatus();
        for (StreamState state : this.transport.getActiveStreams()) {
            state.writeBytes(state.allocatedBytes(), writeStatus);
            state.clearAllocatedBytes();
        }
        if (writeStatus.hasWritten()) {
            this.flush();
        }
    }

    public final class StreamState {
        private final Buffer pendingWriteBuffer = new Buffer();
        private Runnable noPendingDataRunnable;
        private final int streamId;
        private int window;
        private int allocatedBytes;
        private final Stream stream;
        private boolean pendingBufferHasEndOfStream = false;

        StreamState(int streamId, int initialWindowSize, Stream stream) {
            this.streamId = streamId;
            this.window = initialWindowSize;
            this.stream = stream;
        }

        int window() {
            return this.window;
        }

        void allocateBytes(int bytes) {
            this.allocatedBytes += bytes;
        }

        int allocatedBytes() {
            return this.allocatedBytes;
        }

        int unallocatedBytes() {
            return this.streamableBytes() - this.allocatedBytes;
        }

        void clearAllocatedBytes() {
            this.allocatedBytes = 0;
        }

        int incrementStreamWindow(int delta) {
            if (delta > 0 && Integer.MAX_VALUE - delta < this.window) {
                throw new IllegalArgumentException("Window size overflow for stream: " + this.streamId);
            }
            this.window += delta;
            return this.window;
        }

        int writableWindow() {
            return Math.min(this.window, OutboundFlowController.this.connectionState.window());
        }

        int streamableBytes() {
            return Math.max(0, Math.min(this.window, (int)this.pendingWriteBuffer.size()));
        }

        boolean hasPendingData() {
            return this.pendingWriteBuffer.size() > 0L;
        }

        int writeBytes(int bytes, WriteStatus writeStatus) {
            int bytesAttempted = 0;
            int maxBytes = Math.min(bytes, this.writableWindow());
            while (this.hasPendingData() && maxBytes > 0) {
                if ((long)maxBytes >= this.pendingWriteBuffer.size()) {
                    bytesAttempted += (int)this.pendingWriteBuffer.size();
                    this.write(this.pendingWriteBuffer, (int)this.pendingWriteBuffer.size(), this.pendingBufferHasEndOfStream);
                } else {
                    bytesAttempted += maxBytes;
                    this.write(this.pendingWriteBuffer, maxBytes, false);
                }
                writeStatus.incrementNumWrites();
                maxBytes = Math.min(bytes - bytesAttempted, this.writableWindow());
            }
            if (!this.hasPendingData() && this.noPendingDataRunnable != null) {
                this.noPendingDataRunnable.run();
                this.noPendingDataRunnable = null;
            }
            return bytesAttempted;
        }

        void write(Buffer buffer, int bytesToSend, boolean endOfStream) {
            int frameBytes;
            int bytesToWrite = bytesToSend;
            do {
                frameBytes = Math.min(bytesToWrite, OutboundFlowController.this.frameWriter.maxDataLength());
                OutboundFlowController.this.connectionState.incrementStreamWindow(-frameBytes);
                this.incrementStreamWindow(-frameBytes);
                try {
                    boolean isEndOfStream = buffer.size() == (long)frameBytes && endOfStream;
                    OutboundFlowController.this.frameWriter.data(isEndOfStream, this.streamId, buffer, frameBytes);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                this.stream.onSentBytes(frameBytes);
            } while ((bytesToWrite -= frameBytes) > 0);
        }

        void enqueueData(Buffer buffer, int size, boolean endOfStream) {
            this.pendingWriteBuffer.write(buffer, (long)size);
            this.pendingBufferHasEndOfStream |= endOfStream;
        }

        void notifyWhenNoPendingData(Runnable noPendingDataRunnable) {
            Preconditions.checkState((this.noPendingDataRunnable == null ? 1 : 0) != 0, (Object)"pending data notification already requested");
            this.noPendingDataRunnable = noPendingDataRunnable;
        }
    }

    public static interface Stream {
        public void onSentBytes(int var1);
    }

    public static interface Transport {
        public StreamState[] getActiveStreams();
    }

    private static final class WriteStatus {
        int numWrites;

        private WriteStatus() {
        }

        void incrementNumWrites() {
            ++this.numWrites;
        }

        boolean hasWritten() {
            return this.numWrites > 0;
        }
    }
}

