/*
 * Decompiled with CFR 0.152.
 */
package com.mineplex.studio.deps.io.grpc.okhttp;

import com.google.common.base.Preconditions;
import com.mineplex.studio.deps.io.grpc.ExperimentalApi;
import com.mineplex.studio.deps.io.grpc.okhttp.OkHttpChannelBuilder;
import com.mineplex.studio.deps.io.grpc.okhttp.Utils;
import com.mineplex.studio.deps.io.grpc.okhttp.internal.ConnectionSpec;
import javax.net.ssl.SSLSocketFactory;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1785")
public final class SslSocketFactoryServerCredentials {
    private SslSocketFactoryServerCredentials() {
    }

    public static com.mineplex.studio.deps.io.grpc.ServerCredentials create(SSLSocketFactory factory) {
        return new ServerCredentials(factory);
    }

    public static com.mineplex.studio.deps.io.grpc.ServerCredentials create(SSLSocketFactory factory, com.squareup.okhttp.ConnectionSpec connectionSpec) {
        return new ServerCredentials(factory, Utils.convertSpec(connectionSpec));
    }

    static final class ServerCredentials
    extends com.mineplex.studio.deps.io.grpc.ServerCredentials {
        private final SSLSocketFactory factory;
        private final ConnectionSpec connectionSpec;

        ServerCredentials(SSLSocketFactory factory) {
            this(factory, OkHttpChannelBuilder.INTERNAL_DEFAULT_CONNECTION_SPEC);
        }

        ServerCredentials(SSLSocketFactory factory, ConnectionSpec connectionSpec) {
            this.factory = (SSLSocketFactory)Preconditions.checkNotNull((Object)factory, (Object)"factory");
            this.connectionSpec = (ConnectionSpec)Preconditions.checkNotNull((Object)connectionSpec, (Object)"connectionSpec");
        }

        public SSLSocketFactory getFactory() {
            return this.factory;
        }

        public ConnectionSpec getConnectionSpec() {
            return this.connectionSpec;
        }
    }
}

