/*
 * Decompiled with CFR 0.152.
 */
package com.mineplex.studio.messaging.client;

import com.mineplex.studio.authclient.StudioClientConfigUtil;
import com.mineplex.studio.authclient.StudioClientCredentials;
import com.mineplex.studio.deps.io.grpc.CallCredentials;
import com.mineplex.studio.deps.io.grpc.Grpc;
import com.mineplex.studio.deps.io.grpc.InsecureChannelCredentials;
import com.mineplex.studio.deps.io.grpc.ManagedChannel;
import com.mineplex.studio.deps.io.grpc.ManagedChannelBuilder;
import com.mineplex.studio.messaging.client.MessagingClientConfig;
import com.mineplex.studio.messaging.client.MessagingPollingClient;
import com.mineplex.studio.messaging.client.MessagingStreamingClient;
import com.mineplex.studio.messaging.contracts.Message;
import com.mineplex.studio.messaging.contracts.MessagingGrpc;
import java.io.Closeable;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessagingClient
implements Closeable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MessagingClient.class);
    @Generated
    private final Object $lock = new Object[0];
    private final Map<MessagingPollingClient.PollingClientFilter, MessagingPollingClient> pollingClients = new ConcurrentHashMap<MessagingPollingClient.PollingClientFilter, MessagingPollingClient>();
    private final MessagingStreamingClient streamingClient;
    private final MessagingGrpc.MessagingBlockingStub blockingStub;
    private final ManagedChannel channel;

    public MessagingClient(@NonNull MessagingClientConfig config, StudioClientCredentials credentials) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        String endpoint = config.getRemoteUrl() + (String)(config.getRemotePort() != null ? ":" + config.getRemotePort() : "");
        this.channel = ((ManagedChannelBuilder)((ManagedChannelBuilder)Grpc.newChannelBuilder(endpoint, InsecureChannelCredentials.create()).defaultServiceConfig(StudioClientConfigUtil.getServiceConfig(this.getClass()))).enableRetry()).build();
        this.blockingStub = (MessagingGrpc.MessagingBlockingStub)MessagingGrpc.newBlockingStub(this.channel).withCallCredentials(credentials);
        this.streamingClient = new MessagingStreamingClient(this.blockingStub);
    }

    MessagingClient(@NonNull MessagingGrpc.MessagingBlockingStub messagingBlockingStub, @NonNull CallCredentials credentials) {
        if (messagingBlockingStub == null) {
            throw new NullPointerException("messagingBlockingStub is marked non-null but is null");
        }
        if (credentials == null) {
            throw new NullPointerException("credentials is marked non-null but is null");
        }
        this.channel = null;
        this.blockingStub = (MessagingGrpc.MessagingBlockingStub)messagingBlockingStub.withCallCredentials(credentials);
        this.streamingClient = new MessagingStreamingClient(this.blockingStub);
    }

    @Override
    public void close() {
        if (this.channel == null) {
            return;
        }
        try {
            this.channel.shutdownNow().awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            log.warn("Failed to close channel", (Throwable)e);
        }
    }

    public List<Message> listUnreadMessages(@NonNull Collection<String> targetTypes) {
        if (targetTypes == null) {
            throw new NullPointerException("targetTypes is marked non-null but is null");
        }
        return this.listUnreadMessages(targetTypes, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Message> listUnreadMessages(@NonNull Collection<String> targetTypes, @Nullable String targetNamespaceId, @Nullable String targetProjectId) {
        Object object = this.$lock;
        synchronized (object) {
            if (targetTypes == null) {
                throw new NullPointerException("targetTypes is marked non-null but is null");
            }
            MessagingPollingClient.PollingClientFilter filter = MessagingPollingClient.PollingClientFilter.builder().targetTypes(targetTypes).namespace(targetNamespaceId).project(targetProjectId).build();
            this.pollingClients.computeIfAbsent(filter, f -> new MessagingPollingClient((MessagingPollingClient.PollingClientFilter)f, this.blockingStub, Instant.ofEpochMilli(0L)));
            return this.pollingClients.get(filter).listUnreadMessages();
        }
    }

    @Generated
    public MessagingGrpc.MessagingBlockingStub getBlockingStub() {
        return this.blockingStub;
    }

    @Generated
    public void subscribeToMessageStream(List<String> targetTypes, String namespaceId, String projectId, Consumer<Message> messageConsumer) {
        this.streamingClient.subscribeToMessageStream(targetTypes, namespaceId, projectId, messageConsumer);
    }
}

