/*
 * Decompiled with CFR 0.152.
 */
package com.mineplex.studio.messaging.client;

import com.mineplex.studio.deps.com.google.protobuf.Timestamp;
import com.mineplex.studio.deps.io.grpc.Status;
import com.mineplex.studio.deps.io.grpc.StatusRuntimeException;
import com.mineplex.studio.messaging.contracts.ListMessagesRequest;
import com.mineplex.studio.messaging.contracts.ListMessagesResponse;
import com.mineplex.studio.messaging.contracts.Message;
import com.mineplex.studio.messaging.contracts.MessagingGrpc;
import io.github.resilience4j.core.IntervalFunction;
import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryConfig;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MessagingPollingClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MessagingPollingClient.class);
    @Generated
    private final Object $lock = new Object[0];
    private static final RetryConfig LIST_RETRY_CONFIG = RetryConfig.custom().maxAttempts(3).intervalFunction(IntervalFunction.ofExponentialRandomBackoff((long)500L, (double)1.5, (double)0.5, (long)2500L)).build();
    private final Set<String> readMessageIdsBuffer = Collections.newSetFromMap(new ConcurrentHashMap());
    private final PollingClientFilter filter;
    private final MessagingGrpc.MessagingBlockingStub messagingBlockingStub;
    private Instant lastListTime;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Message> listUnreadMessages() {
        Object object = this.$lock;
        synchronized (object) {
            ListMessagesResponse listResponse;
            ListMessagesRequest.Builder listRequestBuilder = ListMessagesRequest.newBuilder().addAllTargetClassTypes(this.filter.getTargetTypes()).setLimit(1000);
            if (this.filter.getNamespace() != null) {
                listRequestBuilder.setNamespaceId(this.filter.getNamespace());
            }
            if (this.filter.getProject() != null) {
                listRequestBuilder.setProjectId(this.filter.getProject());
            }
            this.readMessageIdsBuffer.clear();
            ArrayList<Message> listToReturn = new ArrayList<Message>();
            do {
                listRequestBuilder.setMinTimestamp(Timestamp.newBuilder().setSeconds(this.lastListTime.getEpochSecond()).setNanos(this.lastListTime.getNano()).build());
                listResponse = this.listMessagesWithRetryAndBoundaryUpdate(listRequestBuilder.build());
                listResponse.getMessagesList().stream().filter(message -> this.readMessageIdsBuffer.add(message.getId())).forEachOrdered(listToReturn::add);
            } while (listResponse.getHasNextPage());
            return listToReturn;
        }
    }

    private ListMessagesResponse listMessagesWithRetryAndBoundaryUpdate(ListMessagesRequest listRequest) {
        try {
            ListMessagesResponse listResponse = (ListMessagesResponse)Retry.decorateCallable((Retry)Retry.of((String)"listUnreadMessages", (RetryConfig)LIST_RETRY_CONFIG), () -> this.messagingBlockingStub.listMessages(listRequest)).call();
            OptionalLong lastReceivedTime = listResponse.getMessagesList().stream().map(Message::getTimestamp).map(e -> Instant.ofEpochSecond(e.getSeconds(), e.getNanos())).mapToLong(Instant::toEpochMilli).max();
            if (lastReceivedTime.isPresent()) {
                this.lastListTime = Instant.ofEpochMilli(lastReceivedTime.getAsLong());
            }
            return listResponse;
        }
        catch (Exception e2) {
            log.warn("Failed to list unread messages for request {} with exception", (Object)listRequest, (Object)e2);
            throw new StatusRuntimeException(Status.UNKNOWN);
        }
    }

    @Generated
    public MessagingPollingClient(PollingClientFilter filter, MessagingGrpc.MessagingBlockingStub messagingBlockingStub, Instant lastListTime) {
        this.filter = filter;
        this.messagingBlockingStub = messagingBlockingStub;
        this.lastListTime = lastListTime;
    }

    @Generated
    protected void setLastListTime(Instant lastListTime) {
        this.lastListTime = lastListTime;
    }

    public static final class PollingClientFilter {
        private final String identifier;
        private final String namespace;
        private final String project;
        private final Collection<String> targetTypes;

        @Generated
        PollingClientFilter(String identifier, String namespace, String project, Collection<String> targetTypes) {
            this.identifier = identifier;
            this.namespace = namespace;
            this.project = project;
            this.targetTypes = targetTypes;
        }

        @Generated
        public static PollingClientFilterBuilder builder() {
            return new PollingClientFilterBuilder();
        }

        @Generated
        public String getIdentifier() {
            return this.identifier;
        }

        @Generated
        public String getNamespace() {
            return this.namespace;
        }

        @Generated
        public String getProject() {
            return this.project;
        }

        @Generated
        public Collection<String> getTargetTypes() {
            return this.targetTypes;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PollingClientFilter)) {
                return false;
            }
            PollingClientFilter other = (PollingClientFilter)o;
            String this$identifier = this.getIdentifier();
            String other$identifier = other.getIdentifier();
            if (this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier)) {
                return false;
            }
            String this$namespace = this.getNamespace();
            String other$namespace = other.getNamespace();
            if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
                return false;
            }
            String this$project = this.getProject();
            String other$project = other.getProject();
            if (this$project == null ? other$project != null : !this$project.equals(other$project)) {
                return false;
            }
            Collection<String> this$targetTypes = this.getTargetTypes();
            Collection<String> other$targetTypes = other.getTargetTypes();
            return !(this$targetTypes == null ? other$targetTypes != null : !((Object)this$targetTypes).equals(other$targetTypes));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $identifier = this.getIdentifier();
            result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
            String $namespace = this.getNamespace();
            result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
            String $project = this.getProject();
            result = result * 59 + ($project == null ? 43 : $project.hashCode());
            Collection<String> $targetTypes = this.getTargetTypes();
            result = result * 59 + ($targetTypes == null ? 43 : ((Object)$targetTypes).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "MessagingPollingClient.PollingClientFilter(identifier=" + this.getIdentifier() + ", namespace=" + this.getNamespace() + ", project=" + this.getProject() + ", targetTypes=" + String.valueOf(this.getTargetTypes()) + ")";
        }

        @Generated
        public static class PollingClientFilterBuilder {
            @Generated
            private String identifier;
            @Generated
            private String namespace;
            @Generated
            private String project;
            @Generated
            private Collection<String> targetTypes;

            @Generated
            PollingClientFilterBuilder() {
            }

            @Generated
            public PollingClientFilterBuilder identifier(String identifier) {
                this.identifier = identifier;
                return this;
            }

            @Generated
            public PollingClientFilterBuilder namespace(String namespace) {
                this.namespace = namespace;
                return this;
            }

            @Generated
            public PollingClientFilterBuilder project(String project) {
                this.project = project;
                return this;
            }

            @Generated
            public PollingClientFilterBuilder targetTypes(Collection<String> targetTypes) {
                this.targetTypes = targetTypes;
                return this;
            }

            @Generated
            public PollingClientFilter build() {
                return new PollingClientFilter(this.identifier, this.namespace, this.project, this.targetTypes);
            }

            @Generated
            public String toString() {
                return "MessagingPollingClient.PollingClientFilter.PollingClientFilterBuilder(identifier=" + this.identifier + ", namespace=" + this.namespace + ", project=" + this.project + ", targetTypes=" + String.valueOf(this.targetTypes) + ")";
            }
        }
    }
}

