/*
 * Decompiled with CFR 0.152.
 */
package com.mineplex.studio.payments.client;

import com.mineplex.studio.authclient.StudioClientConfigUtil;
import com.mineplex.studio.authclient.StudioClientCredentials;
import com.mineplex.studio.deps.io.grpc.Grpc;
import com.mineplex.studio.deps.io.grpc.InsecureChannelCredentials;
import com.mineplex.studio.deps.io.grpc.ManagedChannel;
import com.mineplex.studio.deps.io.grpc.ManagedChannelBuilder;
import com.mineplex.studio.payments.client.PaymentsClientConfig;
import com.mineplex.studio.payments.contracts.PaymentsGrpc;
import java.io.Closeable;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaymentsClient
implements Closeable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PaymentsClient.class);
    private final ManagedChannel channel;
    private final PaymentsGrpc.PaymentsBlockingStub blockingStub;

    public PaymentsClient(@NonNull PaymentsClientConfig config, @NonNull StudioClientCredentials credentials) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (credentials == null) {
            throw new NullPointerException("credentials is marked non-null but is null");
        }
        String endpoint = config.getRemoteUrl() + (String)(config.getRemotePort() != null ? ":" + config.getRemotePort() : "");
        this.channel = ((ManagedChannelBuilder)((ManagedChannelBuilder)Grpc.newChannelBuilder(endpoint, InsecureChannelCredentials.create()).defaultServiceConfig(StudioClientConfigUtil.getServiceConfig(this.getClass()))).enableRetry()).build();
        this.blockingStub = (PaymentsGrpc.PaymentsBlockingStub)PaymentsGrpc.newBlockingStub(this.channel).withCallCredentials(credentials);
    }

    @Override
    public void close() {
        try {
            this.channel.shutdownNow().awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            log.warn("Failed to close channel", (Throwable)e);
        }
    }

    @Generated
    public PaymentsGrpc.PaymentsBlockingStub getBlockingStub() {
        return this.blockingStub;
    }
}

