/*
 * Decompiled with CFR 0.152.
 */
package com.mineplex.studio.resourcepack.client;

import com.mineplex.studio.authclient.StudioClientCredentials;
import com.mineplex.studio.deps.io.grpc.Grpc;
import com.mineplex.studio.deps.io.grpc.InsecureChannelCredentials;
import com.mineplex.studio.deps.io.grpc.ManagedChannel;
import com.mineplex.studio.resourcepack.client.ResourcePackClientConfig;
import com.mineplex.studio.resourcepack.contracts.ResourcePackGrpc;
import java.io.Closeable;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourcePackClient
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(ResourcePackClient.class);
    private final ManagedChannel channel;
    private final ResourcePackGrpc.ResourcePackBlockingStub blockingStub;

    public ResourcePackClient(@NonNull ResourcePackClientConfig config, @NonNull StudioClientCredentials credentials) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (credentials == null) {
            throw new NullPointerException("credentials is marked non-null but is null");
        }
        String endpoint = config.getRemoteUrl() + (String)(config.getRemotePort() != null ? ":" + config.getRemotePort() : "");
        this.channel = Grpc.newChannelBuilder(endpoint, InsecureChannelCredentials.create()).build();
        this.blockingStub = (ResourcePackGrpc.ResourcePackBlockingStub)ResourcePackGrpc.newBlockingStub(this.channel).withCallCredentials(credentials);
    }

    @Override
    public void close() {
        try {
            this.channel.shutdownNow().awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            log.warn("Failed to close channel", (Throwable)e);
        }
    }

    public ResourcePackGrpc.ResourcePackBlockingStub getBlockingStub() {
        return this.blockingStub;
    }
}

