/*
 * Decompiled with CFR 0.152.
 */
package com.mintminter.simplewidget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.mintminter.simplewidget.R;

public class SimpleProgressBar
extends LinearLayout {
    private Context mContext;
    private LinearLayout mView;
    private int nScale = 10;
    private int nGapInDP = 5;
    private float fProgress = 0.0f;
    private int nForegroundColor = -16776961;
    private int nBackgroundColor = -7829368;

    public SimpleProgressBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        this.mContext = context;
        TypedArray styledAttrs = context.obtainStyledAttributes(attrs, R.styleable.SimpleProgressBar);
        this.nScale = styledAttrs.getInt(R.styleable.SimpleProgressBar_spb_scale, this.nScale);
        this.nGapInDP = (int)styledAttrs.getDimension(R.styleable.SimpleProgressBar_spb_gap, (float)this.nGapInDP);
        this.fProgress = styledAttrs.getFloat(R.styleable.SimpleProgressBar_spb_progress, this.fProgress);
        this.nForegroundColor = styledAttrs.getColor(R.styleable.SimpleProgressBar_spb_foreground_color, this.nForegroundColor);
        this.nBackgroundColor = styledAttrs.getColor(R.styleable.SimpleProgressBar_spb_background_color, this.nBackgroundColor);
        styledAttrs.recycle();
        this.mView = new LinearLayout(context);
        this.mView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        this.mView.setOrientation(0);
        this.mView.setWeightSum((float)this.nScale);
        this.mView.setGravity(17);
        this.addView((View)this.mView);
        this.generate();
    }

    private void generate() {
        if (this.mView.getChildCount() > 0) {
            this.mView.removeAllViews();
        }
        for (int i = 0; i < this.nScale; ++i) {
            LinearLayout block = new LinearLayout(this.mContext);
            LinearLayout.LayoutParams blocklp = new LinearLayout.LayoutParams(0, -1);
            blocklp.setMargins(0, 0, this.dpToPixal(this.nGapInDP), 0);
            blocklp.weight = 1.0f;
            block.setLayoutParams((ViewGroup.LayoutParams)blocklp);
            block.setGravity(17);
            int nProgress = (int)Math.floor(this.fProgress * (float)this.nScale);
            if (i < nProgress) {
                block.setBackgroundColor(this.nForegroundColor);
                block.setAlpha(1.0f);
            } else if (i == nProgress && nProgress < (int)Math.ceil(this.fProgress * (float)this.nScale)) {
                block.setBackgroundColor(this.nForegroundColor);
                block.setAlpha(0.5f);
            } else {
                block.setBackgroundColor(this.nBackgroundColor);
                block.setAlpha(1.0f);
            }
            this.mView.addView((View)block);
        }
    }

    public void setScale(int scale) {
        this.nScale = scale;
        this.mView.setWeightSum((float)this.nScale);
        this.generate();
    }

    public void setProgress(float processingValue, float maxValue) {
        this.setProgress(processingValue / maxValue);
    }

    public void setProgress(float progress) {
        LinearLayout child;
        int i;
        this.fProgress = progress;
        int ceil = (int)Math.ceil(progress * (float)this.nScale);
        int nProgress = (int)Math.floor(progress * (float)this.nScale);
        for (i = 0; i < nProgress; ++i) {
            child = (LinearLayout)this.mView.getChildAt(i);
            child.setBackgroundColor(this.nForegroundColor);
            child.setAlpha(1.0f);
        }
        for (i = nProgress; i < this.nScale; ++i) {
            child = (LinearLayout)this.mView.getChildAt(i);
            child.setBackgroundColor(this.nBackgroundColor);
            child.setAlpha(1.0f);
        }
        if (ceil > nProgress) {
            LinearLayout child2 = (LinearLayout)this.mView.getChildAt(nProgress);
            child2.setBackgroundColor(this.nForegroundColor);
            child2.setAlpha(0.5f);
        }
    }

    private int dpToPixal(int dp) {
        float scale = this.mContext.getResources().getDisplayMetrics().density;
        return (int)((float)dp * scale + 0.5f);
    }
}

