/*
 * Decompiled with CFR 0.152.
 */
package com.miragesql.miragesql.integration.spring;

import com.miragesql.miragesql.provider.ConnectionProvider;
import java.sql.Connection;
import javax.sql.DataSource;
import org.springframework.jdbc.datasource.ConnectionHolder;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class SpringConnectionProvider
implements ConnectionProvider {
    private DataSource dataSource;

    public void setTransactionManager(DataSourceTransactionManager transactionManager) {
        this.dataSource = transactionManager.getDataSource();
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource instanceof TransactionAwareDataSourceProxy ? ((TransactionAwareDataSourceProxy)dataSource).getTargetDataSource() : dataSource;
    }

    public Connection getConnection() {
        ConnectionHolder conHolder = (ConnectionHolder)TransactionSynchronizationManager.getResource((Object)this.dataSource);
        if (conHolder == null) {
            throw new IllegalStateException("It seems not to be existing a transaction.");
        }
        return conHolder.getConnection();
    }
}

