/*
 * Decompiled with CFR 0.152.
 */
package com.miragesql.miragesql.test;

import com.miragesql.miragesql.DefaultEntityOperator;
import com.miragesql.miragesql.EntityOperator;
import com.miragesql.miragesql.bean.BeanDescFactory;
import com.miragesql.miragesql.bean.PropertyDesc;
import com.miragesql.miragesql.naming.DefaultNameConverter;
import com.miragesql.miragesql.naming.NameConverter;
import com.miragesql.miragesql.test.ExecutedSQLInfo;
import com.miragesql.miragesql.util.MirageUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;

public class MirageTestContext {
    private static BeanDescFactory beanDescFactory = new BeanDescFactory();
    private static NameConverter nameConverter = new DefaultNameConverter();
    private static EntityOperator entityOperator = new DefaultEntityOperator();
    private static List<Object> resultList = new ArrayList<Object>();
    private static List<ExecutedSQLInfo> executedSqlList = new ArrayList<ExecutedSQLInfo>();
    private static Map<String, Long> sequenceMap = new HashMap<String, Long>();

    public static void initMirageTestContext() {
        resultList.clear();
        executedSqlList.clear();
        sequenceMap.clear();
    }

    public static void setNameConverter(NameConverter nameConverter) {
        MirageTestContext.nameConverter = nameConverter;
    }

    public static void addResult(Object result) {
        resultList.add(result);
    }

    static boolean hasNextResult() {
        return !resultList.isEmpty();
    }

    static Object getNextResult() {
        return resultList.remove(0);
    }

    static void addExecutedSql(ExecutedSQLInfo executedSql) {
        System.out.println(String.format("[SQL] %s", MirageTestContext.normalizeSql(executedSql.getSql())));
        Object[] params = executedSql.getParams();
        for (int i = 0; i < params.length; ++i) {
            System.out.println(String.format("[SQL] params[%d]: %s", i, params[i]));
        }
        executedSqlList.add(executedSql);
    }

    static long getNextVal(Class<?> entity, String propertyName) {
        String key = entity.getClass().getName() + "#" + propertyName;
        Long value = sequenceMap.get(key);
        if (value == null) {
            value = -1L;
        }
        value = value + 1L;
        sequenceMap.put(key, value);
        return value;
    }

    public static ExecutedSQLInfo getExecutedSQLInfo(int index) {
        return executedSqlList.get(index);
    }

    public static void verifySqlNumber(int expected) {
        Assert.assertEquals((long)expected, (long)executedSqlList.size());
    }

    public static void verifySql(int indexOfSql, String sql) {
        ExecutedSQLInfo executedSql = executedSqlList.get(indexOfSql);
        String result = executedSql.getSql();
        Assert.assertEquals((Object)MirageTestContext.normalizeSql(sql), (Object)MirageTestContext.normalizeSql(result));
    }

    public static void verifySql(int indexOfSql, String sql, Object ... values) {
        MirageTestContext.verifySql(indexOfSql, sql);
        MirageTestContext.verifyParameters(indexOfSql, values);
    }

    public static void verifySqlByRegExp(int indexOfSql, String regexp) {
        ExecutedSQLInfo executedSql = executedSqlList.get(indexOfSql);
        String result = MirageTestContext.normalizeSql(executedSql.getSql());
        Assert.assertTrue((boolean)result.matches(regexp));
    }

    public static void verifySqlByRegExp(int indexOfSql, String regexp, Object ... values) {
        MirageTestContext.verifySqlByRegExp(indexOfSql, regexp);
        MirageTestContext.verifyParameters(indexOfSql, values);
    }

    public static void verifyFindSql(int indexOfSql, Class<?> entityClass, Object ... id) {
        MirageTestContext.verifySql(indexOfSql, MirageUtil.buildSelectSQL((BeanDescFactory)beanDescFactory, (EntityOperator)entityOperator, entityClass, (NameConverter)nameConverter));
        MirageTestContext.verifyParameters(indexOfSql, id);
    }

    public static void verifyInsertSql(int indexOfSql, Object entity) {
        ArrayList values = new ArrayList();
        MirageTestContext.verifySql(indexOfSql, MirageUtil.buildInsertSql((BeanDescFactory)beanDescFactory, (EntityOperator)entityOperator, entity.getClass(), (NameConverter)nameConverter, values));
        MirageTestContext.verifyParameters(indexOfSql, entity, values.toArray(new PropertyDesc[values.size()]));
    }

    public static void verifyUpdatedSql(int indexOfSql, Object entity) {
        ArrayList values = new ArrayList();
        MirageTestContext.verifySql(indexOfSql, MirageUtil.buildUpdateSql((BeanDescFactory)beanDescFactory, (EntityOperator)entityOperator, entity.getClass(), (NameConverter)nameConverter, values));
        MirageTestContext.verifyParameters(indexOfSql, entity, values.toArray(new PropertyDesc[values.size()]));
    }

    public static void verifyDeleteSql(int indexOfSql, Object entity) {
        ArrayList values = new ArrayList();
        MirageTestContext.verifySql(indexOfSql, MirageUtil.buildDeleteSql((BeanDescFactory)beanDescFactory, (EntityOperator)entityOperator, entity.getClass(), (NameConverter)nameConverter, values));
        MirageTestContext.verifyParameters(indexOfSql, entity, values.toArray(new PropertyDesc[values.size()]));
    }

    private static void verifyParameters(int indexOfSql, Object entity, PropertyDesc[] propDescs) {
        ExecutedSQLInfo executedSql = executedSqlList.get(indexOfSql);
        Object[] params = executedSql.getParams();
        Assert.assertEquals((long)propDescs.length, (long)params.length);
        for (int i = 0; i < propDescs.length; ++i) {
            Assert.assertEquals((Object)propDescs[i].getValue(entity), (Object)params[i]);
        }
    }

    private static void verifyParameters(int indexOfSql, Object[] values) {
        ExecutedSQLInfo executedSql = executedSqlList.get(indexOfSql);
        Object[] params = executedSql.getParams();
        Assert.assertEquals((long)values.length, (long)params.length);
        for (int i = 0; i < values.length; ++i) {
            Assert.assertEquals((Object)values[i], (Object)params[i]);
        }
    }

    private static String normalizeSql(String sql) {
        sql = sql.replaceAll("--.*", " ");
        sql = sql.replaceAll("\r\n", "\n");
        sql = sql.replaceAll("\r", "\n");
        sql = sql.replaceAll("\n", " ");
        sql = sql.replaceAll("/\\*.*\\*/", " ");
        sql = sql.replaceAll("[ \t]+", " ");
        sql = sql.toUpperCase().trim();
        return sql;
    }
}

