/*
 * Decompiled with CFR 0.152.
 */
package com.mitchellbosecke.pebble.spring4.extension.function;

import com.mitchellbosecke.pebble.extension.Function;
import com.mitchellbosecke.pebble.template.EvaluationContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.springframework.context.MessageSource;

public class MessageSourceFunction
implements Function {
    public static final String FUNCTION_NAME = "message";
    private final MessageSource messageSource;

    public MessageSourceFunction(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public Object execute(Map<String, Object> args) {
        String key = this.extractKey(args);
        List<Object> arguments = this.extractArguments(args);
        Locale locale = this.extractLocale(args);
        return this.messageSource.getMessage(key, arguments.toArray(), "???" + key + "???", locale);
    }

    private Locale extractLocale(Map<String, Object> args) {
        EvaluationContext context = (EvaluationContext)args.get("_context");
        return context.getLocale();
    }

    private String extractKey(Map<String, Object> args) {
        return (String)args.get("0");
    }

    private List<Object> extractArguments(Map<String, Object> args) {
        int i = 1;
        ArrayList<Object> arguments = new ArrayList<Object>();
        while (args.containsKey(String.valueOf(i))) {
            Object param = args.get(String.valueOf(i));
            arguments.add(param);
            ++i;
        }
        return arguments;
    }

    public List<String> getArgumentNames() {
        return null;
    }
}

