/*
 * Decompiled with CFR 0.152.
 */
package com.mitchellbosecke.pebble.spring4.extension.function.bindingresult;

import com.mitchellbosecke.pebble.spring4.extension.function.bindingresult.BaseBindingResultFunction;
import com.mitchellbosecke.pebble.template.EvaluationContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.springframework.context.MessageSource;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;

public class GetFieldErrorsFunction
extends BaseBindingResultFunction {
    public static final String FUNCTION_NAME = "getFieldErrors";
    private final MessageSource messageSource;

    public GetFieldErrorsFunction(MessageSource messageSource) {
        super("formName", "fieldName");
        this.messageSource = messageSource;
    }

    public Object execute(Map<String, Object> args) {
        String formName = (String)args.get("formName");
        String field = (String)args.get("fieldName");
        if (field == null) {
            throw new IllegalArgumentException("Field parameter is required in GetFieldErrorsFunction");
        }
        EvaluationContext context = (EvaluationContext)args.get("_context");
        Locale locale = context.getLocale();
        BindingResult bindingResult = this.getBindingResult(formName, context);
        return this.constructErrorMessages(field, locale, bindingResult);
    }

    private List<String> constructErrorMessages(String field, Locale locale, BindingResult bindingResult) {
        ArrayList<String> errorMessages = new ArrayList<String>();
        if (bindingResult != null) {
            for (FieldError error : bindingResult.getFieldErrors(field)) {
                String msg = this.messageSource.getMessage(error.getCode(), error.getArguments(), error.getDefaultMessage(), locale);
                errorMessages.add(msg);
            }
        }
        return errorMessages;
    }
}

