/*
 * Decompiled with CFR 0.152.
 */
package com.mitchellbosecke.pebble.extension;

import com.mitchellbosecke.pebble.extension.NodeVisitor;
import com.mitchellbosecke.pebble.node.ArgumentsNode;
import com.mitchellbosecke.pebble.node.AutoEscapeNode;
import com.mitchellbosecke.pebble.node.BlockNode;
import com.mitchellbosecke.pebble.node.BodyNode;
import com.mitchellbosecke.pebble.node.ExtendsNode;
import com.mitchellbosecke.pebble.node.FlushNode;
import com.mitchellbosecke.pebble.node.ForNode;
import com.mitchellbosecke.pebble.node.IfNode;
import com.mitchellbosecke.pebble.node.ImportNode;
import com.mitchellbosecke.pebble.node.IncludeNode;
import com.mitchellbosecke.pebble.node.MacroNode;
import com.mitchellbosecke.pebble.node.NamedArgumentNode;
import com.mitchellbosecke.pebble.node.Node;
import com.mitchellbosecke.pebble.node.ParallelNode;
import com.mitchellbosecke.pebble.node.PositionalArgumentNode;
import com.mitchellbosecke.pebble.node.PrintNode;
import com.mitchellbosecke.pebble.node.RootNode;
import com.mitchellbosecke.pebble.node.SetNode;
import com.mitchellbosecke.pebble.node.TextNode;
import com.mitchellbosecke.pebble.node.expression.Expression;
import com.mitchellbosecke.pebble.template.PebbleTemplateImpl;
import com.mitchellbosecke.pebble.utils.Pair;

public class AbstractNodeVisitor
implements NodeVisitor {
    protected PebbleTemplateImpl template;

    @Override
    public void setTemplate(PebbleTemplateImpl template) {
        this.template = template;
    }

    @Override
    public void visit(Node node) {
    }

    @Override
    public void visit(ArgumentsNode node) {
        if (node.getNamedArgs() != null) {
            for (Node node2 : node.getNamedArgs()) {
                node2.accept(this);
            }
        }
        if (node.getPositionalArgs() != null) {
            for (Node node3 : node.getPositionalArgs()) {
                node3.accept(this);
            }
        }
    }

    @Override
    public void visit(AutoEscapeNode node) {
        node.getBody().accept(this);
    }

    @Override
    public void visit(BlockNode node) {
        node.getBody().accept(this);
    }

    @Override
    public void visit(BodyNode node) {
        for (Node node2 : node.getChildren()) {
            node2.accept(this);
        }
    }

    @Override
    public void visit(ExtendsNode node) {
        node.getParentExpression().accept(this);
    }

    @Override
    public void visit(FlushNode node) {
    }

    @Override
    public void visit(ForNode node) {
        node.getIterable().accept(this);
        node.getBody().accept(this);
        if (node.getElseBody() != null) {
            node.getElseBody().accept(this);
        }
    }

    @Override
    public void visit(IfNode node) {
        for (Pair<Expression<?>, BodyNode> pairs : node.getConditionsWithBodies()) {
            pairs.getLeft().accept(this);
            pairs.getRight().accept(this);
        }
        if (node.getElseBody() != null) {
            node.getElseBody().accept(this);
        }
    }

    @Override
    public void visit(ImportNode node) {
        node.getImportExpression().accept(this);
    }

    @Override
    public void visit(IncludeNode node) {
        node.getIncludeExpression().accept(this);
    }

    @Override
    public void visit(MacroNode node) {
        node.getBody().accept(this);
        node.getArgs().accept(this);
    }

    @Override
    public void visit(NamedArgumentNode node) {
        if (node.getValueExpression() != null) {
            node.getValueExpression().accept(this);
        }
    }

    @Override
    public void visit(ParallelNode node) {
        node.getBody().accept(this);
    }

    @Override
    public void visit(PositionalArgumentNode node) {
        node.getValueExpression().accept(this);
    }

    @Override
    public void visit(PrintNode node) {
        node.getExpression().accept(this);
    }

    @Override
    public void visit(RootNode node) {
        node.getBody().accept(this);
    }

    @Override
    public void visit(SetNode node) {
        node.getValue().accept(this);
    }

    @Override
    public void visit(TextNode node) {
    }
}

