/*
 * Decompiled with CFR 0.152.
 */
package com.mitchellbosecke.pebble.extension.escaper;

import com.coverity.security.Escape;
import com.mitchellbosecke.pebble.extension.Filter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class EscapeFilter
implements Filter {
    private String defaultStrategy = "html";
    private final List<String> argumentNames = new ArrayList<String>();

    public EscapeFilter() {
        this.argumentNames.add("strategy");
    }

    @Override
    public List<String> getArgumentNames() {
        return this.argumentNames;
    }

    @Override
    public Object apply(Object inputObject, Map<String, Object> args) {
        if (!(inputObject instanceof String)) {
            return inputObject;
        }
        String input = (String)inputObject;
        String strategy = this.defaultStrategy;
        if (args.get("strategy") != null) {
            strategy = (String)args.get("strategy");
        }
        switch (strategy) {
            case "html": {
                input = Escape.htmlText((String)input);
                break;
            }
            case "js": {
                input = Escape.jsString((String)input);
                break;
            }
            case "css": {
                input = Escape.cssString((String)input);
                break;
            }
            case "html_attr": {
                input = Escape.html((String)input);
                break;
            }
            case "url_param": {
                input = Escape.uriParam((String)input);
                break;
            }
            default: {
                throw new RuntimeException("Unknown escaping strategy");
            }
        }
        return input;
    }

    public String getDefaultStrategy() {
        return this.defaultStrategy;
    }

    public void setDefaultStrategy(String defaultStrategy) {
        this.defaultStrategy = defaultStrategy;
    }
}

