/*
 * Decompiled with CFR 0.152.
 */
package com.mitchellbosecke.pebble.lexer;

import com.mitchellbosecke.pebble.PebbleEngine;
import com.mitchellbosecke.pebble.error.ParserException;
import com.mitchellbosecke.pebble.lexer.Lexer;
import com.mitchellbosecke.pebble.lexer.TemplateSource;
import com.mitchellbosecke.pebble.lexer.Token;
import com.mitchellbosecke.pebble.lexer.TokenStream;
import com.mitchellbosecke.pebble.operator.BinaryOperator;
import com.mitchellbosecke.pebble.operator.UnaryOperator;
import com.mitchellbosecke.pebble.utils.Pair;
import com.mitchellbosecke.pebble.utils.StringLengthComparator;
import com.mitchellbosecke.pebble.utils.StringUtils;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LexerImpl
implements Lexer {
    private final PebbleEngine engine;
    private TemplateSource source;
    private ArrayList<Token> tokens;
    private LinkedList<Pair<String, Integer>> brackets;
    private String delimiterCommentOpen = "{#";
    private String delimiterCommentClose = "#}";
    private String delimiterExecuteOpen = "{%";
    private String delimiterExecuteClose = "%}";
    private String delimiterPrintOpen = "{{";
    private String delimiterPrintClose = "}}";
    private String whitespaceTrim = "-";
    private Pattern regexPrintClose;
    private Pattern regexExecuteClose;
    private Pattern regexCommentClose;
    private Pattern regexStartDelimiters;
    private Pattern regexLeadingWhitespaceTrim;
    private Pattern regexTrailingWhitespaceTrim;
    private Pattern regexVerbatimStart;
    private Pattern regexVerbatimEnd;
    private Pattern regexOperators;
    private State state;
    private LinkedList<State> states;
    private boolean trimLeadingWhitespaceFromNextData = false;
    private static final Pattern REGEX_NAME = Pattern.compile("^[a-zA-Z_][a-zA-Z0-9_]*");
    private static final Pattern REGEX_NUMBER = Pattern.compile("^[0-9]+(\\.[0-9]+)?");
    private static final Pattern REGEX_STRING = Pattern.compile("((\").*?(?<!\\\\)(\"))|((').*?(?<!\\\\)('))", 32);
    private static final String PUNCTUATION = "()[]{}?:.,|=";

    public LexerImpl(PebbleEngine engine) {
        this.engine = engine;
        String possibleNewline = "(\r\n|\n\r|\r|\n|\u0085|\u2028|\u2029)?";
        this.regexPrintClose = Pattern.compile("^\\s*" + Pattern.quote(this.whitespaceTrim) + "?" + Pattern.quote(this.delimiterPrintClose) + possibleNewline);
        this.regexExecuteClose = Pattern.compile("^\\s*" + Pattern.quote(this.whitespaceTrim) + "?" + Pattern.quote(this.delimiterExecuteClose) + possibleNewline);
        this.regexCommentClose = Pattern.compile(Pattern.quote(this.delimiterCommentClose) + possibleNewline);
        this.regexStartDelimiters = Pattern.compile(Pattern.quote(this.delimiterPrintOpen) + "|" + Pattern.quote(this.delimiterExecuteOpen) + "|" + Pattern.quote(this.delimiterCommentOpen));
        this.regexVerbatimStart = Pattern.compile("^\\s*verbatim\\s*(" + Pattern.quote(this.whitespaceTrim) + ")?" + Pattern.quote(this.delimiterExecuteClose) + possibleNewline);
        this.regexVerbatimEnd = Pattern.compile(Pattern.quote(this.delimiterExecuteOpen) + "(" + Pattern.quote(this.whitespaceTrim) + ")?" + "\\s*endverbatim\\s*(" + Pattern.quote(this.whitespaceTrim) + ")?" + Pattern.quote(this.delimiterExecuteClose) + possibleNewline);
        this.regexLeadingWhitespaceTrim = Pattern.compile(Pattern.quote(this.whitespaceTrim) + "\\s+");
        this.regexTrailingWhitespaceTrim = Pattern.compile("^\\s*" + Pattern.quote(this.whitespaceTrim) + "(" + Pattern.quote(this.delimiterPrintClose) + "|" + Pattern.quote(this.delimiterExecuteClose) + "|" + Pattern.quote(this.delimiterCommentClose) + ")");
    }

    @Override
    public TokenStream tokenize(Reader reader, String name) throws ParserException {
        this.buildOperatorRegex();
        try {
            this.source = new TemplateSource(reader, name);
        }
        catch (IOException e) {
            throw new ParserException((Throwable)e, "Can not convert template Reader into a String", 0, name);
        }
        this.state = State.DATA;
        this.tokens = new ArrayList();
        this.states = new LinkedList();
        this.brackets = new LinkedList();
        block8: while (this.source.length() > 0) {
            switch (this.state) {
                case DATA: {
                    this.lexData();
                    continue block8;
                }
                case EXECUTE: {
                    this.lexExecute();
                    continue block8;
                }
                case PRINT: {
                    this.lexPrint();
                    continue block8;
                }
                case COMMENT: {
                    this.lexComment();
                    continue block8;
                }
            }
        }
        this.pushToken(Token.Type.EOF);
        if (!this.brackets.isEmpty()) {
            String expected = this.brackets.pop().getLeft();
            throw new ParserException(null, String.format("Unclosed \"%s\"", expected), this.source.getLineNumber(), this.source.getFilename());
        }
        return new TokenStream(this.tokens, this.source.getFilename());
    }

    private void lexData() throws ParserException {
        String text;
        Matcher matcher = this.regexStartDelimiters.matcher(this.source);
        boolean match = matcher.find();
        String startDelimiterToken = null;
        if (!match) {
            text = this.source.toString();
            this.source.advance(this.source.length());
        } else {
            text = this.source.substring(matcher.start());
            startDelimiterToken = this.source.substring(matcher.start(), matcher.end());
            this.source.advance(matcher.end());
        }
        if (this.trimLeadingWhitespaceFromNextData) {
            text = StringUtils.ltrim(text);
            this.trimLeadingWhitespaceFromNextData = false;
        }
        Token textToken = this.pushToken(Token.Type.TEXT, text);
        if (match) {
            this.checkForLeadingWhitespaceTrim(textToken);
            if (this.delimiterCommentOpen.equals(startDelimiterToken)) {
                this.pushState(State.COMMENT);
            } else if (this.delimiterPrintOpen.equals(startDelimiterToken)) {
                this.pushToken(Token.Type.PRINT_START);
                this.pushState(State.PRINT);
            } else if (this.delimiterExecuteOpen.equals(startDelimiterToken)) {
                Matcher verbatimStartMatcher = this.regexVerbatimStart.matcher(this.source);
                if (verbatimStartMatcher.lookingAt()) {
                    this.lexVerbatimData(verbatimStartMatcher);
                    this.pushState(State.DATA);
                } else {
                    this.pushToken(Token.Type.EXECUTE_START);
                    this.pushState(State.EXECUTE);
                }
            }
        }
    }

    private void lexExecute() throws ParserException {
        this.checkForTrailingWhitespaceTrim();
        Matcher matcher = this.regexExecuteClose.matcher(this.source);
        if (this.brackets.isEmpty() && matcher.lookingAt()) {
            this.pushToken(Token.Type.EXECUTE_END, this.delimiterExecuteClose);
            this.source.advance(matcher.end());
            this.popState();
        } else {
            this.lexExpression();
        }
    }

    private void lexPrint() throws ParserException {
        this.checkForTrailingWhitespaceTrim();
        Matcher matcher = this.regexPrintClose.matcher(this.source);
        if (this.brackets.isEmpty() && matcher.lookingAt()) {
            this.pushToken(Token.Type.PRINT_END, this.delimiterPrintClose);
            this.source.advance(matcher.end());
            this.popState();
        } else {
            this.lexExpression();
        }
    }

    private void lexComment() throws ParserException {
        Matcher matcher = this.regexCommentClose.matcher(this.source);
        boolean match = matcher.find(0);
        if (!match) {
            throw new ParserException(null, "Unclosed comment.", this.source.getLineNumber(), this.source.getFilename());
        }
        String comment = this.source.substring(matcher.start());
        String reversedComment = new StringBuilder(comment).reverse().toString();
        Matcher whitespaceTrimMatcher = this.regexLeadingWhitespaceTrim.matcher(reversedComment);
        if (whitespaceTrimMatcher.lookingAt()) {
            this.trimLeadingWhitespaceFromNextData = true;
        }
        this.source.advance(matcher.end());
        this.popState();
    }

    private void lexExpression() throws ParserException {
        this.source.advanceThroughWhitespace();
        Matcher matcher = this.regexOperators.matcher(this.source);
        if (matcher.lookingAt()) {
            String token = this.source.substring(matcher.end());
            this.pushToken(Token.Type.OPERATOR, token);
            this.source.advance(matcher.end());
            return;
        }
        matcher = REGEX_NAME.matcher(this.source);
        if (matcher.lookingAt()) {
            String token = this.source.substring(matcher.end());
            this.pushToken(Token.Type.NAME, token);
            this.source.advance(matcher.end());
            return;
        }
        matcher = REGEX_NUMBER.matcher(this.source);
        if (matcher.lookingAt()) {
            String token = this.source.substring(matcher.end());
            this.pushToken(Token.Type.NUMBER, token);
            this.source.advance(matcher.end());
            return;
        }
        if (PUNCTUATION.indexOf(this.source.charAt(0)) >= 0) {
            String character = String.valueOf(this.source.charAt(0));
            if ("([{".indexOf(character) >= 0) {
                this.brackets.push(new Pair<String, Integer>(character, this.source.getLineNumber()));
            } else if (")]}".indexOf(character) >= 0) {
                if (this.brackets.isEmpty()) {
                    throw new ParserException(null, "Unexpected \"" + character + "\"", this.source.getLineNumber(), this.source.getFilename());
                }
                HashMap<String, String> validPairs = new HashMap<String, String>();
                validPairs.put("(", ")");
                validPairs.put("[", "]");
                validPairs.put("{", "}");
                String lastBracket = this.brackets.pop().getLeft();
                String expected = (String)validPairs.get(lastBracket);
                if (!expected.equals(character)) {
                    throw new ParserException(null, "Unclosed \"" + expected + "\"", this.source.getLineNumber(), this.source.getFilename());
                }
            }
            this.pushToken(Token.Type.PUNCTUATION, character);
            this.source.advance(1);
            return;
        }
        matcher = REGEX_STRING.matcher(this.source);
        if (matcher.lookingAt()) {
            String token = this.source.substring(matcher.end());
            this.source.advance(matcher.end());
            char quotationType = token.charAt(0);
            token = token.substring(1, token.length() - 1);
            if (quotationType == '\'') {
                token = token.replaceAll("\\\\(')", "$1");
            } else if (quotationType == '\"') {
                token = token.replaceAll("\\\\(\")", "$1");
            }
            this.pushToken(Token.Type.STRING, token);
            return;
        }
        throw new ParserException(null, String.format("Unexpected character [%s]", Character.valueOf(this.source.charAt(0))), this.source.getLineNumber(), this.source.getFilename());
    }

    private void checkForLeadingWhitespaceTrim(Token leadingToken) {
        Matcher whitespaceTrimMatcher = this.regexLeadingWhitespaceTrim.matcher(this.source);
        if (whitespaceTrimMatcher.lookingAt()) {
            if (leadingToken != null) {
                leadingToken.setValue(StringUtils.rtrim(leadingToken.getValue()));
            }
            this.source.advance(whitespaceTrimMatcher.end());
        }
    }

    private void checkForTrailingWhitespaceTrim() {
        Matcher whitespaceTrimMatcher = this.regexTrailingWhitespaceTrim.matcher(this.source);
        if (whitespaceTrimMatcher.lookingAt()) {
            this.trimLeadingWhitespaceFromNextData = true;
        }
    }

    private void lexVerbatimData(Matcher verbatimStartMatcher) throws ParserException {
        this.source.advance(verbatimStartMatcher.end());
        Matcher verbatimEndMatcher = this.regexVerbatimEnd.matcher(this.source);
        if (!verbatimEndMatcher.find()) {
            throw new ParserException(null, "Unclosed verbatim tag.", this.source.getLineNumber(), this.source.getFilename());
        }
        String verbatimText = this.source.substring(verbatimEndMatcher.start());
        if (verbatimStartMatcher.group(0) != null) {
            verbatimText = StringUtils.ltrim(verbatimText);
        }
        if (verbatimEndMatcher.group(1) != null) {
            verbatimText = StringUtils.rtrim(verbatimText);
        }
        if (verbatimEndMatcher.group(2) != null) {
            this.trimLeadingWhitespaceFromNextData = true;
        }
        this.source.advance(verbatimEndMatcher.end());
        this.pushToken(Token.Type.TEXT, verbatimText);
    }

    private Token pushToken(Token.Type type) {
        return this.pushToken(type, null);
    }

    private Token pushToken(Token.Type type, String value) {
        if (type.equals((Object)Token.Type.TEXT) && (value == null || "".equals(value))) {
            return null;
        }
        Token result = new Token(type, value, this.source.getLineNumber());
        this.tokens.add(result);
        return result;
    }

    private void pushState(State state) {
        this.states.push(this.state);
        this.state = state;
    }

    private void popState() {
        this.state = this.states.pop();
    }

    @Override
    public String getCommentOpenDelimiter() {
        return this.delimiterCommentOpen;
    }

    @Override
    public void setCommentOpenDelimiter(String commentOpenDelimiter) {
        this.delimiterCommentOpen = commentOpenDelimiter;
    }

    @Override
    public String getCommentCloseDelimiter() {
        return this.delimiterCommentClose;
    }

    @Override
    public void setCommentCloseDelimiter(String commentCloseDelimiter) {
        this.delimiterCommentClose = commentCloseDelimiter;
    }

    @Override
    public String getExecuteOpenDelimiter() {
        return this.delimiterExecuteOpen;
    }

    @Override
    public void setExecuteOpenDelimiter(String executeOpenDelimiter) {
        this.delimiterExecuteOpen = executeOpenDelimiter;
    }

    @Override
    public String getExecuteCloseDelimiter() {
        return this.delimiterExecuteClose;
    }

    @Override
    public void setExecuteCloseDelimiter(String executeCloseDelimiter) {
        this.delimiterExecuteClose = executeCloseDelimiter;
    }

    @Override
    public String getPrintOpenDelimiter() {
        return this.delimiterPrintOpen;
    }

    @Override
    public void setPrintOpenDelimiter(String printOpenDelimiter) {
        this.delimiterPrintOpen = printOpenDelimiter;
    }

    @Override
    public String getPrintCloseDelimiter() {
        return this.delimiterPrintClose;
    }

    @Override
    public void setPrintCloseDelimiter(String printCloseDelimiter) {
        this.delimiterPrintClose = printCloseDelimiter;
    }

    private void buildOperatorRegex() {
        ArrayList<String> operators = new ArrayList<String>();
        for (UnaryOperator unaryOperator : this.engine.getUnaryOperators().values()) {
            operators.add(unaryOperator.getSymbol());
        }
        for (BinaryOperator binaryOperator : this.engine.getBinaryOperators().values()) {
            operators.add(binaryOperator.getSymbol());
        }
        Collections.sort(operators, new StringLengthComparator());
        StringBuilder regex = new StringBuilder("^");
        boolean bl = true;
        for (String operator : operators) {
            boolean bl2;
            if (bl2) {
                bl2 = false;
            } else {
                regex.append("|");
            }
            regex.append(Pattern.quote(operator));
            if (!Character.isAlphabetic(operator.charAt(operator.length() - 1))) continue;
            regex.append("(?![a-zA-Z])");
        }
        this.regexOperators = Pattern.compile(regex.toString());
    }

    public String getWhitespaceTrim() {
        return this.whitespaceTrim;
    }

    public void setWhitespaceTrim(String whitespaceTrim) {
        this.whitespaceTrim = whitespaceTrim;
    }

    private static enum State {
        DATA,
        EXECUTE,
        PRINT,
        COMMENT;

    }
}

