/*
 * Decompiled with CFR 0.152.
 */
package com.mitchellbosecke.pebble.loader;

import com.mitchellbosecke.pebble.error.LoaderException;
import com.mitchellbosecke.pebble.loader.Loader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

public class DelegatingLoader
implements Loader {
    private String prefix;
    private String suffix;
    private String charset = "UTF-8";
    private final List<Loader> loaders = new ArrayList<Loader>();

    public DelegatingLoader(List<Loader> loaders) {
        this.loaders.addAll(loaders);
    }

    @Override
    public Reader getReader(String templateName) throws LoaderException {
        Reader reader = null;
        for (Loader loader : this.loaders) {
            try {
                reader = loader.getReader(templateName);
            }
            catch (LoaderException e) {}
        }
        if (reader == null) {
            throw new LoaderException(null, "Could not find template \"" + templateName + "\"");
        }
        return reader;
    }

    public String getSuffix() {
        return this.suffix;
    }

    @Override
    public void setSuffix(String suffix) {
        this.suffix = suffix;
        for (Loader loader : this.loaders) {
            loader.setSuffix(suffix);
        }
    }

    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public void setPrefix(String prefix) {
        this.prefix = prefix;
        for (Loader loader : this.loaders) {
            loader.setPrefix(prefix);
        }
    }

    public String getCharset() {
        return this.charset;
    }

    @Override
    public void setCharset(String charset) {
        this.charset = charset;
        for (Loader loader : this.loaders) {
            loader.setCharset(charset);
        }
    }
}

