/*
 * Decompiled with CFR 0.152.
 */
package com.mitchellbosecke.pebble.node;

import com.mitchellbosecke.pebble.error.PebbleException;
import com.mitchellbosecke.pebble.extension.NodeVisitor;
import com.mitchellbosecke.pebble.node.AbstractRenderableNode;
import com.mitchellbosecke.pebble.node.expression.Expression;
import com.mitchellbosecke.pebble.template.EvaluationContext;
import com.mitchellbosecke.pebble.template.PebbleTemplateImpl;
import java.io.IOException;
import java.io.Writer;

public class IncludeNode
extends AbstractRenderableNode {
    private final Expression<?> includeExpression;

    public IncludeNode(int lineNumber, Expression<?> includeExpression) {
        super(lineNumber);
        this.includeExpression = includeExpression;
    }

    @Override
    public void render(PebbleTemplateImpl self, Writer writer, EvaluationContext context) throws PebbleException, IOException {
        String templateName = (String)this.includeExpression.evaluate(self, context);
        if (templateName == null) {
            throw new PebbleException(null, String.format("The template name in an include tag evaluated to NULL. If the template name is static, make sure to wrap it in quotes.", templateName), this.getLineNumber(), self.getName());
        }
        self.includeTemplate(writer, context, templateName);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    public Expression<?> getIncludeExpression() {
        return this.includeExpression;
    }
}

