/*
 * Decompiled with CFR 0.152.
 */
package com.mitchellbosecke.pebble.node.expression;

import com.mitchellbosecke.pebble.error.AttributeNotFoundException;
import com.mitchellbosecke.pebble.error.PebbleException;
import com.mitchellbosecke.pebble.extension.NodeVisitor;
import com.mitchellbosecke.pebble.node.ArgumentsNode;
import com.mitchellbosecke.pebble.node.PositionalArgumentNode;
import com.mitchellbosecke.pebble.node.expression.Expression;
import com.mitchellbosecke.pebble.template.EvaluationContext;
import com.mitchellbosecke.pebble.template.PebbleTemplateImpl;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class GetAttributeExpression
implements Expression<Object> {
    private final Expression<?> node;
    private final String attributeName;
    private final ArgumentsNode args;
    private final ConcurrentHashMap<Class<?>, Member> memberCache;

    public GetAttributeExpression(Expression<?> node, String attributeName) {
        this(node, attributeName, null);
    }

    public GetAttributeExpression(Expression<?> node, String attributeName, ArgumentsNode args) {
        this.node = node;
        this.attributeName = attributeName;
        this.args = args;
        this.memberCache = new ConcurrentHashMap(2, 0.9f, 1);
    }

    @Override
    public Object evaluate(PebbleTemplateImpl self, EvaluationContext context) throws PebbleException {
        Member member;
        Object object = this.node.evaluate(self, context);
        Object result = null;
        Object[] argumentValues = null;
        Member member2 = member = object == null ? null : this.memberCache.get(object.getClass());
        if (object != null && member == null) {
            if (this.args == null) {
                if (object instanceof Map && ((Map)object).containsKey(this.attributeName)) {
                    return ((Map)object).get(this.attributeName);
                }
                try {
                    if (object instanceof Object[]) {
                        Integer key = Integer.valueOf(this.attributeName);
                        Object[] arr = (Object[])object;
                        return arr[key];
                    }
                    if (object instanceof List) {
                        Integer key = Integer.valueOf(this.attributeName);
                        List list = (List)object;
                        return list.get(key);
                    }
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
            }
            argumentValues = this.getArgumentValues(self, context);
            Class[] argumentTypes = new Class[argumentValues.length];
            for (int i = 0; i < argumentValues.length; ++i) {
                argumentTypes[i] = argumentValues[i].getClass();
            }
            member = this.reflect(object, this.attributeName, argumentTypes);
            if (member != null) {
                this.memberCache.put(object.getClass(), member);
            }
        }
        if (object != null && member != null) {
            if (argumentValues == null) {
                argumentValues = this.getArgumentValues(self, context);
            }
            result = this.invokeMember(object, member, argumentValues);
        } else if (context.isStrictVariables()) {
            throw new AttributeNotFoundException(null, String.format("Attribute [%s] of [%s] does not exist or can not be accessed and strict variables is set to true.", this.attributeName, object.getClass().getName()));
        }
        return result;
    }

    private Object invokeMember(Object object, Member member, Object[] argumentValues) {
        Object result = null;
        try {
            if (member != null) {
                if (member instanceof Method) {
                    result = ((Method)member).invoke(object, argumentValues);
                } else if (member instanceof Field) {
                    result = ((Field)member).get(object);
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return result;
    }

    private Object[] getArgumentValues(PebbleTemplateImpl self, EvaluationContext context) throws PebbleException {
        Object[] argumentValues;
        if (this.args == null) {
            argumentValues = new Object[]{};
        } else {
            List<PositionalArgumentNode> args = this.args.getPositionalArgs();
            argumentValues = new Object[args.size()];
            int index = 0;
            for (PositionalArgumentNode arg : args) {
                Object argumentValue = arg.getValueExpression().evaluate(self, context);
                argumentValues[index] = argumentValue;
                ++index;
            }
        }
        return argumentValues;
    }

    private Member reflect(Object object, String attributeName, Class<?>[] parameterTypes) {
        Class<?> clazz = object.getClass();
        boolean found = false;
        AccessibleObject result = null;
        String attributeCapitalized = Character.toUpperCase(attributeName.charAt(0)) + attributeName.substring(1);
        if (!found) {
            try {
                result = clazz.getMethod("get" + attributeCapitalized, parameterTypes);
                found = true;
            }
            catch (NoSuchMethodException | SecurityException e) {
                // empty catch block
            }
        }
        if (!found) {
            try {
                result = clazz.getMethod("is" + attributeCapitalized, parameterTypes);
                found = true;
            }
            catch (NoSuchMethodException | SecurityException e) {
                // empty catch block
            }
        }
        if (!found) {
            try {
                result = clazz.getMethod("has" + attributeCapitalized, parameterTypes);
                found = true;
            }
            catch (NoSuchMethodException | SecurityException e) {
                // empty catch block
            }
        }
        if (!found) {
            try {
                result = clazz.getMethod(attributeName, parameterTypes);
                found = true;
            }
            catch (NoSuchMethodException | SecurityException e) {
                // empty catch block
            }
        }
        if (!found) {
            try {
                result = clazz.getField(attributeName);
                found = true;
            }
            catch (NoSuchFieldException | SecurityException e) {
                // empty catch block
            }
        }
        if (result != null) {
            ((AccessibleObject)result).setAccessible(true);
        }
        return result;
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    public Expression<?> getNode() {
        return this.node;
    }

    public String getAttribute() {
        return this.attributeName;
    }

    public ArgumentsNode getArgumentsNode() {
        return this.args;
    }
}

