/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.mpmetrics;

import android.annotation.TargetApi;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.util.Log;
import com.mixpanel.android.mpmetrics.MixpanelAPI;

public class GCMReceiver
extends BroadcastReceiver {
    String LOGTAG = "MPGCMReceiver";

    public void onReceive(Context context, Intent intent) {
        String action = intent.getAction();
        if ("com.google.android.c2dm.intent.REGISTRATION".equals(action)) {
            this.handleRegistrationIntent(intent);
        } else if ("com.google.android.c2dm.intent.RECEIVE".equals(action)) {
            this.handleNotificationIntent(context, intent);
        }
    }

    private void handleRegistrationIntent(Intent intent) {
        final String registration = intent.getStringExtra("registration_id");
        if (intent.getStringExtra("error") != null) {
            Log.e((String)this.LOGTAG, (String)("Error when registering for GCM: " + intent.getStringExtra("error")));
        } else if (registration != null) {
            MixpanelAPI.allInstances(new MixpanelAPI.InstanceProcessor(){

                @Override
                public void process(MixpanelAPI api) {
                    api.getPeople().setPushRegistrationId(registration);
                }
            });
        } else if (intent.getStringExtra("unregistered") != null) {
            MixpanelAPI.allInstances(new MixpanelAPI.InstanceProcessor(){

                @Override
                public void process(MixpanelAPI api) {
                    api.getPeople().clearPushRegistrationId();
                }
            });
        }
    }

    private void handleNotificationIntent(Context context, Intent intent) {
        String message = intent.getExtras().getString("mp_message");
        if (message == null) {
            return;
        }
        PackageManager manager = context.getPackageManager();
        Intent appIntent = manager.getLaunchIntentForPackage(context.getPackageName());
        CharSequence notificationTitle = "";
        int notificationIcon = 17301651;
        try {
            ApplicationInfo appInfo = manager.getApplicationInfo(context.getPackageName(), 0);
            notificationTitle = manager.getApplicationLabel(appInfo);
            notificationIcon = appInfo.icon;
        }
        catch (PackageManager.NameNotFoundException e) {
            // empty catch block
        }
        PendingIntent contentIntent = PendingIntent.getActivity((Context)context.getApplicationContext(), (int)0, (Intent)appIntent, (int)0x8000000);
        if (Build.VERSION.SDK_INT < 11) {
            this.showNotificationSDKLessThan11(context, contentIntent, notificationIcon, notificationTitle, message);
        } else {
            this.showNotificationSDK11OrHigher(context, contentIntent, notificationIcon, notificationTitle, message);
        }
    }

    @TargetApi(value=8)
    private void showNotificationSDKLessThan11(Context context, PendingIntent intent, int notificationIcon, CharSequence title, CharSequence message) {
        NotificationManager nm = (NotificationManager)context.getSystemService("notification");
        Notification n = new Notification(notificationIcon, message, System.currentTimeMillis());
        n.flags |= 0x10;
        n.setLatestEventInfo(context, title, message, intent);
        nm.notify(0, n);
    }

    private void showNotificationSDK11OrHigher(Context context, PendingIntent intent, int notificationIcon, CharSequence title, CharSequence message) {
        NotificationManager nm = (NotificationManager)context.getSystemService("notification");
        Notification.Builder builder = new Notification.Builder(context).setSmallIcon(notificationIcon).setTicker(message).setWhen(System.currentTimeMillis()).setContentTitle(title).setContentText(message).setContentIntent(intent);
        Notification n = Build.VERSION.SDK_INT < 16 ? builder.getNotification() : builder.build();
        n.flags |= 0x10;
        nm.notify(0, n);
    }
}

