/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.mpmetrics;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;

class MPConfig {
    public static final String VERSION = "4.0.0";
    public static final boolean DEBUG = false;
    public static final boolean DONT_SEND_SURVEYS = true;
    static final String REFERRER_PREFS_NAME = "com.mixpanel.android.mpmetrics.ReferralInfo";
    private final int mBulkUploadLimit;
    private final int mFlushInterval;
    private final int mDataExpiration;
    private final boolean mDisableFallback;
    private final String mEventsEndpoint;
    private final String mEventsFallbackEndpoint;
    private final String mPeopleEndpoint;
    private final String mPeopleFallbackEndpoint;
    private final String mDecideEndpoint;
    private final String mDecideFallbackEndpoint;
    private final boolean mAutoCheckForSurveys;
    private static final String LOGTAG = "MixpanelAPI.MPConfig";

    public static MPConfig readConfig(Context context) {
        String packageName = context.getPackageName();
        try {
            ApplicationInfo appInfo = context.getPackageManager().getApplicationInfo(packageName, 128);
            Bundle configBundle = appInfo.metaData;
            if (null == configBundle) {
                configBundle = new Bundle();
            }
            return new MPConfig(configBundle);
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new RuntimeException("Can't configure Mixpanel with package name " + packageName, e);
        }
    }

    public MPConfig(Bundle metaData) {
        this.mBulkUploadLimit = metaData.getInt("com.mixpanel.android.MPConfig.BulkUploadLimit", 40);
        this.mFlushInterval = metaData.getInt("com.mixpanel.android.MPConfig.FlushInterval", 60000);
        this.mDataExpiration = metaData.getInt("com.mixpanel.android.MPConfig.DataExpiration", 172800000);
        this.mDisableFallback = metaData.getBoolean("com.mixpanel.android.MPConfig.DisableFallback", true);
        this.mAutoCheckForSurveys = metaData.getBoolean("com.mixpanel.android.MPConfig.AutoCheckForSurveys", true);
        String eventsEndpoint = metaData.getString("com.mixpanel.android.MPConfig.EventsEndpoint");
        if (null == eventsEndpoint) {
            eventsEndpoint = "https://api.mixpanel.com/track?ip=1";
        }
        this.mEventsEndpoint = eventsEndpoint;
        String eventsFallbackEndpoint = metaData.getString("com.mixpanel.android.MPConfig.EventsFallbackEndpoint");
        if (null == eventsFallbackEndpoint) {
            eventsFallbackEndpoint = "http://api.mixpanel.com/track?ip=1";
        }
        this.mEventsFallbackEndpoint = eventsFallbackEndpoint;
        String peopleEndpoint = metaData.getString("com.mixpanel.android.MPConfig.PeopleEndpoint");
        if (null == peopleEndpoint) {
            peopleEndpoint = "https://api.mixpanel.com/engage";
        }
        this.mPeopleEndpoint = peopleEndpoint;
        String peopleFallbackEndpoint = metaData.getString("com.mixpanel.android.MPConfig.PeopleFallbackEndpoint");
        if (null == peopleFallbackEndpoint) {
            peopleFallbackEndpoint = "http://api.mixpanel.com/engage";
        }
        this.mPeopleFallbackEndpoint = peopleFallbackEndpoint;
        String decideEndpoint = metaData.getString("com.mixpanel.android.MPConfig.DecideEndpoint");
        if (null == decideEndpoint) {
            decideEndpoint = "https://decide.mixpanel.com/decide";
        }
        this.mDecideEndpoint = decideEndpoint;
        String decideFallbackEndpoint = metaData.getString("com.mixpanel.android.MPConfig.DecideFallbackEndpoint");
        if (null == decideFallbackEndpoint) {
            decideFallbackEndpoint = "http://decide.mixpanel.com/decide";
        }
        this.mDecideFallbackEndpoint = decideFallbackEndpoint;
    }

    public int getBulkUploadLimit() {
        return this.mBulkUploadLimit;
    }

    public int getFlushInterval() {
        return this.mFlushInterval;
    }

    public int getDataExpiration() {
        return this.mDataExpiration;
    }

    public boolean getDisableFallback() {
        return this.mDisableFallback;
    }

    public String getEventsEndpoint() {
        return this.mEventsEndpoint;
    }

    public String getPeopleEndpoint() {
        return this.mPeopleEndpoint;
    }

    public String getDecideEndpoint() {
        return this.mDecideEndpoint;
    }

    public String getEventsFallbackEndpoint() {
        return this.mEventsFallbackEndpoint;
    }

    public String getPeopleFallbackEndpoint() {
        return this.mPeopleFallbackEndpoint;
    }

    public String getDecideFallbackEndpoint() {
        return this.mDecideFallbackEndpoint;
    }

    public boolean getAutoCheckForSurveys() {
        return this.mAutoCheckForSurveys;
    }
}

