/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.mpmetrics;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentManager;
import android.app.FragmentTransaction;
import android.content.ActivityNotFoundException;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.ScaleAnimation;
import android.view.animation.TranslateAnimation;
import android.widget.ImageView;
import android.widget.TextView;
import com.mixpanel.android.R;
import com.mixpanel.android.mpmetrics.InAppNotification;
import com.mixpanel.android.mpmetrics.UpdateDisplayState;
import com.mixpanel.android.util.ActivityImageUtils;

@TargetApi(value=14)
public class InAppFragment
extends Fragment
implements View.OnClickListener {
    private Activity mParent;
    private Handler mHandler;
    private int mDisplayStateId;
    private UpdateDisplayState mDisplayState;
    private Runnable mRemover;
    private Runnable mDisplayMini;
    private View mInAppView;
    private boolean mKill;
    private static final String LOGTAG = "InAppFragment";
    private static final int MINI_REMOVE_TIME = 6000;

    public void setDisplayState(int stateId, UpdateDisplayState displayState) {
        this.mDisplayStateId = stateId;
        this.mDisplayState = displayState;
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        this.mParent = activity;
        this.mHandler = new Handler();
        this.mRemover = new Runnable(){

            @Override
            public void run() {
                InAppFragment.this.remove();
            }
        };
        this.mDisplayMini = new Runnable(){

            @Override
            public void run() {
                InAppFragment.this.mInAppView.setVisibility(0);
                int highlightColor = ActivityImageUtils.getHighlightColorFromBackground(InAppFragment.this.mParent);
                InAppFragment.this.mInAppView.setBackgroundColor(highlightColor);
                ImageView notifImage = (ImageView)InAppFragment.this.mInAppView.findViewById(R.id.com_mixpanel_android_notification_image);
                float heightPx = TypedValue.applyDimension((int)1, (float)75.0f, (DisplayMetrics)InAppFragment.this.mParent.getResources().getDisplayMetrics());
                TranslateAnimation translate = new TranslateAnimation(0.0f, 0.0f, heightPx, 0.0f);
                translate.setInterpolator((Interpolator)new DecelerateInterpolator());
                translate.setDuration(200L);
                InAppFragment.this.mInAppView.startAnimation((Animation)translate);
                ScaleAnimation scale = new ScaleAnimation(0.0f, 1.0f, 0.0f, 1.0f, heightPx / 2.0f, heightPx / 2.0f);
                scale.setInterpolator((Interpolator)new SineBounceInterpolator());
                scale.setDuration(400L);
                scale.setStartOffset(200L);
                notifImage.startAnimation((Animation)scale);
            }
        };
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mKill = false;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        super.onCreateView(inflater, container, savedInstanceState);
        this.mInAppView = inflater.inflate(R.layout.com_mixpanel_android_activity_notification_mini, container, false);
        TextView titleView = (TextView)this.mInAppView.findViewById(R.id.com_mixpanel_android_notification_title);
        ImageView notifImage = (ImageView)this.mInAppView.findViewById(R.id.com_mixpanel_android_notification_image);
        UpdateDisplayState.DisplayState.InAppNotificationState notificationState = (UpdateDisplayState.DisplayState.InAppNotificationState)this.mDisplayState.getDisplayState();
        InAppNotification inApp = notificationState.getInAppNotification();
        titleView.setText((CharSequence)inApp.getTitle());
        notifImage.setImageBitmap(inApp.getImage());
        this.mHandler.postDelayed(this.mRemover, 6000L);
        this.mInAppView.setOnClickListener((View.OnClickListener)this);
        return this.mInAppView;
    }

    public void onStart() {
        super.onStart();
        if (this.mKill) {
            this.mParent.getFragmentManager().beginTransaction().remove((Fragment)this).commit();
        }
    }

    public void onResume() {
        super.onResume();
        this.mHandler.postDelayed(this.mDisplayMini, 500L);
    }

    public void onStop() {
        super.onStop();
        this.mHandler.removeCallbacks(this.mRemover);
        this.mHandler.removeCallbacks(this.mDisplayMini);
        this.mKill = true;
        UpdateDisplayState.releaseDisplayState(this.mDisplayStateId);
    }

    public void onClick(View clicked) {
        UpdateDisplayState.DisplayState.InAppNotificationState notificationState = (UpdateDisplayState.DisplayState.InAppNotificationState)this.mDisplayState.getDisplayState();
        InAppNotification inApp = notificationState.getInAppNotification();
        String uriString = inApp.getCallToActionUrl();
        if (uriString != null && uriString.length() > 0) {
            Uri uri = null;
            try {
                uri = Uri.parse((String)uriString);
            }
            catch (IllegalArgumentException e) {
                Log.i((String)LOGTAG, (String)"Can't parse notification URI, will not take any action", (Throwable)e);
                return;
            }
            assert (uri != null);
            try {
                Intent viewIntent = new Intent("android.intent.action.VIEW", uri);
                this.mParent.startActivity(viewIntent);
            }
            catch (ActivityNotFoundException e) {
                Log.i((String)LOGTAG, (String)"User doesn't have an activity for notification URI");
            }
        }
        this.remove();
    }

    private void remove() {
        if (this.mParent != null) {
            FragmentManager fragmentManager = this.mParent.getFragmentManager();
            FragmentTransaction transaction = fragmentManager.beginTransaction();
            transaction.setCustomAnimations(0, R.anim.com_mixpanel_android_slide_down).remove((Fragment)this).commit();
        }
    }

    private class SineBounceInterpolator
    implements Interpolator {
        public float getInterpolation(float t) {
            return (float)(-(Math.pow(Math.E, -8.0f * t) * Math.cos(12.0f * t))) + 1.0f;
        }
    }
}

